/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.realm.ldap;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.config.Configuration;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.security.AXSchemaType;
import org.exist.security.AbstractAccount;
import org.exist.security.AbstractRealm;
import org.exist.security.Account;
import org.exist.security.AuthenticationException;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.SecurityManagerImpl;
import org.exist.security.internal.SubjectAccreditedImpl;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.security.realm.ldap.AbstractLDAPSearchPrincipal;
import org.exist.security.realm.ldap.LDAPSearchAccount;
import org.exist.security.realm.ldap.LDAPSearchContext;
import org.exist.security.realm.ldap.LdapContextFactory;
import org.exist.security.realm.ldap.LdapUtils;
import org.exist.storage.DBBroker;

@ConfigurationClass(value="realm")
public class LDAPRealm
extends AbstractRealm {
    private static final Logger LOG = LogManager.getLogger(LDAPRealm.class);
    @ConfigurationFieldAsAttribute(value="id")
    public static String ID = "LDAP";
    @ConfigurationFieldAsAttribute(value="version")
    public static final String version = "1.0";
    @ConfigurationFieldAsAttribute(value="principals-are-case-insensitive")
    private boolean principalsAreCaseInsensitive;
    @ConfigurationFieldAsElement(value="context")
    protected LdapContextFactory ldapContextFactory;

    public LDAPRealm(SecurityManagerImpl sm, Configuration config) {
        super((SecurityManager)sm, config);
    }

    protected LdapContextFactory ensureContextFactory() {
        if (this.ldapContextFactory == null) {
            LdapContextFactory factory;
            if (LOG.isDebugEnabled()) {
                LOG.debug("No LdapContextFactory specified - creating a default instance.");
            }
            this.ldapContextFactory = factory = new LdapContextFactory(this.configuration);
        }
        return this.ldapContextFactory;
    }

    public String getId() {
        return ID;
    }

    public void start(DBBroker broker) throws EXistException {
        super.start(broker);
    }

    private String ensureCase(String username) {
        if (username == null) {
            return null;
        }
        if (this.principalsAreCaseInsensitive) {
            return username.toLowerCase();
        }
        return username;
    }

    public Subject authenticate(String username, Object credentials) throws AuthenticationException {
        AuthenticatedLdapSubjectAccreditedImpl authenticatedLdapSubjectAccreditedImpl;
        String name = this.ensureCase(username);
        LdapContext ctx = null;
        try {
            ctx = this.ensureContextFactory().getLdapContext(name, String.valueOf(credentials));
            AbstractAccount account = (AbstractAccount)this.getAccount(ctx, name);
            if (account == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Account '" + name + "' can not be found.");
                }
                throw new AuthenticationException(0, "Account '" + name + "' can not be found.");
            }
            authenticatedLdapSubjectAccreditedImpl = new AuthenticatedLdapSubjectAccreditedImpl(account, ctx, String.valueOf(credentials));
        }
        catch (NamingException e) {
            try {
                LOG.debug(e.getMessage(), (Throwable)e);
                if (e instanceof javax.naming.AuthenticationException) {
                    throw new AuthenticationException(0, e.getMessage());
                }
                throw new AuthenticationException(-1, e.getMessage());
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext(ctx);
        return authenticatedLdapSubjectAccreditedImpl;
    }

    private List<Group> getGroupMembershipForLdapUser(LdapContext ctx, DBBroker broker, SearchResult ldapUser) throws NamingException {
        List<String> additionalGroupNames;
        ArrayList<Group> memberOf_groups = new ArrayList<Group>();
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        String userDistinguishedName = (String)ldapUser.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.DN)).get();
        List<String> memberOf_groupNames = this.findGroupnamesForUserDistinguishedName(ctx, userDistinguishedName);
        for (String memberOf_groupName : memberOf_groupNames) {
            memberOf_groups.add(this.getGroup(ctx, broker, memberOf_groupName));
        }
        if (this.ensureContextFactory().getTransformationContext() != null && (additionalGroupNames = this.ensureContextFactory().getTransformationContext().getAdditionalGroups()) != null) {
            for (String additionalGroupName : additionalGroupNames) {
                Group additionalGroup = this.getSecurityManager().getGroup(additionalGroupName);
                if (additionalGroup == null) continue;
                memberOf_groups.add(additionalGroup);
            }
        }
        return memberOf_groups;
    }

    private List<AbstractMap.SimpleEntry<AXSchemaType, String>> getMetadataForLdapUser(SearchResult ldapUser) throws NamingException {
        ArrayList<AbstractMap.SimpleEntry<AXSchemaType, String>> metadata = new ArrayList<AbstractMap.SimpleEntry<AXSchemaType, String>>();
        LDAPSearchAccount searchAccount = this.ensureContextFactory().getSearch().getSearchAccount();
        Attributes userAttributes = ldapUser.getAttributes();
        for (AXSchemaType axSchemaType : searchAccount.getMetadataSearchAttributeKeys()) {
            Attribute userAttribute;
            String searchAttribute = searchAccount.getMetadataSearchAttribute(axSchemaType);
            if (userAttributes == null || (userAttribute = userAttributes.get(searchAttribute)) == null) continue;
            String attributeValue = userAttribute.get().toString();
            metadata.add(new AbstractMap.SimpleEntry<AXSchemaType, String>(axSchemaType, attributeValue));
        }
        return metadata;
    }

    public Account refreshAccountFromLdap(final Account account) throws PermissionDeniedException, AuthenticationException {
        boolean UPDATE_NONE = false;
        boolean UPDATE_GROUP = true;
        int UPDATE_METADATA = 2;
        Subject invokingUser = this.getSecurityManager().getCurrentSubject();
        if (!invokingUser.hasDbaRole() && invokingUser.getId() != account.getId()) {
            throw new PermissionDeniedException("You do not have permission to modify the account");
        }
        try {
            LdapContext ctx = this.getContext(invokingUser);
            final SearchResult ldapUser = this.findAccountByAccountName(ctx, account.getName());
            if (ldapUser == null) {
                throw new AuthenticationException(0, "Could not find the account in the LDAP");
            }
            return this.executeAsSystemUser(ctx, new Unit<Account>(){

                @Override
                public Account execute(LdapContext ctx, DBBroker broker) throws EXistException, PermissionDeniedException, NamingException {
                    boolean updated;
                    int update = 0;
                    List memberOf_groups = LDAPRealm.this.getGroupMembershipForLdapUser(ctx, broker, ldapUser);
                    String primaryGroup = LDAPRealm.this.findGroupBySID(ctx, LDAPRealm.this.getPrimaryGroupSID(ldapUser));
                    memberOf_groups.add(0, LDAPRealm.this.getGroup(ctx, broker, primaryGroup));
                    String[] accountGroups = account.getGroups();
                    if (!accountGroups[0].equals(LDAPRealm.this.ensureCase(primaryGroup))) {
                        update |= 1;
                    } else if (accountGroups.length != memberOf_groups.size()) {
                        update |= 1;
                    } else {
                        for (int i = 0; i < accountGroups.length; ++i) {
                            boolean found = false;
                            for (Group memberOf_group : memberOf_groups) {
                                if (!accountGroups[i].equals(LDAPRealm.this.ensureCase(memberOf_group.getName()))) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            update |= 1;
                            break;
                        }
                    }
                    List ldapMetadatas = LDAPRealm.this.getMetadataForLdapUser(ldapUser);
                    Set accountMetadataKeys = account.getMetadataKeys();
                    if (accountMetadataKeys.size() != ldapMetadatas.size()) {
                        update |= 2;
                    } else {
                        for (SchemaType accountMetadataKey : accountMetadataKeys) {
                            String accountMetadataValue = account.getMetadataValue(accountMetadataKey);
                            boolean found = false;
                            for (AbstractMap.SimpleEntry ldapMetadata : ldapMetadatas) {
                                if (!accountMetadataKey.equals(ldapMetadata.getKey()) || !accountMetadataValue.equals(ldapMetadata.getValue())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            update |= 2;
                            break;
                        }
                    }
                    if ((update & 1) == 1) {
                        try {
                            Field fld = account.getClass().getSuperclass().getDeclaredField("groups");
                            fld.setAccessible(true);
                            fld.set(account, memberOf_groups);
                        }
                        catch (NoSuchFieldException nsfe) {
                            throw new EXistException(nsfe.getMessage(), (Throwable)nsfe);
                        }
                        catch (IllegalAccessException iae) {
                            throw new EXistException(iae.getMessage(), (Throwable)iae);
                        }
                    }
                    if ((update & 2) == 2) {
                        account.clearMetadata();
                        for (AbstractMap.SimpleEntry ldapMetadata : ldapMetadatas) {
                            account.setMetadataValue((SchemaType)ldapMetadata.getKey(), (String)ldapMetadata.getValue());
                        }
                    }
                    if (update != 0 && !(updated = LDAPRealm.this.getSecurityManager().updateAccount(account))) {
                        LOG.error("Could not update account");
                    }
                    return account;
                }
            });
        }
        catch (NamingException ne) {
            throw new AuthenticationException(-1, ne.getMessage(), (Throwable)ne);
        }
        catch (EXistException ee) {
            throw new AuthenticationException(-1, ee.getMessage(), (Throwable)ee);
        }
    }

    private Account createAccountInDatabase(LdapContext ctx, final String username, final SearchResult ldapUser, final String primaryGroupName) throws AuthenticationException {
        LDAPSearchAccount searchAccount = this.ensureContextFactory().getSearch().getSearchAccount();
        try {
            return this.executeAsSystemUser(ctx, new Unit<Account>(){

                @Override
                public Account execute(LdapContext ctx, DBBroker broker) throws EXistException, PermissionDeniedException, NamingException {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Saving account '" + username + "'.");
                    }
                    Group primaryGroup = LDAPRealm.this.getGroup(ctx, broker, primaryGroupName);
                    UserAider userAider = new UserAider(ID, username, primaryGroup);
                    for (Group memberOf_group : LDAPRealm.this.getGroupMembershipForLdapUser(ctx, broker, ldapUser)) {
                        userAider.addGroup(memberOf_group);
                    }
                    for (AbstractMap.SimpleEntry metadata : LDAPRealm.this.getMetadataForLdapUser(ldapUser)) {
                        userAider.setMetadataValue((SchemaType)metadata.getKey(), (String)metadata.getValue());
                    }
                    Account account = LDAPRealm.this.getSecurityManager().addAccount((Account)userAider);
                    return account;
                }
            });
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw new AuthenticationException(-1, e.getMessage(), (Throwable)e);
        }
    }

    private <R> R executeAsSystemUser(LdapContext ctx, Unit<R> unit) throws EXistException, PermissionDeniedException, NamingException {
        try (DBBroker broker = this.getDatabase().get(Optional.of(this.getSecurityManager().getSystemSubject()));){
            R r = unit.execute(ctx, broker);
            return r;
        }
    }

    private Group createGroupInDatabase(DBBroker broker, String groupname) throws AuthenticationException {
        try {
            return this.getSecurityManager().addGroup(broker, (Group)new GroupAider(ID, groupname));
        }
        catch (Exception e) {
            throw new AuthenticationException(-1, e.getMessage(), (Throwable)e);
        }
    }

    private LdapContext getContext(Subject invokingUser) throws NamingException {
        LdapContext ctx;
        LdapContextFactory ctxFactory = this.ensureContextFactory();
        if (invokingUser != null && invokingUser instanceof AuthenticatedLdapSubjectAccreditedImpl) {
            ctx = ctxFactory.getLdapContext(invokingUser.getUsername(), ((AuthenticatedLdapSubjectAccreditedImpl)invokingUser).getAuthenticatedCredentials(), null);
        } else {
            LDAPSearchContext searchCtx = ctxFactory.getSearch();
            ctx = ctxFactory.getLdapContext(searchCtx.getDefaultUsername(), searchCtx.getDefaultPassword(), null);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Account getAccount(String name) {
        Account account;
        block6: {
            Account acct = super.getAccount(name = this.ensureCase(name));
            if (acct != null) {
                return acct;
            }
            LdapContext ctx = null;
            try {
                ctx = this.getContext(this.getSecurityManager().getDatabase().getActiveBroker().getCurrentSubject());
                account = this.getAccount(ctx, name);
                if (ctx == null) break block6;
            }
            catch (NamingException ne) {
                Account account2;
                block7: {
                    try {
                        LOG.debug(ne.getMessage(), (Throwable)ne);
                        LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
                        account2 = null;
                        if (ctx == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (ctx != null) {
                            LdapUtils.closeContext(ctx);
                        }
                        throw throwable;
                    }
                    LdapUtils.closeContext(ctx);
                }
                return account2;
            }
            LdapUtils.closeContext(ctx);
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Account getAccount(LdapContext ctx, String name) {
        Account acct;
        name = this.ensureCase(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get request for account '" + name + "'.");
        }
        if ((acct = super.getAccount(name)) != null) {
            LOG.debug("Cached used.");
            return acct;
        }
        try {
            SearchResult ldapUser = this.findAccountByAccountName(ctx, name);
            LOG.debug("LDAP search return '" + ldapUser + "'.");
            if (ldapUser == null) {
                Account account = null;
                return account;
            }
            String primaryGroupSID = this.getPrimaryGroupSID(ldapUser);
            String primaryGroup = this.findGroupBySID(ctx, primaryGroupSID);
            if (LOG.isDebugEnabled()) {
                LOG.debug("LDAP search for primary group by SID '" + primaryGroupSID + "', found '" + primaryGroup + "'.");
            }
            if (primaryGroup == null) {
                Account account = null;
                return account;
            }
            Account account = this.createAccountInDatabase(ctx, name, ldapUser, this.ensureCase(primaryGroup));
            return account;
        }
        catch (NamingException ne) {
            LOG.debug(ne.getMessage(), (Throwable)ne);
            Account account = null;
            return account;
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
    }

    private static String decodeSID(byte[] sid) {
        StringBuilder strSid = new StringBuilder("S-");
        byte revision = sid[0];
        strSid.append(Integer.toString(revision));
        int countSubAuths = sid[1] & 0xFF;
        long authority = 0L;
        for (int i = 2; i <= 7; ++i) {
            authority |= (long)sid[i] << 8 * (5 - (i - 2));
        }
        strSid.append("-");
        strSid.append(Long.toHexString(authority));
        int offset = 8;
        int size = 4;
        for (int j = 0; j < countSubAuths; ++j) {
            long subAuthority = 0L;
            for (int k = 0; k < size; ++k) {
                subAuthority |= (long)(sid[offset + k] & 0xFF) << 8 * k;
            }
            strSid.append("-");
            strSid.append(subAuthority);
            offset += size;
        }
        return strSid.toString();
    }

    private String getPrimaryGroupSID(SearchResult ldapUser) throws NamingException {
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        Object objSID = ldapUser.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.OBJECT_SID)).get();
        String strObjectSid = objSID instanceof String ? objSID.toString() : LDAPRealm.decodeSID((byte[])objSID);
        String strPrimaryGroupID = (String)ldapUser.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.PRIMARY_GROUP_ID)).get();
        return strObjectSid.substring(0, strObjectSid.lastIndexOf(45) + 1) + strPrimaryGroupID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Group getGroup(Subject invokingUser, DBBroker broker, String name) {
        Group grp = this.getGroup(name = this.ensureCase(name));
        if (grp != null) {
            return grp;
        }
        LdapContext ctx = null;
        try {
            ctx = this.getContext(invokingUser);
            Group group = this.getGroup(ctx, broker, name);
            return group;
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
            Group group = null;
            return group;
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Group getGroup(LdapContext ctx, DBBroker broker, String name) {
        if (name == null) {
            return null;
        }
        String gName = this.ensureCase(name);
        Group grp = this.getGroup(gName);
        if (grp != null) {
            return grp;
        }
        try {
            SearchResult ldapGroup = this.findGroupByGroupName(ctx, this.removeDomainPostfix(gName));
            if (ldapGroup == null) {
                Group group = null;
                return group;
            }
            Group group = this.createGroupInDatabase(broker, gName);
            return group;
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
            Group group = null;
            return group;
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
    }

    private String addDomainPostfix(String principalName) {
        String name = principalName;
        if (name.indexOf("@") == -1) {
            name = name + '@' + this.ensureContextFactory().getDomain();
        }
        return name;
    }

    private String removeDomainPostfix(String principalName) {
        String name = principalName;
        if (name.indexOf(64) > -1 && name.endsWith(this.ensureContextFactory().getDomain())) {
            name = name.substring(0, name.indexOf(64));
        }
        return name;
    }

    private boolean checkAccountRestrictionList(String accountname) {
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        return this.checkPrincipalRestrictionList(accountname, search.getSearchAccount());
    }

    private boolean checkGroupRestrictionList(String groupname) {
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        return this.checkPrincipalRestrictionList(groupname, search.getSearchGroup());
    }

    private boolean checkPrincipalRestrictionList(String principalName, AbstractLDAPSearchPrincipal searchPrinciple) {
        String name = this.ensureCase(principalName);
        if (name.indexOf(64) > -1) {
            name = name.substring(0, name.indexOf(64));
        }
        List<String> blackList = null;
        if (searchPrinciple.getBlackList() != null) {
            blackList = searchPrinciple.getBlackList().getPrincipals();
        }
        List<String> whiteList = null;
        if (searchPrinciple.getWhiteList() != null) {
            whiteList = searchPrinciple.getWhiteList().getPrincipals();
        }
        if (blackList != null) {
            for (String blackEntry : blackList) {
                if (!this.ensureCase(blackEntry).equals(name)) continue;
                return false;
            }
        }
        if (whiteList != null && whiteList.size() > 0) {
            for (String whiteEntry : whiteList) {
                if (!this.ensureCase(whiteEntry).equals(name)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private SearchResult findAccountByAccountName(DirContext ctx, String accountName) throws NamingException {
        if (!this.checkAccountRestrictionList(accountName)) {
            return null;
        }
        String userName = this.removeDomainPostfix(accountName);
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        SearchAttribute sa = new SearchAttribute(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME), userName);
        String searchFilter = this.buildSearchFilter(search.getSearchAccount().getSearchFilterPrefix(), sa);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
        SearchResult searchResult = null;
        if (results.hasMoreElements()) {
            searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                LOG.error("Matched multiple users for the accountName: " + accountName);
            }
        }
        return searchResult;
    }

    private String findGroupBySID(DirContext ctx, String sid) throws NamingException {
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        SearchAttribute sa = new SearchAttribute(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.OBJECT_SID), sid);
        String searchFilter = this.buildSearchFilter(search.getSearchGroup().getSearchFilterPrefix(), sa);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(search.getAbsoluteBase(), searchFilter, searchControls);
        if (results.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                LOG.error("Matched multiple groups for the group with SID: " + sid);
                return null;
            }
            return this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get());
        }
        LOG.error("Matched no group with SID: " + sid);
        return null;
    }

    private SearchResult findGroupByGroupName(DirContext ctx, String groupName) throws NamingException {
        if (!this.checkGroupRestrictionList(groupName)) {
            return null;
        }
        LDAPSearchContext search = this.ensureContextFactory().getSearch();
        SearchAttribute sa = new SearchAttribute(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME), groupName);
        String searchFilter = this.buildSearchFilter(search.getSearchGroup().getSearchFilterPrefix(), sa);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(search.getAbsoluteBase(), searchFilter, searchControls);
        if (results.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                LOG.error("Matched multiple groups for the groupName: " + groupName);
                return null;
            }
            return searchResult;
        }
        LOG.error("Matched no groups for the groupName: " + groupName);
        return null;
    }

    public boolean isConfigured() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean updateAccount(Account account) throws PermissionDeniedException, EXistException {
        return super.updateAccount(account);
    }

    public boolean deleteAccount(Account account) throws PermissionDeniedException, EXistException {
        return false;
    }

    public boolean updateGroup(Group group) throws PermissionDeniedException, EXistException {
        return super.updateGroup(group);
    }

    public boolean deleteGroup(Group group) throws PermissionDeniedException, EXistException {
        return false;
    }

    private String buildSearchFilter(String searchPrefix, SearchAttribute sa) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.buildSearchCriteria(searchPrefix));
        if (sa.getName() != null && sa.getValue() != null) {
            builder.append("(");
            builder.append(sa.getName());
            builder.append("=");
            builder.append(sa.getValue());
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    private String buildSearchFilterUnion(String searchPrefix, List<SearchAttribute> searchAttributes) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.buildSearchCriteria(searchPrefix));
        if (!searchAttributes.isEmpty()) {
            builder.append("(|");
            for (SearchAttribute sa : searchAttributes) {
                builder.append("(");
                builder.append(sa.getName());
                builder.append("=");
                builder.append(sa.getValue());
                builder.append(")");
            }
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    private String buildSearchCriteria(String searchPrefix) {
        return "&(" + searchPrefix + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findUsernamesWhereNameStarts(String startsWith) {
        startsWith = this.ensureCase(startsWith);
        ArrayList<String> usernames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(search.getSearchAccount().getMetadataSearchAttribute(AXSchemaType.FULLNAME), startsWith + "*");
            String searchFilter = this.buildSearchFilter(search.getSearchAccount().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String username = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkAccountRestrictionList(username)) continue;
                usernames.add(username);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return usernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findUsernamesWhereNamePartStarts(String startsWith) {
        String sWith = this.ensureCase(startsWith);
        ArrayList<String> usernames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute firstNameSa = new SearchAttribute(search.getSearchAccount().getMetadataSearchAttribute(AXSchemaType.FIRSTNAME), sWith + "*");
            SearchAttribute lastNameSa = new SearchAttribute(search.getSearchAccount().getMetadataSearchAttribute(AXSchemaType.LASTNAME), sWith + "*");
            ArrayList<SearchAttribute> sas = new ArrayList<SearchAttribute>();
            sas.add(firstNameSa);
            sas.add(lastNameSa);
            String searchFilter = this.buildSearchFilterUnion(search.getSearchAccount().getSearchFilterPrefix(), sas);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String username = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkAccountRestrictionList(username)) continue;
                usernames.add(username);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return usernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findUsernamesWhereUsernameStarts(String startsWith) {
        String sWith = this.ensureCase(startsWith);
        ArrayList<String> usernames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME), sWith + "*");
            String searchFilter = this.buildSearchFilter(search.getSearchAccount().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String username = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkAccountRestrictionList(username)) continue;
                usernames.add(username);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return usernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findGroupnamesForUserDistinguishedName(LdapContext ctx, String userDistinguishedName) {
        ArrayList<String> groupnames = new ArrayList<String>();
        try {
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.MEMBER), userDistinguishedName);
            String searchFilter = this.buildSearchFilter(search.getSearchGroup().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getAbsoluteBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String groupname = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkGroupRestrictionList(groupname)) continue;
                groupnames.add(groupname);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return groupnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findGroupnamesWhereGroupnameStarts(String startsWith) {
        String sWith = this.ensureCase(startsWith);
        ArrayList<String> groupnames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME), sWith + "*");
            String searchFilter = this.buildSearchFilter(search.getSearchGroup().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String groupname = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkGroupRestrictionList(groupname)) continue;
                groupnames.add(groupname);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return groupnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findGroupnamesWhereGroupnameContains(String fragment) {
        String part = this.ensureCase(fragment);
        ArrayList<String> groupnames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME), "*" + part + "*");
            String searchFilter = this.buildSearchFilter(search.getSearchGroup().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String groupname = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkGroupRestrictionList(groupname)) continue;
                groupnames.add(groupname);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)ne);
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return groupnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findAllGroupNames() {
        ArrayList<String> groupnames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(null, null);
            String searchFilter = this.buildSearchFilter(search.getSearchGroup().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String groupname = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkGroupRestrictionList(groupname)) continue;
                groupnames.add(groupname);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return groupnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findAllUserNames() {
        ArrayList<String> usernames = new ArrayList<String>();
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            SearchAttribute sa = new SearchAttribute(null, null);
            String searchFilter = this.buildSearchFilter(search.getSearchAccount().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String accountname = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkAccountRestrictionList(accountname)) continue;
                usernames.add(accountname);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return usernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findAllGroupMembers(String groupName) {
        String name = this.ensureCase(groupName);
        ArrayList<String> groupMembers = new ArrayList<String>();
        if (!this.checkGroupRestrictionList(name)) {
            return groupMembers;
        }
        LdapContext ctx = null;
        try {
            ctx = this.getContext(this.getSecurityManager().getCurrentSubject());
            SearchResult searchResult = this.findGroupByGroupName(ctx, this.removeDomainPostfix(name));
            LDAPSearchContext search = this.ensureContextFactory().getSearch();
            String dnGroup = (String)searchResult.getAttributes().get(search.getSearchGroup().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.DN)).get();
            SearchAttribute sa = new SearchAttribute(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.MEMBER_OF), dnGroup);
            String searchFilter = this.buildSearchFilter(search.getSearchAccount().getSearchFilterPrefix(), sa);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)});
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), searchFilter, searchControls);
            while (results.hasMoreElements()) {
                searchResult = (SearchResult)results.nextElement();
                String member = this.ensureCase(this.addDomainPostfix((String)searchResult.getAttributes().get(search.getSearchAccount().getSearchAttribute(AbstractLDAPSearchPrincipal.LDAPSearchAttributeKey.NAME)).get()));
                if (!this.checkAccountRestrictionList(member)) continue;
                groupMembers.add(member);
            }
        }
        catch (NamingException ne) {
            LOG.error((Object)new AuthenticationException(-1, ne.getMessage()));
        }
        finally {
            if (ctx != null) {
                LdapUtils.closeContext(ctx);
            }
        }
        return groupMembers;
    }

    private final class AuthenticatedLdapSubjectAccreditedImpl
    extends SubjectAccreditedImpl {
        private final String authenticatedCredentials;

        private AuthenticatedLdapSubjectAccreditedImpl(AbstractAccount account, LdapContext ctx, String authenticatedCredentials) {
            super(account, (Object)ctx);
            this.authenticatedCredentials = authenticatedCredentials;
        }

        private String getAuthenticatedCredentials() {
            return this.authenticatedCredentials;
        }
    }

    private class SearchAttribute {
        private final String name;
        private final String value;

        public SearchAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static interface Unit<R> {
        public R execute(LdapContext var1, DBBroker var2) throws EXistException, PermissionDeniedException, NamingException;
    }
}

