/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.realm.ldap;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.security.realm.ldap.LDAPSearchContext;
import org.exist.security.realm.ldap.LDAPTransformationContext;

@ConfigurationClass(value="context")
public class LdapContextFactory
implements Configurable {
    protected static final Logger LOG = LogManager.getLogger(LdapContextFactory.class);
    protected static final String SUN_CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    @ConfigurationFieldAsElement(value="authentication")
    protected String authentication = "simple";
    @ConfigurationFieldAsElement(value="use-ssl")
    private final boolean ssl = false;
    @ConfigurationFieldAsElement(value="principal-pattern")
    protected String principalPattern = null;
    protected MessageFormat principalPatternFormat;
    @ConfigurationFieldAsElement(value="url")
    protected String url = null;
    @ConfigurationFieldAsElement(value="domain")
    protected String domain = null;
    protected String contextFactoryClassName = "com.sun.jndi.ldap.LdapCtxFactory";
    protected String systemUsername = null;
    protected String systemPassword = null;
    private boolean usePooling = true;
    private Configuration configuration = null;
    @ConfigurationFieldAsElement(value="search")
    private LDAPSearchContext search;
    @ConfigurationFieldAsElement(value="transformation")
    private LDAPTransformationContext realmTransformation;

    public LdapContextFactory(Configuration config) {
        this.configuration = Configurator.configure((Configurable)this, (Configuration)config);
        if (this.principalPattern != null) {
            this.principalPatternFormat = new MessageFormat(this.principalPattern);
        }
    }

    public LdapContext getSystemLdapContext() throws NamingException {
        return this.getLdapContext(this.systemUsername, this.systemPassword);
    }

    public LdapContext getLdapContext(String username, String password) throws NamingException {
        return this.getLdapContext(username, password, null);
    }

    public LdapContext getLdapContext(String username, String password, Map<String, Object> additionalEnv) throws NamingException {
        if (this.url == null) {
            throw new IllegalStateException("An LDAP URL must be specified of the form ldap://<hostname>:<port>");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalStateException("Password for LDAP authentication may not be empty.");
        }
        if (username != null && this.principalPattern != null) {
            username = this.principalPatternFormat.format(new String[]{username});
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.security.authentication", this.authentication);
        if (username != null) {
            env.put("java.naming.security.principal", username);
        }
        if (password != null) {
            env.put("java.naming.security.credentials", password);
        }
        env.put("java.naming.factory.initial", this.contextFactoryClassName);
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.ldap.attributes.binary", "objectSid");
        if (this.usePooling && username != null && username.equals(this.systemUsername)) {
            env.put(SUN_CONNECTION_POOLING_PROPERTY, "true");
        }
        if (additionalEnv != null) {
            env.putAll(additionalEnv);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing LDAP context using URL [" + this.url + "] and username [" + username + "] with pooling [" + (this.usePooling ? "enabled" : "disabled") + "]");
        }
        return new InitialLdapContext(env, null);
    }

    public LDAPSearchContext getSearch() {
        return this.search;
    }

    public LDAPTransformationContext getTransformationContext() {
        return this.realmTransformation;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isConfigured() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

