/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.realm.ldap.xquery;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.realm.Realm;
import org.exist.security.realm.ldap.LDAPRealm;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class AccountFunctions
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("update-account", "http://exist-db.org/security/ldap/xquery", "ldap"), "Refreshed the cached LDAP account details from the LDAP directory", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(10, 1))};

    public AccountFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SecurityManager sm = this.context.getBroker().getBrokerPool().getSecurityManager();
        LDAPRealm ldapRealm = this.getLdapRealm(sm);
        String accountName = args[0].itemAt(0).getStringValue();
        Account ldapAccount = sm.getAccount(accountName);
        if (ldapAccount == null) {
            throw new XPathException("The Account '" + accountName + "' does not exist!");
        }
        try {
            ldapRealm.refreshAccountFromLdap(ldapAccount);
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, (Throwable)pde);
        }
        catch (AuthenticationException ae) {
            throw new XPathException((Expression)this, (Throwable)ae);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private LDAPRealm getLdapRealm(SecurityManager sm) throws XPathException {
        try {
            Method mFindRealm = sm.getClass().getDeclaredMethod("findRealmForRealmId", String.class);
            mFindRealm.setAccessible(true);
            Realm realm = (Realm)mFindRealm.invoke((Object)sm, LDAPRealm.ID);
            if (realm == null) {
                throw new XPathException("The LDAP Realm is not in use!");
            }
            return (LDAPRealm)realm;
        }
        catch (NoSuchMethodException ex) {
            throw new XPathException((Expression)this, "The LDAP Realm is not in use!", (Throwable)ex);
        }
        catch (SecurityException se) {
            throw new XPathException((Expression)this, "Permission to access the LDAP Realm is denied: " + se.getMessage(), (Throwable)se);
        }
        catch (IllegalArgumentException iae) {
            throw new XPathException((Expression)this, "Permission to access the LDAP Realm is denied: " + iae.getMessage(), (Throwable)iae);
        }
        catch (IllegalAccessException iae) {
            throw new XPathException((Expression)this, "Permission to access the LDAP Realm is denied: " + iae.getMessage(), (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new XPathException((Expression)this, "An error occured whilst accessing the LDAP Realm: " + ite.getMessage(), (Throwable)ite);
        }
    }
}

