/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient;

import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.tools.ToolsException;

public class HttpResponse {
    private final int myStatus;
    private final String myMessage;
    private final HeaderSet myHeaders;
    private final HttpResponseBody myBody;
    private final long myTime;

    public HttpResponse(int status, String msg, HeaderSet headers, HttpResponseBody body, long time) {
        this.myStatus = status;
        this.myMessage = msg;
        this.myHeaders = headers;
        this.myBody = body;
        this.myTime = time;
    }

    public int getStatus() {
        return this.myStatus;
    }

    public HeaderSet getHeaders() {
        return this.myHeaders;
    }

    public HttpResponseBody getBody() {
        return this.myBody;
    }

    public void outputResponseElement(TreeBuilder b) throws HttpClientException {
        try {
            b.startElem("response");
            b.attribute("status", Integer.toString(this.myStatus));
            b.attribute("message", this.myMessage);
            b.attribute("spent-millis", Long.toString(this.myTime));
            b.startContent();
            b.outputHeaders(this.myHeaders);
            if (this.myBody != null) {
                this.myBody.outputBody(b);
            }
            b.endElem();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error building the response", ex);
        }
    }
}

