/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.cookie.Cookie;

public class LoggerHelper {
    public static void logCookies(Log log, String prompt, Iterable<Cookie> cookies) {
        if (log.isDebugEnabled()) {
            if (cookies == null) {
                log.debug((Object)(prompt + ": null"));
                return;
            }
            for (Cookie c : cookies) {
                log.debug((Object)(prompt + ": " + c.getName() + ": " + c.getValue()));
            }
        }
    }

    public static void logHeaders(Log log, String prompt, Header[] headers) {
        if (log.isDebugEnabled()) {
            if (headers == null) {
                log.debug((Object)(prompt + ": null"));
                return;
            }
            for (Header h : headers) {
                log.debug((Object)(prompt + ": " + h.getName() + ": " + h.getValue()));
            }
        }
    }

    public static void logHeaderDetails(Log log, String prompt, Iterable<Header> headers) {
        if (log.isDebugEnabled()) {
            if (headers == null) {
                log.debug((Object)(prompt + ": null"));
                return;
            }
            for (Header h : headers) {
                log.debug((Object)(prompt + " - HEADER: " + h.getName() + ": " + h.getValue()));
                for (HeaderElement e : h.getElements()) {
                    log.debug((Object)(prompt + " -   ELEM: " + e.getName() + ": " + e.getValue()));
                    for (NameValuePair p : e.getParameters()) {
                        log.debug((Object)(prompt + " -     P: " + p.getName() + ": " + p.getValue()));
                    }
                }
            }
        }
    }
}

