/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.expath.httpclient.ContentType;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.model.Result;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.tools.ToolsException;

public class TextResponseBody
implements HttpResponseBody {
    private ContentType myContentType;
    private HeaderSet myHeaders;

    public TextResponseBody(Result result, InputStream in, ContentType type, HeaderSet headers) throws HttpClientException {
        this.myContentType = type;
        this.myHeaders = headers;
        Charset charset = StandardCharsets.UTF_8;
        InputStreamReader reader = new InputStreamReader(in, charset);
        result.add(reader);
    }

    public TextResponseBody(Result result, Reader in, ContentType type, HeaderSet headers) throws HttpClientException {
        this.myContentType = type;
        this.myHeaders = headers;
        result.add(in);
    }

    @Override
    public void outputBody(TreeBuilder b) throws HttpClientException {
        if (this.myHeaders != null) {
            b.outputHeaders(this.myHeaders);
        }
        try {
            b.startElem("body");
            b.attribute("media-type", this.myContentType.getValue());
            b.startContent();
            b.endElem();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error building the body", ex);
        }
    }
}

