/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class SimpleSegmentWithTagsAnnotator
extends JCasAnnotator_ImplBase {
    private String segmentId;
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.segmentId = (String)aContext.getConfigParameterValue("SegmentID");
        if (this.segmentId == null) {
            this.segmentId = "SIMPLE_SEGMENT";
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.logger.info((Object)"process(JCas)");
        String text = jcas.getDocumentText();
        if (text == null) {
            System.out.println("text == null in Segmentannotator");
            String docID = DocumentIDAnnotationUtil.getDocumentID(jcas);
            System.out.println(" \t\tdocID=" + docID);
        }
        if (this.segmentId.compareTo("parseSectionTag") != 0) {
            Segment sa = new Segment(jcas);
            sa.setBegin(0);
            sa.setEnd(jcas.getDocumentText().length());
            sa.setId(this.segmentId);
            sa.addToIndexes();
        } else {
            BufferedReader fileReader = new BufferedReader(new StringReader(text));
            int charNum = 0;
            int charPos = 0;
            char[] sectIdArr = new char[5];
            int endStartSegment = 0;
            int beginEndSegment = 0;
            try {
                while ((charNum = fileReader.read()) != -1) {
                    if (charNum == 91) {
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum != 115 && charNum != 101) continue;
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum != 116 && charNum != 110) continue;
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum != 97 && charNum != 100) continue;
                        ++charPos;
                        charNum = fileReader.read();
                        if (charNum == 114) {
                            endStartSegment = charPos + 24;
                            fileReader.skip(14L);
                            fileReader.read(sectIdArr, 0, 5);
                            charPos += 19;
                        } else if (charNum == 32) {
                            beginEndSegment = charPos - 5;
                            Segment sa = new Segment(jcas);
                            sa.setBegin(endStartSegment);
                            sa.setEnd(beginEndSegment);
                            sa.setId(String.copyValueOf(sectIdArr));
                            for (int i = 0; i < sectIdArr.length; ++i) {
                                sectIdArr[i] = 32;
                            }
                            sa.addToIndexes();
                        }
                        ++charPos;
                        continue;
                    }
                    ++charPos;
                }
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }
}

