/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ctakes.core.cc.AbstractJdbcWriter;
import org.apache.ctakes.core.util.IdentifiedAnnotationUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class JdbcWriterTemplate
extends AbstractJdbcWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"JdbcWriterTemplate");
    public static final String PARAM_VECTOR_TABLE = "VectorTable";
    private static final String SPAN_START_LABEL = "START";
    private static final String SPAN_END_LABEL = "END";
    private String _tableName;

    @Override
    public void initialize() throws ResourceInitializationException {
        this._tableName = (String)this.getConfigParameterValue(PARAM_VECTOR_TABLE);
        super.initialize();
    }

    @Override
    protected Collection<AbstractJdbcWriter.TableInfo> getTableInfos() {
        AbstractJdbcWriter.TableInfo tableInfo = new AbstractJdbcWriter.TableInfo(){

            @Override
            public String getTableName() {
                return JdbcWriterTemplate.this._tableName;
            }

            @Override
            public AbstractJdbcWriter.FieldInfo[] getFieldInfos() {
                return I2b2FieldInfo.values();
            }
        };
        return Collections.singletonList(tableInfo);
    }

    @Override
    protected void writeJCasInformation(JCas jcas, int encounterNum, long patientNum, String providerId, Timestamp startDate) throws SQLException {
        this.saveEntities(jcas, encounterNum, patientNum, providerId, startDate);
    }

    private void saveEntities(JCas jcas, int encounterNum, long patientNum, String providerId, Timestamp startDate) throws SQLException {
        AnnotationIndex identifiedsIndex = jcas.getAnnotationIndex(IdentifiedAnnotation.type);
        if (identifiedsIndex == null || identifiedsIndex.size() == 0) {
            return;
        }
        EnumMap<I2b2FieldInfo, Object> fieldInfoValues = new EnumMap<I2b2FieldInfo, Object>(I2b2FieldInfo.class);
        fieldInfoValues.put(I2b2FieldInfo.ENCOUNTER_NUM, Integer.valueOf(encounterNum));
        fieldInfoValues.put(I2b2FieldInfo.PATIENT_NUM, Long.valueOf(patientNum));
        fieldInfoValues.put(I2b2FieldInfo.PROVIDER_ID, providerId);
        fieldInfoValues.put(I2b2FieldInfo.START_DATE, startDate);
        fieldInfoValues.put(I2b2FieldInfo.MODIFIER_CD, "@");
        fieldInfoValues.put(I2b2FieldInfo.VALTYPE_CD, "T");
        HashMap<I2b2Concept, ArrayList<IdentifiedAnnotation>> cuiAnnotationListMap = new HashMap<I2b2Concept, ArrayList<IdentifiedAnnotation>>();
        for (Annotation annotation : identifiedsIndex) {
            if (!(annotation instanceof IdentifiedAnnotation)) continue;
            Collection<UmlsConcept> umlsConcepts = IdentifiedAnnotationUtil.getUmlsConcepts((IdentifiedAnnotation)annotation);
            Collection<I2b2Concept> i2b2Concepts = JdbcWriterTemplate.createI2b2Concepts(umlsConcepts);
            for (I2b2Concept i2b2Concept : i2b2Concepts) {
                ArrayList<IdentifiedAnnotation> annotationList = (ArrayList<IdentifiedAnnotation>)cuiAnnotationListMap.get(i2b2Concept);
                if (annotationList == null) {
                    annotationList = new ArrayList<IdentifiedAnnotation>();
                    cuiAnnotationListMap.put(i2b2Concept, annotationList);
                }
                annotationList.add((IdentifiedAnnotation)annotation);
            }
        }
        for (Map.Entry i2b2ConceptAnnotations : cuiAnnotationListMap.entrySet()) {
            this.saveI2b2Concept(fieldInfoValues, (I2b2Concept)i2b2ConceptAnnotations.getKey(), (Iterable)i2b2ConceptAnnotations.getValue());
        }
    }

    private void saveI2b2Concept(Map<I2b2FieldInfo, Object> fieldInfoValues, I2b2Concept i2b2Concept, Iterable<IdentifiedAnnotation> annotations) throws SQLException {
        String cui = i2b2Concept.getCui();
        String preferredText = i2b2Concept.getPreferredText();
        if (preferredText == null) {
            preferredText = "";
        }
        this.saveAnnotations(fieldInfoValues, cui, preferredText, annotations, true);
        this.saveAnnotations(fieldInfoValues, cui, preferredText, annotations, false);
    }

    private void saveAnnotations(Map<I2b2FieldInfo, Object> fieldInfoValues, String cui, String preferredText, Iterable<IdentifiedAnnotation> annotations, boolean saveAffirmed) throws SQLException {
        int instanceNum = 1;
        String conceptCode = (saveAffirmed ? "" : "-") + cui;
        fieldInfoValues.put(I2b2FieldInfo.CONCEPT_CD, conceptCode);
        String tvalChar = preferredText + (saveAffirmed ? "" : " Negated");
        fieldInfoValues.put(I2b2FieldInfo.TVAL_CHAR, tvalChar);
        PreparedStatement preparedStatement = ((AbstractJdbcWriter.TableSqlInfo)this._tableSqlInfoMap.get(this._tableName)).getPreparedStatement();
        int batchCount = ((AbstractJdbcWriter.TableSqlInfo)this._tableSqlInfoMap.get(this._tableName)).getBatchCount();
        for (IdentifiedAnnotation annotation : annotations) {
            boolean isNegated;
            boolean bl = isNegated = annotation.getPolarity() < 0;
            if (saveAffirmed == isNegated) continue;
            fieldInfoValues.put(I2b2FieldInfo.INSTANCE_NUM, instanceNum);
            String observationBlob = JdbcWriterTemplate.createBlob(annotation);
            fieldInfoValues.put(I2b2FieldInfo.I2B2_OBERVATION_BLOB, observationBlob);
            batchCount = JdbcWriterTemplate.writeTableRow(preparedStatement, batchCount, fieldInfoValues);
            ++instanceNum;
        }
        ((AbstractJdbcWriter.TableSqlInfo)this._tableSqlInfoMap.get(this._tableName)).setBatchCount(batchCount);
    }

    private static String createBlob(IdentifiedAnnotation annotation) {
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(SPAN_START_LABEL).append('>');
        sb.append(annotation.getBegin()).append("</").append(SPAN_START_LABEL).append('>');
        sb.append('<').append(SPAN_END_LABEL).append('>');
        sb.append(annotation.getEnd()).append("</").append(SPAN_END_LABEL).append('>');
        sb.append(annotation.getCoveredText());
        return sb.toString();
    }

    private static Collection<I2b2Concept> createI2b2Concepts(Iterable<UmlsConcept> umlsConcepts) {
        HashSet<I2b2Concept> i2b2Concepts = new HashSet<I2b2Concept>();
        for (UmlsConcept umlsConcept : umlsConcepts) {
            i2b2Concepts.add(new I2b2Concept(umlsConcept.getCui(), umlsConcept.getPreferredText()));
        }
        return i2b2Concepts;
    }

    private static class I2b2Concept {
        public static final String PREFERRED_TEXT_UNKNOWN = "Unknown Preferred Teex";
        private final String _cui;
        private final String _preferredText;
        private final int _hashcode;

        private I2b2Concept(String cui) {
            this(cui, PREFERRED_TEXT_UNKNOWN);
        }

        private I2b2Concept(String cui, String preferredText) {
            this._cui = cui;
            this._preferredText = preferredText != null ? preferredText : PREFERRED_TEXT_UNKNOWN;
            this._hashcode = (cui + "_" + preferredText).hashCode();
        }

        public String getCui() {
            return this._cui;
        }

        public String getPreferredText() {
            return this._preferredText;
        }

        public boolean equals(Object value) {
            return value instanceof I2b2Concept && this._cui.equals(((I2b2Concept)value)._cui) && this._preferredText.equals(((I2b2Concept)value)._preferredText);
        }

        public int hashCode() {
            return this._hashcode;
        }
    }

    public static enum I2b2FieldInfo implements AbstractJdbcWriter.FieldInfo
    {
        ENCOUNTER_NUM(1, "encounter_num", Integer.class),
        PATIENT_NUM(2, "patient_num", Long.class),
        CONCEPT_CD(3, "concept_cd", String.class),
        PROVIDER_ID(4, "provider_id", String.class),
        START_DATE(5, "start_date", Timestamp.class),
        MODIFIER_CD(6, "modifier_cd", String.class),
        INSTANCE_NUM(7, "instance_num", Long.class),
        VALTYPE_CD(8, "valtype_cd", String.class),
        TVAL_CHAR(9, "tval_char", String.class),
        I2B2_OBERVATION_BLOB(10, "observation_blob", String.class);

        private final String __name;
        private final int __index;
        private final Class<?> __class;

        private I2b2FieldInfo(int index, String name, Class<?> valueClass) {
            this.__name = name;
            this.__index = index;
            this.__class = valueClass;
        }

        @Override
        public String getFieldName() {
            return this.__name;
        }

        @Override
        public int getFieldIndex() {
            return this.__index;
        }

        @Override
        public Class<?> getValueClass() {
            return this.__class;
        }
    }
}

