/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.UriUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class XmiWriterCasConsumerCtakes
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    @ConfigurationParameter(name="OutputDirectory", description="Output directory to write xmi files", mandatory=true)
    private File mOutputDir;
    private int mDocNum;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.mDocNum = 0;
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        JCas jcas;
        String modelFileName = null;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e1) {
            e1.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e1);
        }
        String originalFileName = DocumentIDAnnotationUtil.getDocumentID(jcas);
        File outFile = null;
        if (originalFileName != null && !originalFileName.isEmpty()) {
            try {
                String outFileName = null;
                if (originalFileName.contains("/")) {
                    URI uri = UriUtils.quote((String)originalFileName);
                    File inFile = new File(uri);
                    outFileName = inFile.getName();
                } else {
                    outFileName = originalFileName;
                }
                outFileName = outFileName + ".xmi";
                outFile = new File(this.mOutputDir, outFileName);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++ + ".xmi");
        }
        try {
            this.writeXmi(jcas.getCas(), outFile, modelFileName);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, File name) throws IOException, SAXException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, File name, String modelFileName) throws IOException, SAXException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    public static CasConsumerDescription getDescription() throws InvalidXMLException {
        InputStream descStream = XmiWriterCasConsumerCtakes.class.getResourceAsStream("XmiWriterCasConsumerCtakes.xml");
        return UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return XmiWriterCasConsumerCtakes.class.getResource("XmiWriterCasConsumerCtakes.xml");
    }
}

