/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.DecimalCondition;
import org.apache.ctakes.core.fsm.condition.IntegerCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.output.FractionToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class FractionFSM {
    Set<String> iv_textNumeratorSet = new HashSet<String>();
    Set<String> iv_textDenominatorSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public FractionFSM() {
        this.iv_textNumeratorSet.add("one");
        this.iv_textNumeratorSet.add("two");
        this.iv_textNumeratorSet.add("three");
        this.iv_textNumeratorSet.add("four");
        this.iv_textNumeratorSet.add("five");
        this.iv_textNumeratorSet.add("six");
        this.iv_textNumeratorSet.add("seven");
        this.iv_textNumeratorSet.add("eight");
        this.iv_textNumeratorSet.add("nine");
        this.iv_textNumeratorSet.add("ten");
        this.iv_textDenominatorSet.add("half");
        this.iv_textDenominatorSet.add("halfs");
        this.iv_textDenominatorSet.add("third");
        this.iv_textDenominatorSet.add("thirds");
        this.iv_textDenominatorSet.add("fourth");
        this.iv_textDenominatorSet.add("fourths");
        this.iv_textDenominatorSet.add("fifth");
        this.iv_textDenominatorSet.add("fifths");
        this.iv_textDenominatorSet.add("sixth");
        this.iv_textDenominatorSet.add("sixths");
        this.iv_textDenominatorSet.add("seventh");
        this.iv_textDenominatorSet.add("sevenths");
        this.iv_textDenominatorSet.add("eighth");
        this.iv_textDenominatorSet.add("eighths");
        this.iv_textDenominatorSet.add("nineths");
        this.iv_textDenominatorSet.add("nineth");
        this.iv_textDenominatorSet.add("tenth");
        this.iv_textDenominatorSet.add("tenths");
        this.iv_machineSet.add(this.getMachine());
    }

    private Machine getMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState numeratorNumState = new NamedState("NUMERATOR_NUM");
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        NamedState numeratorTextState = new NamedState("NUMERATOR_TEXT");
        IntegerCondition intNumeratorCondition = new IntegerCondition();
        PunctuationValueCondition fslashCondition = new PunctuationValueCondition('/');
        IntegerCondition intDenominatorCondition = new IntegerCondition();
        DecimalCondition decimalCondition = new DecimalCondition();
        WordSetCondition textNumeratorCondition = new WordSetCondition(this.iv_textNumeratorSet, false);
        WordSetCondition textDenominatorCondition = new WordSetCondition(this.iv_textDenominatorSet, false);
        startState.addTransition(intNumeratorCondition, numeratorNumState);
        startState.addTransition(decimalCondition, endState);
        startState.addTransition(textNumeratorCondition, numeratorTextState);
        startState.addTransition(textDenominatorCondition, endState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        numeratorNumState.addTransition(fslashCondition, fslashState);
        numeratorNumState.addTransition(textDenominatorCondition, endState);
        numeratorNumState.addTransition((Condition)new AnyCondition(), startState);
        fslashState.addTransition(intDenominatorCondition, endState);
        fslashState.addTransition((Condition)new AnyCondition(), startState);
        numeratorTextState.addTransition(textDenominatorCondition, endState);
        numeratorTextState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<FractionToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<FractionToken> fractionSet = new HashSet<FractionToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                FractionToken fractionToken = new FractionToken(startToken.getStartOffset(), endToken.getEndOffset());
                fractionSet.add(fractionToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

