/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Logger;

public final class FileLocator {
    private static final Logger LOGGER = Logger.getLogger((String)"FileLocator");
    private static final String CTAKES_HOME = "CTAKES_HOME";

    private FileLocator() {
    }

    public static InputStream getAsStream(String location) throws FileNotFoundException {
        try {
            InputStream is = FileLocator.class.getClassLoader().getResourceAsStream(location);
            if (is == null) {
                throw new RuntimeException("Unable to locate " + location + " on classpath.");
            }
            return is;
        }
        catch (Exception e) {
            File f = new File(location);
            FileInputStream fs = new FileInputStream(f);
            return fs;
        }
    }

    public static File locateFile(String location) throws FileNotFoundException {
        String fullPath = FileLocator.getFullPath(location);
        File file = new File(fullPath);
        if (!file.exists()) {
            throw new FileNotFoundException("No File at " + location);
        }
        return file;
    }

    private static String createDiscoveredPath(String relativePath, File file, String locationText) {
        try {
            LOGGER.debug((Object)(relativePath + " discovered " + locationText + " as: " + file.getCanonicalPath()));
            return file.getCanonicalPath();
        }
        catch (IOException ioE) {
            LOGGER.debug((Object)(relativePath + " discovered " + locationText + " as: " + file.getPath()));
            return file.getPath();
        }
    }

    public static String getFullPath(String relativePath) throws FileNotFoundException {
        File file = new File(relativePath);
        if (file.exists()) {
            return FileLocator.createDiscoveredPath(relativePath, file, "without adjustment");
        }
        try {
            file = FileLocator.locateOnClasspath(relativePath);
            if (file.exists()) {
                return FileLocator.createDiscoveredPath(relativePath, file, "under Classpath");
            }
        }
        catch (FileNotFoundException | URISyntaxException multiE) {
            // empty catch block
        }
        String cwd = System.getProperty("user.dir");
        file = new File(cwd, relativePath);
        if (file.exists()) {
            return FileLocator.createDiscoveredPath(relativePath, file, "under Working Directory");
        }
        String cTakesHome = System.getenv(CTAKES_HOME);
        if (cTakesHome != null && !cTakesHome.isEmpty() && (file = new File(cTakesHome, relativePath)).exists()) {
            return FileLocator.createDiscoveredPath(relativePath, file, "under $CTAKES_HOME");
        }
        File cwdDerived = new File(cwd);
        while (cwdDerived.getParentFile() != null) {
            file = new File(cwdDerived = cwdDerived.getParentFile(), relativePath);
            if (file.exists()) {
                return FileLocator.createDiscoveredPath(relativePath, file, "above Working Directory");
            }
            file = new File(cwdDerived, "ctakes/" + relativePath);
            if (!file.exists()) continue;
            return FileLocator.createDiscoveredPath(relativePath, file, "above Working Directory /ctakes");
        }
        LOGGER.error((Object)("Could not find " + relativePath + " as absolute or in \n" + cwd + " or in any parent thereof or in $CTAKES_HOME \n" + cTakesHome));
        throw new FileNotFoundException("No File exists at " + relativePath);
    }

    private static File locateOnClasspath(String relativePath) throws FileNotFoundException, URISyntaxException {
        ClassLoader classLoader = FileLocator.class.getClassLoader();
        URL indexUrl = classLoader.getResource(relativePath);
        if (indexUrl == null) {
            throw new FileNotFoundException(relativePath);
        }
        URI indexUri = new URI(indexUrl.toExternalForm());
        return new File(indexUri);
    }
}

