/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.scheduler.JobDescription;
import org.exist.scheduler.SchedulerManager;
import org.exist.scheduler.UserJavaJob;
import org.exist.scheduler.UserXQueryJob;
import org.exist.security.AbstractAccount;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.SubjectAccreditedImpl;

@ConfigurationClass(value="job")
public class Job
implements Configurable {
    protected static final String DETAILS = "DETAILs";
    @ConfigurationFieldAsAttribute(value="id")
    private String id;
    @ConfigurationFieldAsElement(value="name")
    private String name;
    @ConfigurationFieldAsElement(value="group")
    private String group;
    @ConfigurationFieldAsElement(value="class")
    private String clazz;
    @ConfigurationFieldAsElement(value="run-as-account")
    private String account;
    @ConfigurationFieldAsElement(value="script-uri")
    protected String scriptURI;
    @ConfigurationFieldAsElement(value="cron-expression")
    private String cronExpression;
    private Configuration configuration;
    private SchedulerManager manager;

    public Job(SchedulerManager manager, Configuration config) throws ConfigurationException {
        UserXQueryJob jobDescription;
        block8: {
            this.manager = manager;
            this.configuration = Configurator.configure((Configurable)this, (Configuration)config);
            if (this.scriptURI != null && !this.scriptURI.isEmpty()) {
                jobDescription = new UserXQueryJob(this.name, this.scriptURI, this.getSubject());
            } else {
                try {
                    Class<?> jobClass = Class.forName(this.clazz);
                    Object jobObject = jobClass.newInstance();
                    if (jobObject instanceof UserJavaJob) {
                        jobDescription = (JobDescription)jobClass.newInstance();
                        if (jobDescription.getName() == null) {
                            jobDescription.setName(this.name);
                        }
                        break block8;
                    }
                    throw new ConfigurationException("Java Jobs must extend org.exist.scheduler.UserJavaJob");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ConfigurationException("No such class: " + this.clazz, (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    throw new ConfigurationException("Cannot instantiate class: " + this.clazz, (Throwable)ie);
                }
                catch (IllegalAccessException ie) {
                    throw new ConfigurationException("Cannot instantiate class: " + this.clazz, (Throwable)ie);
                }
            }
        }
        manager.getScheduler().createCronJob(this.cronExpression, (JobDescription)jobDescription, null, true);
    }

    private Subject getSubject() {
        AbstractAccount acc;
        SecurityManager sm = this.manager.getDatabase().getSecurityManager();
        Object subject = this.account == null || this.account.isEmpty() ? this.manager.getDatabase().getSecurityManager().getGuestSubject() : ((acc = (AbstractAccount)sm.getAccount(this.account)) == null ? sm.getGuestSubject() : new SubjectAccreditedImpl(acc, (Object)this));
        return subject;
    }

    public boolean isConfigured() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

