/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.config.annotation.ConfigurationFieldClassMask;
import org.exist.config.annotation.ConfigurationReferenceBy;
import org.exist.plugin.Plug;
import org.exist.plugin.PluginsManager;
import org.exist.scheduler.Job;
import org.exist.scheduler.Scheduler;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

@ConfigurationClass(value="scheduler")
public class SchedulerManager
implements Plug {
    private static final XmldbURI COLLECTION_URI = XmldbURI.SYSTEM.append("scheduler");
    private static final XmldbURI CONFIG_FILE_URI = XmldbURI.create((String)"scheduler.xml");
    private static final Logger LOG = LogManager.getLogger(SchedulerManager.class);
    @ConfigurationFieldAsElement(value="job")
    @ConfigurationReferenceBy(value="id")
    @ConfigurationFieldClassMask(value="org.exist.scheduler.Job")
    private List<Job> jobs = new ArrayList<Job>();
    private Collection collection = null;
    private Configuration configuration = null;
    private final Scheduler scheduler;
    private final Database db;

    public SchedulerManager(PluginsManager pm) {
        this.db = pm.getDatabase();
        this.scheduler = this.db.getScheduler();
    }

    public void start(DBBroker broker) throws EXistException {
        try {
            Collection systemCollection = broker.getCollection(XmldbURI.SYSTEM);
            if (systemCollection == null) {
                throw new EXistException("/db/system collecton does not exist!");
            }
        }
        catch (PermissionDeniedException e) {
            throw new EXistException((Throwable)e);
        }
        TransactionManager transaction = broker.getDatabase().getTransactionManager();
        Txn txn = null;
        try {
            this.collection = broker.getCollection(COLLECTION_URI);
            if (this.collection == null) {
                txn = transaction.beginTransaction();
                this.collection = broker.getOrCreateCollection(txn, COLLECTION_URI);
                if (this.collection == null) {
                    return;
                }
                this.collection.setPermissions(504);
                broker.saveCollection(txn, this.collection);
                transaction.commit(txn);
            }
        }
        catch (Exception e) {
            transaction.abort(txn);
            e.printStackTrace();
            LOG.debug("loading configuration failed: " + e.getMessage(), (Throwable)e);
        }
        Configuration _config_ = Configurator.parse((Configurable)this, (DBBroker)broker, (Collection)this.collection, (XmldbURI)CONFIG_FILE_URI);
        this.configuration = Configurator.configure((Configurable)this, (Configuration)_config_);
    }

    public void sync(DBBroker broker) throws EXistException {
    }

    public void stop(DBBroker broker) throws EXistException {
    }

    public void addJob(Configuration config) throws ConfigurationException {
        this.jobs.add(new Job(this, config));
    }

    public boolean isConfigured() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Database getDatabase() {
        return this.db;
    }
}

