/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.asb.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.asb.impl.FlowContainer;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowController;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.JCasFlow_ImplBase;
import org.apache.uima.impl.Util;
import org.apache.uima.internal.util.JmxMBeanAgent;
import org.apache.uima.resource.ConfigurableResource_ImplBase;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Logger;
import org.apache.uima.util.UimaTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowControllerContainer
extends ConfigurableResource_ImplBase {
    private FlowController mFlowController;
    private UimaTimer mTimer = UIMAFramework.newTimer();
    private boolean mSofaAware;
    private Object mMBeanServer;
    private boolean initialized = false;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        try {
            if (!(aSpecifier instanceof FlowControllerDescription)) {
                throw new ResourceInitializationException("not_a_flow_controller_descriptor", new Object[]{aSpecifier.getSourceUrlString(), aSpecifier.getClass().getName()});
            }
            ResourceCreationSpecifier desc = (ResourceCreationSpecifier)aSpecifier;
            String fwImpl = desc.getFrameworkImplementation();
            if (fwImpl == null || !fwImpl.equalsIgnoreCase("org.apache.uima.java")) {
                throw new ResourceInitializationException("unsupported_framework_implementation", new Object[]{fwImpl, aSpecifier.getSourceUrlString()});
            }
            super.initialize(aSpecifier, aAdditionalParams);
            desc.validate(this.getResourceManager());
            this.mFlowController = this.instantiateFlowController(desc);
            this.setMetaData(desc.getMetaData());
            this.getCasManager().addMetaData(this.getProcessingResourceMetaData());
            this.mSofaAware = this.getProcessingResourceMetaData().isSofaAware();
            UimaContextAdmin uimaContext = this.getUimaContextAdmin();
            Logger logger = UIMAFramework.getLogger(this.mFlowController.getClass());
            logger.setResourceManager(this.getResourceManager());
            uimaContext.setLogger(logger);
            this.mFlowController.initialize(this.getFlowControllerContext());
            this.mMBeanServer = null;
            String mbeanNamePrefix = null;
            if (aAdditionalParams != null) {
                this.mMBeanServer = aAdditionalParams.get("MBEAN_SERVER");
                mbeanNamePrefix = (String)aAdditionalParams.get("MBEAN_NAME_PREFIX");
            }
            this.getMBean().setName(this.getMetaData().getName(), this.getUimaContextAdmin(), mbeanNamePrefix);
            JmxMBeanAgent.registerMBean(this.getMBean(), this.mMBeanServer);
            this.initialized = true;
            return true;
        }
        catch (ResourceConfigurationException e) {
            throw new ResourceInitializationException(e);
        }
    }

    protected void finalize() throws Throwable {
        JmxMBeanAgent.unregisterMBean(this.getMBean(), this.mMBeanServer);
        super.finalize();
    }

    private FlowControllerContext getFlowControllerContext() {
        return (FlowControllerContext)this.getUimaContext();
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        try {
            this.mFlowController.reconfigure();
        }
        catch (ResourceInitializationException e) {
            throw new ResourceConfigurationException(e);
        }
    }

    @Override
    public void destroy() {
        this.mFlowController.destroy();
        super.destroy();
    }

    public FlowContainer computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        FlowContainer flowContainer;
        this.mTimer.startIt();
        CASImpl view = null;
        try {
            view = Util.getStartingView(aCAS, this.mSofaAware, this.getUimaContextAdmin().getComponentInfo());
            Class<? extends AbstractCas> requiredInterface = this.mFlowController.getRequiredCasInterface();
            AbstractCas casToPass = this.getCasManager().getCasInterface(view, requiredInterface);
            view.switchClassLoaderLockCasCL(this.getResourceManager().getExtensionClassLoader());
            Flow flow = this.mFlowController.computeFlow(casToPass);
            if (flow instanceof CasFlow_ImplBase) {
                ((CasFlow_ImplBase)flow).setCas(view);
            }
            if (flow instanceof JCasFlow_ImplBase) {
                ((JCasFlow_ImplBase)flow).setJCas(view.getJCas());
            }
            flowContainer = new FlowContainer(flow, this, aCAS);
            if (view != null) {
                view.restoreClassLoaderUnlockCas();
                view.setCurrentComponentInfo(null);
            }
            this.mTimer.stopIt();
        }
        catch (CASException e) {
            try {
                throw new AnalysisEngineProcessException(e);
            }
            catch (Throwable throwable) {
                if (view != null) {
                    ((CASImpl)view).restoreClassLoaderUnlockCas();
                    view.setCurrentComponentInfo(null);
                }
                this.mTimer.stopIt();
                this.getMBean().reportAnalysisTime(this.mTimer.getDuration());
                this.getMBean().incrementCASesProcessed();
                throw throwable;
            }
        }
        this.getMBean().reportAnalysisTime(this.mTimer.getDuration());
        this.getMBean().incrementCASesProcessed();
        return flowContainer;
    }

    public Class<? extends AbstractCas> getRequiredCasInterface() {
        return this.mFlowController.getRequiredCasInterface();
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        return (ProcessingResourceMetaData)this.getMetaData();
    }

    public AnalysisEngineManagementImpl getMBean() {
        return (AnalysisEngineManagementImpl)this.getUimaContextAdmin().getManagementInterface();
    }

    public void addAnalysisEngines(Collection<String> aKeys) {
        this.mFlowController.addAnalysisEngines(aKeys);
    }

    public void removeAnalysisEngines(Collection<String> aKeys) throws AnalysisEngineProcessException {
        this.mFlowController.removeAnalysisEngines(aKeys);
    }

    private FlowController instantiateFlowController(ResourceCreationSpecifier aDescriptor) throws ResourceInitializationException {
        Object userObject;
        String flowControllerClassName = aDescriptor.getImplementationName();
        if (flowControllerClassName == null || flowControllerClassName.length() == 0) {
            throw new ResourceInitializationException("missing_implementation_class_name", new Object[]{aDescriptor.getSourceUrlString()});
        }
        Class<?> flowControllerClass = null;
        try {
            ClassLoader cl = this.getUimaContextAdmin().getResourceManager().getExtensionClassLoader();
            flowControllerClass = cl != null ? cl.loadClass(flowControllerClassName) : Class.forName(flowControllerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException("class_not_found", new Object[]{flowControllerClassName, aDescriptor.getSourceUrlString()}, e);
        }
        try {
            userObject = flowControllerClass.newInstance();
        }
        catch (Exception e) {
            throw new ResourceInitializationException("could_not_instantiate", new Object[]{flowControllerClassName, aDescriptor.getSourceUrlString()}, e);
        }
        if (!(userObject instanceof FlowController)) {
            throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{flowControllerClassName, FlowController.class, aDescriptor.getSourceUrlString()});
        }
        return (FlowController)userObject;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        if (this.mFlowController != null) {
            this.mFlowController.collectionProcessComplete();
        }
    }
}

