/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.ByteHeap;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.Heap;
import org.apache.uima.cas.impl.LongHeap;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.ShortHeap;
import org.apache.uima.cas.impl.StringHeap;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;
import org.apache.uima.cas.impl.StringTypeImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.impl.DataIO;
import org.apache.uima.util.impl.OptimizeStrings;
import org.apache.uima.util.impl.SerializationMeasures;

public class BinaryCasSerDes4 {
    public static final int TYPECODE_COMPR = 8;
    public static final boolean CHANGE_FS_REFS_TO_SEQUENTIAL = true;
    public static final boolean IS_DIFF_ENCODE = true;
    public static final boolean CAN_BE_NEGATIVE = true;
    public static final boolean IGNORED = true;
    public static final boolean IN_MAIN_HEAP = true;
    private static final long DBL_1 = Double.doubleToLongBits(1.0);
    private final TypeInfo[] typeInfoArray;
    private final TypeSystemImpl ts;
    private final boolean doMeasurements;
    private static final int arrayLength_i = SlotKind.Slot_ArrayLength.i;
    private static final int heapRef_i = SlotKind.Slot_HeapRef.i;
    private static final int int_i = SlotKind.Slot_Int.i;
    private static final int byte_i = SlotKind.Slot_Byte.ordinal();
    private static final int short_i = SlotKind.Slot_Short.i;
    private static final int typeCode_i = SlotKind.Slot_TypeCode.i;
    private static final int strOffset_i = SlotKind.Slot_StrOffset.i;
    private static final int strLength_i = SlotKind.Slot_StrLength.i;
    private static final int long_High_i = SlotKind.Slot_Long_High.i;
    private static final int long_Low_i = SlotKind.Slot_Long_Low.i;
    private static final int float_Mantissa_Sign_i = SlotKind.Slot_Float_Mantissa_Sign.i;
    private static final int float_Exponent_i = SlotKind.Slot_Float_Exponent.i;
    private static final int double_Mantissa_Sign_i = SlotKind.Slot_Double_Mantissa_Sign.i;
    private static final int double_Exponent_i = SlotKind.Slot_Double_Exponent.i;
    private static final int fsIndexes_i = SlotKind.Slot_FsIndexes.i;
    private static final int strChars_i = SlotKind.Slot_StrChars.i;
    private static final int control_i = SlotKind.Slot_Control.i;
    private static final int strSeg_i = SlotKind.Slot_StrSeg.i;

    public BinaryCasSerDes4(TypeSystemImpl ts, boolean doMeasurements) {
        this.ts = ts;
        this.doMeasurements = doMeasurements;
        this.typeInfoArray = new TypeInfo[ts.getTypeArraySize()];
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out, Marker trackingMark, CompressLevel compressLevel, CompressStrat compressStrategy) throws IOException {
        SerializationMeasures sm = this.doMeasurements ? new SerializationMeasures() : null;
        CASImpl casImpl = (CASImpl)(cas instanceof JCas ? ((JCas)cas).getCas() : cas);
        if (null != trackingMark && !trackingMark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", new String[]{"Invalid Marker."});
        }
        Serializer serializer = new Serializer(casImpl, BinaryCasSerDes4.makeDataOutputStream(out), (MarkerImpl)trackingMark, sm, compressLevel, compressStrategy);
        serializer.serialize();
        return sm;
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out, Marker trackingMark, CompressLevel compressLevel) throws IOException {
        return this.serialize(cas, out, trackingMark, compressLevel, CompressStrat.Default);
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out, Marker trackingMark) throws IOException {
        return this.serialize(cas, out, trackingMark, CompressLevel.Default, CompressStrat.Default);
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out) throws IOException {
        return this.serialize(cas, out, null);
    }

    public void deserialize(CASImpl cas, InputStream deserIn, boolean isDelta) throws IOException {
        DataInputStream in = deserIn instanceof DataInputStream ? (DataInputStream)deserIn : new DataInputStream(deserIn);
        Deserializer deserializer = new Deserializer(cas, in, isDelta);
        deserializer.deserialize();
    }

    private int incrToNextFs(int[] heap, int iHeap, TypeInfo typeInfo) {
        if (typeInfo.isHeapStoredArray) {
            return 2 + heap[iHeap + 1];
        }
        return 1 + typeInfo.slotKinds.length;
    }

    private void initFsStartIndexes(ComprItemRefs fsStartIndexes, int[] heap, int heapStart, int heapEnd, int[] histo) {
        TypeInfo typeInfo;
        for (int iHeap = 1; iHeap < heapEnd; iHeap += this.incrToNextFs(heap, iHeap, typeInfo)) {
            fsStartIndexes.addItemAddr(iHeap);
            int tCode = heap[iHeap];
            if (null != histo && iHeap >= heapStart) {
                int n = tCode;
                histo[n] = histo[n] + 1;
            }
            typeInfo = this.getTypeInfo(tCode);
        }
        fsStartIndexes.finishSetup();
    }

    private void resetIprevious() {
        for (int i = 1; i < this.typeInfoArray.length; ++i) {
            TypeInfo typeInfo = this.typeInfoArray[i];
            if (null == typeInfo) continue;
            typeInfo.iPrevHeap = 0;
        }
    }

    public CasCompare getCasCompare() {
        return new CasCompare();
    }

    private static DataOutputStream makeDataOutputStream(Object f) throws FileNotFoundException {
        if (f instanceof DataOutputStream) {
            return (DataOutputStream)f;
        }
        if (f instanceof OutputStream) {
            return new DataOutputStream((OutputStream)f);
        }
        if (f instanceof File) {
            FileOutputStream fos = new FileOutputStream((File)f);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            return new DataOutputStream(bos);
        }
        throw new RuntimeException(String.format("Invalid class passed to method, class was %s", f.getClass().getName()));
    }

    public String printCasInfo(CASImpl cas) {
        int heapsz = cas.getHeap().getNextId() * 4;
        StringHeapDeserializationHelper shdh = cas.getStringHeap().serialize();
        int charssz = shdh.charHeap.length * 2;
        int strintsz = cas.getStringHeap().getSize() * 8;
        int strsz = charssz + strintsz;
        int fsindexessz = cas.getIndexedFSs().length * 4;
        int bytessz = cas.getByteHeap().getSize();
        int shortsz = cas.getShortHeap().getSize() * 2;
        int longsz = cas.getLongHeap().getSize() * 8;
        int total = heapsz + strsz + fsindexessz + bytessz + shortsz + longsz;
        return String.format("CAS info before compression: totalSize(bytes): %,d%n  mainHeap: %,d(%d%%)%n  Strings: [%,d(%d%%): %,d chars %,d ints]%n  fsIndexes: %,d(%d%%)%n  byte/short/long Heaps: [%,d %,d %,d]", total, heapsz, 100L * (long)heapsz / (long)total, strsz, 100L * (long)strsz / (long)total, charssz, strintsz, fsindexessz, 100L * (long)fsindexessz / (long)total, bytessz, shortsz, longsz);
    }

    private TypeInfo getTypeInfo(int typeCode) {
        if (null == this.typeInfoArray[typeCode]) {
            this.initTypeInfoArray(typeCode);
        }
        return this.typeInfoArray[typeCode];
    }

    private void initTypeInfoArray(int typeCode) {
        TypeImpl type = (TypeImpl)this.ts.ll_getTypeForCode(typeCode);
        this.typeInfoArray[typeCode] = new TypeInfo(type, this.ts);
    }

    private static class ComprItemRefs {
        private IntVector itemIndexToAddr = new IntVector();
        private Map<Integer, Integer> itemAddrToIndex = new HashMap<Integer, Integer>();

        public ComprItemRefs() {
            this.addItemAddr(0);
        }

        public void addItemAddr(int v) {
            int i = this.itemIndexToAddr.size();
            this.itemIndexToAddr.add(v);
            this.itemAddrToIndex.put(v, i);
        }

        public int getNbrOfItems() {
            return this.itemIndexToAddr.size();
        }

        public void finishSetup() {
        }

        public int getItemAddr(int index) {
            return this.itemIndexToAddr.get(index);
        }

        public int getItemIndex(int itemAddr) {
            return this.itemAddrToIndex.get(itemAddr);
        }
    }

    private static class TypeInfo {
        public final TypeImpl type;
        public final SlotKind[] slotKinds;
        public final int[] strRefOffsets;
        public final boolean isArray;
        public final boolean isHeapStoredArray;
        public int iPrevHeap;

        public TypeInfo(TypeImpl type, TypeSystemImpl ts) {
            this.type = type;
            List<Feature> features = type.getFeatures();
            this.isArray = type.isArray();
            this.isHeapStoredArray = type == ts.intArrayType || type == ts.floatArrayType || type == ts.fsArrayType || type == ts.stringArrayType || TypeSystemImpl.isArrayTypeNameButNotBuiltIn(type.getName());
            ArrayList<Integer> strRefsTemp = new ArrayList<Integer>();
            if (this.isArray) {
                SlotKind arrayKind;
                if (this.isHeapStoredArray) {
                    arrayKind = type == ts.intArrayType ? SlotKind.Slot_Int : (type == ts.floatArrayType ? SlotKind.Slot_Float : (type == ts.stringArrayType ? SlotKind.Slot_StrRef : SlotKind.Slot_HeapRef));
                } else if (type == ts.booleanArrayType || type == ts.byteArrayType) {
                    arrayKind = SlotKind.Slot_ByteRef;
                } else if (type == ts.shortArrayType) {
                    arrayKind = SlotKind.Slot_ShortRef;
                } else if (type == ts.longArrayType) {
                    arrayKind = SlotKind.Slot_LongRef;
                } else if (type == ts.doubleArrayType) {
                    arrayKind = SlotKind.Slot_DoubleRef;
                } else {
                    throw new RuntimeException("never get here");
                }
                this.slotKinds = new SlotKind[]{SlotKind.Slot_ArrayLength, arrayKind};
                this.strRefOffsets = null;
            } else {
                ArrayList<SlotKind> slots = new ArrayList<SlotKind>();
                int i = -1;
                for (Feature feat : features) {
                    ++i;
                    TypeImpl slotType = (TypeImpl)feat.getRange();
                    if (slotType == ts.stringType || slotType instanceof StringTypeImpl) {
                        slots.add(SlotKind.Slot_StrRef);
                        strRefsTemp.add(i);
                        continue;
                    }
                    if (slotType == ts.intType) {
                        slots.add(SlotKind.Slot_Int);
                        continue;
                    }
                    if (slotType == ts.booleanType) {
                        slots.add(SlotKind.Slot_Boolean);
                        continue;
                    }
                    if (slotType == ts.byteType) {
                        slots.add(SlotKind.Slot_Byte);
                        continue;
                    }
                    if (slotType == ts.shortType) {
                        slots.add(SlotKind.Slot_Short);
                        continue;
                    }
                    if (slotType == ts.floatType) {
                        slots.add(SlotKind.Slot_Float);
                        continue;
                    }
                    if (slotType == ts.longType) {
                        slots.add(SlotKind.Slot_LongRef);
                        continue;
                    }
                    if (slotType == ts.doubleType) {
                        slots.add(SlotKind.Slot_DoubleRef);
                        continue;
                    }
                    slots.add(SlotKind.Slot_HeapRef);
                }
                this.slotKinds = slots.toArray(new SlotKind[slots.size()]);
                this.strRefOffsets = new int[strRefsTemp.size()];
                for (int i2 = 0; i2 < this.strRefOffsets.length; ++i2) {
                    this.strRefOffsets[i2] = (Integer)strRefsTemp.get(i2);
                }
            }
        }

        public SlotKind getSlotKind(int offset) {
            if (0 == offset) {
                return SlotKind.Slot_TypeCode;
            }
            return this.slotKinds[offset - 1];
        }

        public String toString() {
            return this.type.toString();
        }
    }

    public class CasCompare {
        private CASImpl c1;
        private CASImpl c2;
        private Heap c1HO;
        private Heap c2HO;
        private int[] c1heap;
        private int[] c2heap;
        private TypeInfo typeInfo;
        private int iHeap;

        public boolean compareCASes(CASImpl c1, CASImpl c2) {
            int end2;
            this.c1 = c1;
            this.c2 = c2;
            this.c1HO = c1.getHeap();
            this.c2HO = c2.getHeap();
            int endi = this.c1HO.getCellsUsed();
            if (endi != (end2 = this.c2HO.getCellsUsed())) {
                System.err.format("CASes have different heap cells used: %,d %,d%n", endi, end2);
            }
            this.c1heap = this.c1HO.heap;
            this.c2heap = this.c2HO.heap;
            ComprItemRefs fsStartIndexes = new ComprItemRefs();
            BinaryCasSerDes4.this.initFsStartIndexes(fsStartIndexes, this.c1heap, 1, endi, null);
            int endsi = fsStartIndexes.getNbrOfItems();
            for (int i = 1; i < endsi; ++i) {
                this.iHeap = fsStartIndexes.getItemAddr(i);
                if (this.compareFss()) continue;
                return false;
            }
            int[] ifs1 = c1.getIndexedFSs();
            int[] ifs2 = c2.getIndexedFSs();
            return Arrays.equals(ifs1, ifs2);
        }

        private boolean compareFss() {
            int tCode = this.c1heap[this.iHeap];
            this.typeInfo = BinaryCasSerDes4.this.getTypeInfo(tCode);
            if (tCode != this.c2heap[this.iHeap]) {
                return this.mismatchFs();
            }
            if (this.typeInfo.isArray) {
                return this.compareFssArray();
            }
            for (int i = 1; i < this.typeInfo.slotKinds.length + 1; ++i) {
                if (this.compareSlot(i)) continue;
                return this.mismatchFs();
            }
            return true;
        }

        private boolean compareFssArray() {
            int len1 = this.c1heap[this.iHeap + 1];
            int len2 = this.c2heap[this.iHeap + 1];
            if (len1 != len2) {
                return false;
            }
            block5: for (int i = 0; i < len1; ++i) {
                SlotKind kind = this.typeInfo.getSlotKind(2);
                if (this.typeInfo.isHeapStoredArray) {
                    if (!(kind == SlotKind.Slot_StrRef ? !this.compareStrings(this.c1.getStringForCode(this.c1heap[this.iHeap + 2 + i]), this.c2.getStringForCode(this.c2heap[this.iHeap + 2 + i])) : this.c1heap[this.iHeap + 2 + i] != this.c2heap[this.iHeap + 2 + i])) continue;
                    return this.mismatchFs();
                }
                switch (kind) {
                    case Slot_BooleanRef: 
                    case Slot_ByteRef: {
                        if (this.c1.getByteHeap().getHeapValue(this.c1heap[this.iHeap + 2] + i) == this.c2.getByteHeap().getHeapValue(this.c2heap[this.iHeap + 2] + i)) continue block5;
                        return this.mismatchFs();
                    }
                    case Slot_ShortRef: {
                        if (this.c1.getShortHeap().getHeapValue(this.c1heap[this.iHeap + 2] + i) == this.c2.getShortHeap().getHeapValue(this.c2heap[this.iHeap + 2] + i)) continue block5;
                        return this.mismatchFs();
                    }
                    case Slot_LongRef: 
                    case Slot_DoubleRef: {
                        if (this.c1.getLongHeap().getHeapValue(this.c1heap[this.iHeap + 2] + i) == this.c1.getLongHeap().getHeapValue(this.c1heap[this.iHeap + 2] + i)) continue block5;
                        return this.mismatchFs();
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
            }
            return true;
        }

        private boolean compareSlot(int offset) {
            SlotKind kind = this.typeInfo.getSlotKind(offset);
            switch (kind) {
                case Slot_HeapRef: 
                case Slot_Int: 
                case Slot_Short: 
                case Slot_Float: 
                case Slot_Boolean: 
                case Slot_Byte: {
                    return this.c1heap[this.iHeap + offset] == this.c2heap[this.iHeap + offset];
                }
                case Slot_StrRef: {
                    return this.compareStrings(this.c1.getStringForCode(this.c1heap[this.iHeap + offset]), this.c2.getStringForCode(this.c2heap[this.iHeap + offset]));
                }
                case Slot_LongRef: 
                case Slot_DoubleRef: {
                    return this.c1.getLongHeap().getHeapValue(this.c1heap[this.iHeap + offset]) == this.c2.getLongHeap().getHeapValue(this.c2heap[this.iHeap + offset]);
                }
            }
            throw new RuntimeException("internal error");
        }

        private boolean compareStrings(String s1, String s2) {
            if (null == s1 && null == s2) {
                return true;
            }
            return s1.equals(s2);
        }

        private boolean mismatchFs() {
            System.err.format("Mismatched Feature Structures:%n %s%n %s%n", this.dumpHeapFs(this.c1), this.dumpHeapFs(this.c2));
            return false;
        }

        private StringBuilder dumpHeapFs(CASImpl cas) {
            StringBuilder sb = new StringBuilder();
            this.typeInfo = BinaryCasSerDes4.this.getTypeInfo(cas.getHeap().heap[this.iHeap]);
            sb.append(this.typeInfo);
            if (this.typeInfo.isHeapStoredArray) {
                sb.append((CharSequence)this.dumpHeapStoredArray(cas));
            } else if (this.typeInfo.isArray) {
                sb.append((CharSequence)this.dumpNonHeapStoredArray(cas));
            } else {
                sb.append("   Slots:\n");
                for (int i = 1; i < this.typeInfo.slotKinds.length + 1; ++i) {
                    sb.append("  ").append((Object)this.typeInfo.getSlotKind(i)).append(": ").append((CharSequence)this.dumpByKind(cas, i)).append('\n');
                }
            }
            return sb;
        }

        private StringBuilder dumpHeapStoredArray(CASImpl cas) {
            StringBuilder sb = new StringBuilder();
            int[] heap = cas.getHeap().heap;
            int length = heap[this.iHeap + 1];
            sb.append("Array Length: ").append(length).append('[');
            SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
            switch (arrayElementKind) {
                case Slot_HeapRef: 
                case Slot_Int: 
                case Slot_Short: 
                case Slot_Float: 
                case Slot_Boolean: 
                case Slot_Byte: {
                    for (int i = this.iHeap + 2; i < this.iHeap + length + 2; ++i) {
                        if (i > this.iHeap + 2) {
                            sb.append(", ");
                        }
                        sb.append(heap[i]);
                    }
                    break;
                }
                case Slot_StrRef: {
                    StringHeap sh = cas.getStringHeap();
                    for (int i = this.iHeap + 2; i < this.iHeap + length + 2; ++i) {
                        if (i > this.iHeap + 2) {
                            sb.append(", ");
                        }
                        sb.append(sh.getStringForCode(heap[i]));
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            sb.append("] ");
            return sb;
        }

        private StringBuilder dumpNonHeapStoredArray(CASImpl cas) {
            StringBuilder sb = new StringBuilder();
            int[] heap = cas.getHeap().heap;
            int length = heap[this.iHeap + 1];
            sb.append("Array Length: ").append(length).append('[');
            SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
            block5: for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                switch (arrayElementKind) {
                    case Slot_BooleanRef: 
                    case Slot_ByteRef: {
                        sb.append(cas.getByteHeap().getHeapValue(heap[this.iHeap + 2 + i]));
                        continue block5;
                    }
                    case Slot_ShortRef: {
                        sb.append(cas.getShortHeap().getHeapValue(heap[this.iHeap + 2 + i]));
                        continue block5;
                    }
                    case Slot_LongRef: 
                    case Slot_DoubleRef: {
                        long v = cas.getLongHeap().getHeapValue(heap[this.iHeap + 2 + i]);
                        if (arrayElementKind == SlotKind.Slot_DoubleRef) {
                            sb.append(Double.longBitsToDouble(v));
                            continue block5;
                        }
                        sb.append(String.format("%,d", v));
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
            }
            sb.append("] ");
            return sb;
        }

        private StringBuilder dumpByKind(CASImpl cas, int offset) {
            StringBuilder sb = new StringBuilder();
            int[] heap = cas.getHeap().heap;
            SlotKind kind = this.typeInfo.getSlotKind(offset);
            switch (kind) {
                case Slot_Int: {
                    return sb.append(heap[this.iHeap + offset]);
                }
                case Slot_Short: {
                    return sb.append((short)heap[this.iHeap + offset]);
                }
                case Slot_Byte: {
                    return sb.append((byte)heap[this.iHeap + offset]);
                }
                case Slot_Boolean: {
                    return sb.append(heap[this.iHeap + offset] != 0);
                }
                case Slot_Float: {
                    int v = heap[this.iHeap + offset];
                    return sb.append(Float.intBitsToFloat(v)).append(' ').append(Integer.toHexString(v));
                }
                case Slot_HeapRef: {
                    return sb.append("HeapRef[").append(heap[this.iHeap + offset]).append(']');
                }
                case Slot_StrRef: {
                    return sb.append(cas.getStringForCode(heap[this.iHeap + offset]));
                }
                case Slot_LongRef: {
                    return sb.append(String.format("%,d", cas.getLongHeap().getHeapValue(heap[this.iHeap + offset])));
                }
                case Slot_DoubleRef: {
                    long v = cas.getLongHeap().getHeapValue(heap[this.iHeap + offset]);
                    return sb.append(Double.longBitsToDouble(v)).append(' ').append(Long.toHexString(v));
                }
            }
            throw new RuntimeException("internal error");
        }
    }

    private class Deserializer {
        private final CASImpl cas;
        private final DataInput deserIn;
        private final DataInputStream[] dataInputs = new DataInputStream[SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
        private Inflater[] inflaters = new Inflater[SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
        private int[] heap;
        private int heapStart;
        private int heapEnd;
        private IntVector fixupsNeeded;
        private StringHeap stringHeapObj;
        private LongHeap longHeapObj;
        private ShortHeap shortHeapObj;
        private ByteHeap byteHeapObj;
        private int stringTableOffset;
        private int longZeroIndex = -1;
        private int double1Index = -1;
        private final boolean isDelta;
        private final ComprItemRefs fsStartIndexes = new ComprItemRefs();
        private String[] readCommonString;
        private TypeInfo typeInfo;
        private int iPrevHeap;
        private boolean only1CommonString;
        private final DataInputStream arrayLength_dis;
        private final DataInputStream heapRef_dis;
        private final DataInputStream int_dis;
        private final DataInputStream byte_dis;
        private final DataInputStream short_dis;
        private final DataInputStream typeCode_dis;
        private final DataInputStream strOffset_dis;
        private final DataInputStream strLength_dis;
        private final DataInputStream long_High_dis;
        private final DataInputStream long_Low_dis;
        private final DataInputStream float_Mantissa_Sign_dis;
        private final DataInputStream float_Exponent_dis;
        private final DataInputStream double_Mantissa_Sign_dis;
        private final DataInputStream double_Exponent_dis;
        private final DataInputStream fsIndexes_dis;
        private final DataInputStream strChars_dis;
        private final DataInputStream control_dis;
        private final DataInputStream strSeg_dis;

        Deserializer(CASImpl cas, DataInput deserIn, boolean isDelta) throws IOException {
            int i;
            this.cas = cas;
            this.deserIn = deserIn;
            this.isDelta = isDelta;
            this.stringHeapObj = cas.getStringHeap();
            this.longHeapObj = cas.getLongHeap();
            this.shortHeapObj = cas.getShortHeap();
            this.byteHeapObj = cas.getByteHeap();
            int nbrEntries = deserIn.readInt();
            IntVector idxAndLen = new IntVector(nbrEntries * 3);
            for (i = 0; i < nbrEntries; ++i) {
                idxAndLen.add(deserIn.readUnsignedByte());
                idxAndLen.add(deserIn.readInt());
                idxAndLen.add(deserIn.readInt());
            }
            i = 0;
            while (i < idxAndLen.size()) {
                this.setupReadStream(idxAndLen.get(i++), idxAndLen.get(i++), idxAndLen.get(i++));
            }
            this.arrayLength_dis = this.dataInputs[arrayLength_i];
            this.heapRef_dis = this.dataInputs[heapRef_i];
            this.int_dis = this.dataInputs[int_i];
            this.byte_dis = this.dataInputs[byte_i];
            this.short_dis = this.dataInputs[short_i];
            this.typeCode_dis = this.dataInputs[typeCode_i];
            this.strOffset_dis = this.dataInputs[strOffset_i];
            this.strLength_dis = this.dataInputs[strLength_i];
            this.long_High_dis = this.dataInputs[long_High_i];
            this.long_Low_dis = this.dataInputs[long_Low_i];
            this.float_Mantissa_Sign_dis = this.dataInputs[float_Mantissa_Sign_i];
            this.float_Exponent_dis = this.dataInputs[float_Exponent_i];
            this.double_Mantissa_Sign_dis = this.dataInputs[double_Mantissa_Sign_i];
            this.double_Exponent_dis = this.dataInputs[double_Exponent_i];
            this.fsIndexes_dis = this.dataInputs[fsIndexes_i];
            this.strChars_dis = this.dataInputs[strChars_i];
            this.control_dis = this.dataInputs[control_i];
            this.strSeg_dis = this.dataInputs[strSeg_i];
        }

        private void deserialize() throws IOException {
            int lenCmnStrs = this.readVnumber(this.strChars_dis);
            this.readCommonString = new String[lenCmnStrs];
            for (int i = 0; i < lenCmnStrs; ++i) {
                this.readCommonString[i] = DataIO.readUTFv(this.strChars_dis);
            }
            this.only1CommonString = lenCmnStrs == 1;
            int deltaHeapSize = this.readVnumber(this.control_dis);
            Heap heapObj = this.cas.getHeap();
            this.heapStart = this.isDelta ? heapObj.getNextId() : 0;
            int n = this.stringTableOffset = this.isDelta ? this.stringHeapObj.getSize() - 1 : 0;
            if (this.isDelta) {
                heapObj.grow(deltaHeapSize);
            } else {
                heapObj.reinitSizeOnly(deltaHeapSize);
            }
            this.heapEnd = this.heapStart + deltaHeapSize;
            this.heap = heapObj.heap;
            BinaryCasSerDes4.this.resetIprevious();
            if (this.heapStart == 0) {
                this.heapStart = 1;
            }
            if (this.heapStart > 1) {
                BinaryCasSerDes4.this.initFsStartIndexes(this.fsStartIndexes, this.heap, 1, this.heapStart, null);
            }
            this.fixupsNeeded = new IntVector(Math.max(16, this.heap.length / 10));
            for (int iHeap = this.heapStart; iHeap < this.heapEnd; iHeap += BinaryCasSerDes4.this.incrToNextFs(this.heap, iHeap, this.typeInfo)) {
                this.fsStartIndexes.addItemAddr(iHeap);
                int tCode = this.heap[iHeap] = this.readVnumber(this.typeCode_dis);
                this.typeInfo = BinaryCasSerDes4.this.getTypeInfo(tCode);
                this.iPrevHeap = this.typeInfo.iPrevHeap;
                if (this.typeInfo.isHeapStoredArray) {
                    this.readHeapStoredArray(iHeap);
                } else if (this.typeInfo.isArray) {
                    this.readNonHeapStoredArray(iHeap);
                } else {
                    for (int i = 1; i < this.typeInfo.slotKinds.length + 1; ++i) {
                        this.readByKind(iHeap, i);
                    }
                }
                this.typeInfo.iPrevHeap = iHeap;
            }
            this.fsStartIndexes.finishSetup();
            int end = this.fixupsNeeded.size();
            for (int i = 0; i < end; ++i) {
                int heapAddrToFix = this.fixupsNeeded.get(i);
                this.heap[heapAddrToFix] = this.fsStartIndexes.getItemAddr(this.heap[heapAddrToFix]);
            }
            this.readIndexedFeatureStructures();
            if (this.isDelta) {
                new ReadModifiedFSs().readModifiedFSs();
            }
            this.closeDataInputs();
        }

        private void readNonHeapStoredArray(int iHeap) throws IOException {
            int length = this.readArrayLength(iHeap);
            if (length == 0) {
                return;
            }
            SlotKind refKind = this.typeInfo.getSlotKind(2);
            switch (refKind) {
                case Slot_BooleanRef: 
                case Slot_ByteRef: {
                    this.heap[iHeap + 2] = this.readIntoByteArray(length);
                    break;
                }
                case Slot_ShortRef: {
                    this.heap[iHeap + 2] = this.readIntoShortArray(length);
                    break;
                }
                case Slot_LongRef: 
                case Slot_DoubleRef: {
                    this.heap[iHeap + 2] = this.readIntoLongArray(refKind, length);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        private int readArrayLength(int iHeap) throws IOException {
            int n = this.readVnumber(this.arrayLength_dis);
            this.heap[iHeap + 1] = n;
            return n;
        }

        private void readHeapStoredArray(int iHeap) throws IOException {
            int length = this.readArrayLength(iHeap);
            if (length == 0) {
                return;
            }
            SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
            int endi = iHeap + length + 2;
            switch (arrayElementKind) {
                case Slot_HeapRef: 
                case Slot_Int: 
                case Slot_Short: {
                    int prev = this.iPrevHeap == 0 ? 0 : (this.heap[this.iPrevHeap + 1] == 0 ? 0 : this.heap[this.iPrevHeap + 2]);
                    for (int i = iHeap + 2; i < endi; ++i) {
                        int v;
                        prev = v = (this.heap[i] = this.readDiff(arrayElementKind, prev));
                        if (arrayElementKind != SlotKind.Slot_HeapRef) continue;
                        this.fixupsNeeded.add(i);
                    }
                    break;
                }
                case Slot_Float: {
                    for (int i = iHeap + 2; i < endi; ++i) {
                        this.heap[i] = this.readFloat();
                    }
                    break;
                }
                case Slot_StrRef: {
                    for (int i = iHeap + 2; i < endi; ++i) {
                        this.heap[i] = this.readString();
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }

        private void readByKind(int iHeap, int offset) throws IOException {
            SlotKind kind = this.typeInfo.getSlotKind(offset);
            switch (kind) {
                case Slot_Int: 
                case Slot_Short: {
                    this.readDiffWithPrevTypeSlot(kind, iHeap, offset);
                    break;
                }
                case Slot_Float: {
                    this.heap[iHeap + offset] = this.readFloat();
                    break;
                }
                case Slot_Boolean: 
                case Slot_Byte: {
                    this.heap[iHeap + offset] = this.byte_dis.readByte();
                    break;
                }
                case Slot_HeapRef: {
                    this.readDiffWithPrevTypeSlot(kind, iHeap, offset);
                    if (kind != SlotKind.Slot_HeapRef) break;
                    this.fixupsNeeded.add(iHeap + offset);
                    break;
                }
                case Slot_StrRef: {
                    this.heap[iHeap + offset] = this.readString();
                    break;
                }
                case Slot_LongRef: {
                    long v = this.readLong(kind, this.iPrevHeap == 0 ? 0L : this.longHeapObj.getHeapValue(this.heap[this.iPrevHeap + offset]));
                    if (v == 0L) {
                        if (this.longZeroIndex == -1) {
                            this.longZeroIndex = this.longHeapObj.addLong(0L);
                        }
                        this.heap[iHeap + offset] = this.longZeroIndex;
                        break;
                    }
                    this.heap[iHeap + offset] = this.longHeapObj.addLong(v);
                    break;
                }
                case Slot_DoubleRef: {
                    long v = this.readDouble();
                    if (v == 0L) {
                        if (this.longZeroIndex == -1) {
                            this.longZeroIndex = this.longHeapObj.addLong(0L);
                        }
                        this.heap[iHeap + offset] = this.longZeroIndex;
                        break;
                    }
                    if (v == DBL_1) {
                        if (this.double1Index == -1) {
                            this.double1Index = this.longHeapObj.addLong(DBL_1);
                        }
                        this.heap[iHeap + offset] = this.double1Index;
                        break;
                    }
                    this.heap[iHeap + offset] = this.longHeapObj.addLong(v);
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }

        private void readIndexedFeatureStructures() throws IOException {
            int i;
            int nbrViews = this.readVnumber(this.control_dis);
            int nbrSofas = this.readVnumber(this.control_dis);
            IntVector fsIndexes = new IntVector(nbrViews + nbrSofas + 100);
            fsIndexes.add(nbrViews);
            fsIndexes.add(nbrSofas);
            for (i = 0; i < nbrSofas; ++i) {
                fsIndexes.add(this.readVnumber(this.control_dis));
            }
            for (i = 0; i < nbrViews; ++i) {
                this.readFsxPart(fsIndexes);
                if (!this.isDelta) continue;
                this.readFsxPart(fsIndexes);
                this.readFsxPart(fsIndexes);
            }
            if (this.isDelta) {
                this.cas.reinitDeltaIndexedFSs(fsIndexes.getArray());
            } else {
                this.cas.reinitIndexedFSs(fsIndexes.getArray());
            }
        }

        private void readFsxPart(IntVector fsIndexes) throws IOException {
            int nbrEntries = this.readVnumber(this.fsIndexes_dis);
            fsIndexes.add(nbrEntries);
            int prev = 0;
            for (int i = 0; i < nbrEntries; ++i) {
                int v;
                prev = v = this.readVnumber(this.fsIndexes_dis) + prev;
                v = this.fsStartIndexes.getItemAddr(v);
                fsIndexes.add(v);
            }
        }

        private void setupReadStream(int slotIndex, int bytesCompr, int bytesOrig) throws IOException {
            Inflater inflater;
            byte[] b = new byte[bytesCompr + 1];
            this.deserIn.readFully(b, 0, bytesCompr);
            this.inflaters[slotIndex] = inflater = new Inflater(true);
            ByteArrayInputStream baiStream = new ByteArrayInputStream(b);
            int zipBufSize = Math.max(32768, bytesCompr);
            InflaterInputStream iis = new InflaterInputStream(baiStream, inflater, zipBufSize);
            this.dataInputs[slotIndex] = new DataInputStream(new BufferedInputStream(iis, zipBufSize));
        }

        private void closeDataInputs() {
            for (DataInputStream is : this.dataInputs) {
                if (null == is) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            for (Inflater inflater : this.inflaters) {
                if (null == inflater) continue;
                inflater.end();
            }
        }

        private DataInput getInputStream(SlotKind kind) {
            return this.dataInputs[kind.i];
        }

        private int readVnumber(DataInputStream dis) throws IOException {
            return DataIO.readVnumber(dis);
        }

        private long readVlong(DataInputStream dis) throws IOException {
            return DataIO.readVlong(dis);
        }

        private int readIntoByteArray(int length) throws IOException {
            int startPos = this.byteHeapObj.reserve(length);
            this.byte_dis.readFully(this.byteHeapObj.heap, startPos, length);
            return startPos;
        }

        private int readIntoShortArray(int length) throws IOException {
            int startPos = this.shortHeapObj.reserve(length);
            short[] h = this.shortHeapObj.heap;
            int endPos = startPos + length;
            int prev = 0;
            for (int i = startPos; i < endPos; ++i) {
                prev = (short)this.readDiff(this.short_dis, prev);
            }
            return startPos;
        }

        private int readIntoLongArray(SlotKind kind, int length) throws IOException {
            int startPos = this.longHeapObj.reserve(length);
            long[] h = this.longHeapObj.heap;
            int endPos = startPos + length;
            long prev = 0L;
            for (int i = startPos; i < endPos; ++i) {
                h[i] = prev = this.readLong(kind, prev);
            }
            return startPos;
        }

        private void readDiffWithPrevTypeSlot(SlotKind kind, int iHeap, int offset) throws IOException {
            int prev = this.iPrevHeap == 0 ? 0 : this.heap[this.iPrevHeap + offset];
            this.heap[iHeap + offset] = this.readDiff(kind, prev);
        }

        private int readDiff(SlotKind kind, int prev) throws IOException {
            return this.readDiff(this.getInputStream(kind), prev);
        }

        private int readDiff(DataInput in, int prev) throws IOException {
            long encoded = this.readVlong(in);
            boolean isDelta = 0L != (encoded & 1L);
            boolean isNegative = 0L != (encoded & 2L);
            int v = (int)(encoded >>> 2);
            if (isNegative) {
                if (v == 0) {
                    return Integer.MIN_VALUE;
                }
                v = -v;
            }
            if (isDelta) {
                v += prev;
            }
            return v;
        }

        private long readLong(SlotKind kind, long prev) throws IOException {
            if (kind == SlotKind.Slot_DoubleRef) {
                return this.readDouble();
            }
            int vh = this.readDiff(this.long_High_dis, (int)(prev >>> 32));
            int vl = this.readDiff(this.long_Low_dis, (int)prev);
            long v = (long)vh << 32 | 0xFFFFFFFFL & (long)vl;
            return v;
        }

        private int readFloat() throws IOException {
            int exponent = this.readVnumber(this.float_Exponent_dis);
            if (exponent == 0) {
                return 0;
            }
            int mants = this.readVnumber(this.float_Mantissa_Sign_dis);
            boolean isNegative = (mants & 1) == 1;
            mants >>>= 1;
            mants = Integer.reverse(mants) >>> 9;
            return exponent - 1 << 23 | mants | (isNegative ? Integer.MIN_VALUE : 0);
        }

        private int decodeIntSign(int v) {
            if (1 == (v & 1)) {
                return -(v >>> 1);
            }
            return v >>> 1;
        }

        private long readDouble() throws IOException {
            int exponent = this.readVnumber(this.double_Exponent_dis);
            if (exponent == 0) {
                return 0L;
            }
            long mants = this.readVlong(this.double_Mantissa_Sign_dis);
            return this.decodeDouble(mants, exponent);
        }

        private long decodeDouble(long mants, int exponent) {
            if ((exponent = this.decodeIntSign(exponent)) > 0) {
                --exponent;
            }
            long r = (long)((exponent += 1023) & 0x7FF) << 52;
            boolean isNegative = 1L == (mants & 1L);
            mants = Long.reverse(mants >>> 1) >>> 12;
            r = r | mants | (isNegative ? Long.MIN_VALUE : 0L);
            return r;
        }

        private long readVlong(DataInput dis) throws IOException {
            return DataIO.readVlong(dis);
        }

        private int readString() throws IOException {
            int length = this.decodeIntSign(this.readVnumber(this.strLength_dis));
            if (0 == length) {
                return 0;
            }
            if (1 == length) {
                return this.stringHeapObj.addString("");
            }
            if (length < 0) {
                return this.stringTableOffset - length;
            }
            int offset = this.readVnumber(this.strOffset_dis);
            int segmentIndex = this.only1CommonString ? 0 : this.readVnumber(this.strSeg_dis);
            String s = this.readCommonString[segmentIndex].substring(offset, offset + length - 1);
            return this.stringHeapObj.addString(s);
        }

        class ReadModifiedFSs {
            int vPrevModInt = 0;
            int vPrevModHeapRef = 0;
            short vPrevModShort = 0;
            long vPrevModLong = 0L;
            int iHeap;
            TypeInfo typeInfo;

            ReadModifiedFSs() {
            }

            private void readModifiedFSs() throws IOException {
                int modFSsLength = Deserializer.this.readVnumber(Deserializer.this.control_dis);
                Deserializer.this.iPrevHeap = 0;
                for (int i = 0; i < modFSsLength; ++i) {
                    this.iHeap = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis) + Deserializer.this.iPrevHeap;
                    Deserializer.this.iPrevHeap = this.iHeap;
                    int tCode = Deserializer.this.heap[this.iHeap];
                    this.typeInfo = BinaryCasSerDes4.this.getTypeInfo(tCode);
                    int numberOfModsInThisFs = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis);
                    if (this.typeInfo.isArray && !this.typeInfo.isHeapStoredArray) {
                        this.readModifiedAuxHeap(numberOfModsInThisFs);
                        continue;
                    }
                    this.readModifiedMainHeap(numberOfModsInThisFs);
                }
            }

            private void readModifiedAuxHeap(int numberOfMods) throws IOException {
                boolean isAuxLong;
                int prevOffset = 0;
                int auxHeapIndex = Deserializer.this.heap[this.iHeap + 2];
                SlotKind kind = this.typeInfo.getSlotKind(2);
                boolean isAuxByte = kind == SlotKind.Slot_BooleanRef || kind == SlotKind.Slot_ByteRef;
                boolean isAuxShort = kind == SlotKind.Slot_ShortRef;
                boolean bl = isAuxLong = kind == SlotKind.Slot_LongRef || kind == SlotKind.Slot_DoubleRef;
                if (!(isAuxByte | isAuxShort | isAuxLong)) {
                    throw new RuntimeException();
                }
                for (int i2 = 0; i2 < numberOfMods; ++i2) {
                    int offset;
                    prevOffset = offset = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis) + prevOffset;
                    if (isAuxByte) {
                        Deserializer.this.byteHeapObj.setHeapValue(Deserializer.this.byte_dis.readByte(), auxHeapIndex + offset);
                        continue;
                    }
                    if (isAuxShort) {
                        short v;
                        this.vPrevModShort = v = (short)Deserializer.this.readDiff(Deserializer.this.int_dis, this.vPrevModShort);
                        Deserializer.this.shortHeapObj.setHeapValue(v, auxHeapIndex + offset);
                        continue;
                    }
                    long v = Deserializer.this.readLong(kind, this.vPrevModLong);
                    if (kind == SlotKind.Slot_LongRef) {
                        this.vPrevModLong = v;
                    }
                    Deserializer.this.longHeapObj.setHeapValue(v, auxHeapIndex + offset);
                }
            }

            private void readModifiedMainHeap(int numberOfMods) throws IOException {
                int iPrevOffsetInFs = 0;
                block9: for (int i = 0; i < numberOfMods; ++i) {
                    int offsetInFs;
                    iPrevOffsetInFs = offsetInFs = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis) + iPrevOffsetInFs;
                    SlotKind kind = this.typeInfo.getSlotKind(this.typeInfo.isArray ? 2 : offsetInFs);
                    switch (kind) {
                        case Slot_HeapRef: {
                            int v;
                            this.vPrevModHeapRef = v = Deserializer.this.readDiff(Deserializer.this.heapRef_dis, this.vPrevModHeapRef);
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = v = Deserializer.this.fsStartIndexes.getItemAddr(v);
                            continue block9;
                        }
                        case Slot_Int: {
                            int v;
                            this.vPrevModInt = v = Deserializer.this.readDiff(Deserializer.this.int_dis, this.vPrevModInt);
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = v;
                            continue block9;
                        }
                        case Slot_Short: {
                            int v = Deserializer.this.readDiff(Deserializer.this.int_dis, this.vPrevModShort);
                            this.vPrevModShort = (short)v;
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = v;
                            continue block9;
                        }
                        case Slot_LongRef: 
                        case Slot_DoubleRef: {
                            long v = Deserializer.this.readLong(kind, this.vPrevModLong);
                            if (kind == SlotKind.Slot_LongRef) {
                                this.vPrevModLong = v;
                            }
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = Deserializer.this.longHeapObj.addLong(v);
                            continue block9;
                        }
                        case Slot_Boolean: 
                        case Slot_Byte: {
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = Deserializer.this.byte_dis.readByte();
                            continue block9;
                        }
                        case Slot_Float: {
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = Deserializer.this.readFloat();
                            continue block9;
                        }
                        case Slot_StrRef: {
                            ((Deserializer)Deserializer.this).heap[this.iHeap + offsetInFs] = Deserializer.this.readString();
                            continue block9;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
            }
        }
    }

    private class Serializer {
        private final DataOutputStream serializedOut;
        private final CASImpl cas;
        private final MarkerImpl mark;
        private final SerializationMeasures sm;
        private final ByteArrayOutputStream[] baosZipSources = new ByteArrayOutputStream[SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
        private final DataOutputStream[] dosZipSources = new DataOutputStream[SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
        private final int[] heap;
        private int heapStart;
        private final int heapEnd;
        private final StringHeap stringHeapObj;
        private final LongHeap longHeapObj;
        private final ShortHeap shortHeapObj;
        private final ByteHeap byteHeapObj;
        private final boolean isDelta;
        private final boolean doMeasurement;
        private final ComprItemRefs fsStartIndexes = new ComprItemRefs();
        private final int[] typeCodeHisto = new int[BinaryCasSerDes4.access$300(BinaryCasSerDes4.this).getTypeArraySize()];
        private final Integer[] serializedTypeCode2Code = new Integer[BinaryCasSerDes4.access$300(BinaryCasSerDes4.this).getTypeArraySize()];
        private final int[] estimatedZipSize = new int[SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
        private final OptimizeStrings os;
        private final CompressLevel compressLevel;
        private final CompressStrat compressStrategy;
        private TypeInfo typeInfo;
        private int iPrevHeap;
        private boolean only1CommonString;
        private final DataOutputStream arrayLength_dos;
        private final DataOutputStream heapRef_dos;
        private final DataOutputStream int_dos;
        private final DataOutputStream byte_dos;
        private final DataOutputStream short_dos;
        private final DataOutputStream typeCode_dos;
        private final DataOutputStream strOffset_dos;
        private final DataOutputStream strLength_dos;
        private final DataOutputStream long_High_dos;
        private final DataOutputStream long_Low_dos;
        private final DataOutputStream float_Mantissa_Sign_dos;
        private final DataOutputStream float_Exponent_dos;
        private final DataOutputStream double_Mantissa_Sign_dos;
        private final DataOutputStream double_Exponent_dos;
        private final DataOutputStream fsIndexes_dos;
        private final DataOutputStream strChars_dos;
        private final DataOutputStream control_dos;
        private final DataOutputStream strSeg_dos;

        private Serializer(CASImpl cas, DataOutputStream serializedOut, MarkerImpl mark, SerializationMeasures sm, CompressLevel compressLevel, CompressStrat compressStrategy) {
            this.cas = cas;
            this.serializedOut = serializedOut;
            this.mark = mark;
            this.sm = sm;
            this.compressLevel = compressLevel;
            this.compressStrategy = compressStrategy;
            this.isDelta = mark != null;
            this.doMeasurement = sm != null;
            this.heap = cas.getHeap().heap;
            this.heapEnd = cas.getHeap().getCellsUsed();
            this.heapStart = this.isDelta ? mark.getNextFSId() : 0;
            this.stringHeapObj = cas.getStringHeap();
            this.longHeapObj = cas.getLongHeap();
            this.shortHeapObj = cas.getShortHeap();
            this.byteHeapObj = cas.getByteHeap();
            this.os = new OptimizeStrings(this.doMeasurement);
            this.setupOutputStreams();
            this.arrayLength_dos = this.dosZipSources[arrayLength_i];
            this.heapRef_dos = this.dosZipSources[heapRef_i];
            this.int_dos = this.dosZipSources[int_i];
            this.byte_dos = this.dosZipSources[byte_i];
            this.short_dos = this.dosZipSources[short_i];
            this.typeCode_dos = this.dosZipSources[typeCode_i];
            this.strOffset_dos = this.dosZipSources[strOffset_i];
            this.strLength_dos = this.dosZipSources[strLength_i];
            this.long_High_dos = this.dosZipSources[long_High_i];
            this.long_Low_dos = this.dosZipSources[long_Low_i];
            this.float_Mantissa_Sign_dos = this.dosZipSources[float_Mantissa_Sign_i];
            this.float_Exponent_dos = this.dosZipSources[float_Exponent_i];
            this.double_Mantissa_Sign_dos = this.dosZipSources[double_Mantissa_Sign_i];
            this.double_Exponent_dos = this.dosZipSources[double_Exponent_i];
            this.fsIndexes_dos = this.dosZipSources[fsIndexes_i];
            this.strChars_dos = this.dosZipSources[strChars_i];
            this.control_dos = this.dosZipSources[control_i];
            this.strSeg_dos = this.dosZipSources[strSeg_i];
        }

        private void setupOutputStreams() {
            int compr = (this.heapEnd - this.heapStart) * 8 / 3 / 50;
            int compr1000 = Math.max(512, compr / 1000);
            this.estimatedZipSize[typeCode_i] = Math.max(512, compr / 4);
            this.estimatedZipSize[byte_i] = compr1000;
            this.estimatedZipSize[short_i] = compr1000;
            this.estimatedZipSize[int_i] = Math.max(1024, compr1000);
            this.estimatedZipSize[arrayLength_i] = compr1000;
            this.estimatedZipSize[float_Mantissa_Sign_i] = compr1000;
            this.estimatedZipSize[float_Exponent_i] = compr1000;
            this.estimatedZipSize[double_Mantissa_Sign_i] = compr1000;
            this.estimatedZipSize[double_Exponent_i] = compr1000;
            this.estimatedZipSize[long_High_i] = compr1000;
            this.estimatedZipSize[long_Low_i] = compr1000;
            this.estimatedZipSize[heapRef_i] = Math.max(1024, compr1000);
            this.estimatedZipSize[strOffset_i] = Math.max(512, compr / 4);
            this.estimatedZipSize[strLength_i] = Math.max(512, compr / 4);
            this.estimatedZipSize[fsIndexes_i] = Math.max(512, compr / 8);
            this.estimatedZipSize[strChars_i] = Math.max(512, compr / 4);
            this.estimatedZipSize[control_i] = 128;
            for (int i = 0; i < this.baosZipSources.length; ++i) {
                this.setupOutputStream(i);
            }
        }

        private void serialize() throws IOException {
            int i;
            if (this.doMeasurement) {
                System.out.println(BinaryCasSerDes4.this.printCasInfo(this.cas));
                this.sm.origAuxBytes = this.cas.getByteHeap().getSize();
                this.sm.origAuxShorts = this.cas.getShortHeap().getSize() * 2;
                this.sm.origAuxLongs = this.cas.getLongHeap().getSize() * 8;
                this.sm.totalTime = System.currentTimeMillis();
            }
            int version = 4 | (this.isDelta ? 2 : 0);
            CASSerializer.outputVersion(version, this.serializedOut);
            this.serializedOut.writeInt(0);
            if (this.doMeasurement) {
                this.sm.header = 12;
            }
            int stringHeapStart = this.isDelta ? this.mark.nextStringHeapAddr : 1;
            int stringHeapEnd = this.stringHeapObj.getSize();
            for (int i2 = stringHeapStart; i2 < stringHeapEnd; ++i2) {
                this.os.add(this.stringHeapObj.getStringForCode(i2));
            }
            this.os.optimize();
            String[] commonStrings = this.os.getCommonStrings();
            this.writeVnumber(strChars_i, commonStrings.length);
            for (i = 0; i < commonStrings.length; ++i) {
                int startPos = this.dosZipSources[strChars_i].size();
                DataIO.writeUTFv(commonStrings[i], this.dosZipSources[strChars_i]);
                if (!this.doMeasurement) continue;
                float len = this.dosZipSources[strChars_i].size() - startPos;
                float excess = len / (float)commonStrings[i].length() - 1.0f;
                int encAs2 = (int)(excess * (float)commonStrings[i].length());
                this.sm.statDetails[strChars_i].countTotal += commonStrings[i].length();
                this.sm.statDetails[strChars_i].c[0] = commonStrings[i].length() - encAs2;
                this.sm.statDetails[strChars_i].c[1] = encAs2;
                this.sm.statDetails[strChars_i].lengthTotal = (int)((float)this.sm.statDetails[strChars_i].lengthTotal + len);
            }
            boolean bl = this.only1CommonString = commonStrings.length == 1;
            if (this.doMeasurement) {
                long commonStringsLength = 0L;
                this.sm.stringsNbrCommon = commonStrings.length;
                int r = 0;
                for (int i3 = 0; i3 < commonStrings.length; ++i3) {
                    r = (int)((long)r + DataIO.lengthUTFv(commonStrings[i3]));
                    commonStringsLength += (long)commonStrings[i3].length();
                }
                this.sm.stringsCommonChars = r;
                this.sm.stringsSavedExact = this.os.getSavedCharsExact() * 2L;
                this.sm.stringsSavedSubstr = this.os.getSavedCharsSubstr() * 2L;
                this.sm.statDetails[strChars_i].original = this.os.getSavedCharsExact() * 2L + this.os.getSavedCharsSubstr() * 2L + commonStringsLength * 2L;
                this.sm.statDetails[strLength_i].original = (stringHeapEnd - stringHeapStart) * 4;
                this.sm.statDetails[strOffset_i].original = (stringHeapEnd - stringHeapStart) * 4;
            }
            this.writeVnumber(this.control_dos, this.heapEnd - this.heapStart);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKind.Slot_MainHeap.i].original = (1 + this.heapEnd - this.heapStart) * 4;
            }
            BinaryCasSerDes4.this.resetIprevious();
            if (this.heapStart == 0) {
                this.heapStart = 1;
            }
            BinaryCasSerDes4.this.initFsStartIndexes(this.fsStartIndexes, this.heap, this.heapStart, this.heapEnd, this.typeCodeHisto);
            for (i = BinaryCasSerDes4.this.ts.getTypeArraySize() - 1; i >= 0; --i) {
                this.serializedTypeCode2Code[i] = i;
            }
            Arrays.sort(this.serializedTypeCode2Code, 0, this.serializedTypeCode2Code.length, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return Serializer.this.typeCodeHisto[o1] > Serializer.this.typeCodeHisto[o2] ? -1 : (Serializer.this.typeCodeHisto[o1] < Serializer.this.typeCodeHisto[o2] ? 1 : 0);
                }
            });
            for (int iHeap = this.heapStart; iHeap < this.heapEnd; iHeap += BinaryCasSerDes4.this.incrToNextFs(this.heap, iHeap, this.typeInfo)) {
                int tCode = this.heap[iHeap];
                this.typeInfo = BinaryCasSerDes4.this.getTypeInfo(tCode);
                this.iPrevHeap = this.typeInfo.iPrevHeap;
                this.writeVnumber(this.typeCode_dos, tCode);
                if (this.typeInfo.isHeapStoredArray) {
                    this.serializeHeapStoredArray(iHeap);
                } else if (this.typeInfo.isArray) {
                    this.serializeNonHeapStoredArray(iHeap);
                } else {
                    for (int i4 = 1; i4 < this.typeInfo.slotKinds.length + 1; ++i4) {
                        this.serializeByKind(iHeap, i4);
                    }
                }
                this.typeInfo.iPrevHeap = iHeap;
                if (!this.doMeasurement) continue;
                this.sm.statDetails[typeCode_i].incr(DataIO.lengthVnumber(tCode));
                ++this.sm.mainHeapFSs;
            }
            this.serializeIndexedFeatureStructures();
            if (this.isDelta) {
                new SerializeModifiedFSs().serializeModifiedFSs();
            }
            this.collectAndZip();
            if (this.doMeasurement) {
                this.sm.totalTime = System.currentTimeMillis() - this.sm.totalTime;
            }
        }

        private void serializeIndexedFeatureStructures() throws IOException {
            int fi;
            int[] fsIndexes;
            int[] nArray = fsIndexes = this.isDelta ? this.cas.getDeltaIndexedFSs(this.mark) : this.cas.getIndexedFSs();
            if (this.doMeasurement) {
                this.sm.statDetails[fsIndexes_i].original = fsIndexes.length * 4 + 1;
            }
            int nbrViews = fsIndexes[0];
            int nbrSofas = fsIndexes[1];
            this.writeVnumber(control_i, nbrViews);
            this.writeVnumber(control_i, nbrSofas);
            if (this.doMeasurement) {
                this.sm.statDetails[fsIndexes_i].incr(1);
                this.sm.statDetails[fsIndexes_i].incr(1);
            }
            int end1 = nbrSofas + 2;
            for (fi = 2; fi < end1; ++fi) {
                this.writeVnumber(control_i, fsIndexes[fi]);
                if (!this.doMeasurement) continue;
                this.sm.statDetails[fsIndexes_i].incr(DataIO.lengthVnumber(fsIndexes[fi]));
            }
            for (int vi = 0; vi < nbrViews; ++vi) {
                fi = this.compressFsxPart(fsIndexes, fi);
                if (!this.isDelta) continue;
                fi = this.compressFsxPart(fsIndexes, fi);
                fi = this.compressFsxPart(fsIndexes, fi);
            }
        }

        private int compressFsxPart(int[] fsIndexes, int fsNdxStart) throws IOException {
            int ix = fsNdxStart;
            int nbrEntries = fsIndexes[ix++];
            int end = ix + nbrEntries;
            this.writeVnumber(this.fsIndexes_dos, nbrEntries);
            if (this.doMeasurement) {
                this.sm.statDetails[typeCode_i].incr(DataIO.lengthVnumber(nbrEntries));
            }
            int[] ia = new int[nbrEntries];
            System.arraycopy(fsIndexes, ix, ia, 0, nbrEntries);
            Arrays.sort(ia);
            int prev = 0;
            for (int i = 0; i < ia.length; ++i) {
                int v = ia[i];
                v = this.fsStartIndexes.getItemIndex(v);
                this.writeVnumber(this.fsIndexes_dos, v - prev);
                if (this.doMeasurement) {
                    this.sm.statDetails[fsIndexes_i].incr(DataIO.lengthVnumber(v - prev));
                }
                prev = v;
            }
            return end;
        }

        private void serializeHeapStoredArray(int iHeap) throws IOException {
            int length = this.serializeArrayLength(iHeap);
            if (length == 0) {
                return;
            }
            SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
            int endi = iHeap + length + 2;
            switch (arrayElementKind) {
                case Slot_HeapRef: 
                case Slot_Int: 
                case Slot_Short: {
                    int prev = this.iPrevHeap == 0 ? 0 : (this.heap[this.iPrevHeap + 1] == 0 ? 0 : this.heap[this.iPrevHeap + 2]);
                    for (int i = iHeap + 2; i < endi; ++i) {
                        prev = this.writeIntOrHeapRef(arrayElementKind.i, i, prev);
                    }
                    break;
                }
                case Slot_Float: {
                    for (int i = iHeap + 2; i < endi; ++i) {
                        this.writeFloat(this.heap[i]);
                    }
                    break;
                }
                case Slot_StrRef: {
                    for (int i = iHeap + 2; i < endi; ++i) {
                        this.writeString(this.stringHeapObj.getStringForCode(this.heap[i]));
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }

        private int writeIntOrHeapRef(int kind, int index, int prev) throws IOException {
            int v = this.heap[index];
            this.writeDiff(kind, v, prev);
            return v;
        }

        private long writeLongFromHeapIndex(int index, long prev) throws IOException {
            long v = this.longHeapObj.getHeapValue(this.heap[index]);
            this.writeLong(v, prev);
            return v;
        }

        private void serializeNonHeapStoredArray(int iHeap) throws IOException {
            int length = this.serializeArrayLength(iHeap);
            if (length == 0) {
                return;
            }
            SlotKind refKind = this.typeInfo.getSlotKind(2);
            switch (refKind) {
                case Slot_BooleanRef: 
                case Slot_ByteRef: {
                    this.writeFromByteArray(refKind, this.heap[iHeap + 2], length);
                    if (!this.doMeasurement) break;
                    this.sm.statDetails[byte_i].incr(1);
                    this.sm.origAuxByteArrayRefs += 4L;
                    break;
                }
                case Slot_ShortRef: {
                    this.writeFromShortArray(this.heap[iHeap + 2], length);
                    if (!this.doMeasurement) break;
                    this.sm.origAuxShortArrayRefs += 4L;
                    break;
                }
                case Slot_LongRef: 
                case Slot_DoubleRef: {
                    this.writeFromLongArray(refKind, this.heap[iHeap + 2], length);
                    if (!this.doMeasurement) break;
                    this.sm.origAuxLongArrayRefs += 4L;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        private void serializeByKind(int iHeap, int offset) throws IOException {
            SlotKind kind = this.typeInfo.getSlotKind(offset);
            switch (kind) {
                case Slot_HeapRef: 
                case Slot_Int: 
                case Slot_Short: {
                    this.serializeDiffWithPrevTypeSlot(kind, iHeap, offset);
                    break;
                }
                case Slot_Float: {
                    this.writeFloat(this.heap[iHeap + offset]);
                    break;
                }
                case Slot_Boolean: 
                case Slot_Byte: {
                    this.byte_dos.write(this.heap[iHeap + offset]);
                    break;
                }
                case Slot_StrRef: {
                    this.writeString(this.stringHeapObj.getStringForCode(this.heap[iHeap + offset]));
                    break;
                }
                case Slot_LongRef: {
                    this.writeLongFromHeapIndex(iHeap + offset, this.iPrevHeap == 0 ? 0L : this.longHeapObj.getHeapValue(this.heap[this.iPrevHeap + offset]));
                    break;
                }
                case Slot_DoubleRef: {
                    this.writeDouble(this.longHeapObj.getHeapValue(this.heap[iHeap + offset]));
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }

        private int serializeArrayLength(int iHeap) throws IOException {
            int length = this.heap[iHeap + 1];
            this.writeVnumber(arrayLength_i, length);
            return length;
        }

        private void serializeDiffWithPrevTypeSlot(SlotKind kind, int iHeap, int offset) throws IOException {
            int prev = this.iPrevHeap == 0 ? 0 : this.heap[this.iPrevHeap + offset];
            this.writeDiff(kind.i, this.heap[iHeap + offset], prev);
        }

        private void collectAndZip() throws IOException {
            int i;
            ByteArrayOutputStream baosZipped = new ByteArrayOutputStream(4096);
            Deflater deflater = new Deflater(this.compressLevel.lvl, true);
            deflater.setStrategy(this.compressStrategy.strat);
            int nbrEntries = 0;
            ArrayList<Integer> idxAndLen = new ArrayList<Integer>();
            for (i = 0; i < this.baosZipSources.length; ++i) {
                ByteArrayOutputStream baos = this.baosZipSources[i];
                if (baos == null) continue;
                ++nbrEntries;
                this.dosZipSources[i].close();
                long startTime = System.currentTimeMillis();
                int zipBufSize = Math.max(1024, baos.size() / 100);
                deflater.reset();
                DeflaterOutputStream cds = new DeflaterOutputStream((OutputStream)baosZipped, deflater, zipBufSize);
                baos.writeTo(cds);
                cds.close();
                idxAndLen.add(i);
                if (this.doMeasurement) {
                    this.sm.statDetails[i].afterZip = deflater.getBytesWritten();
                    idxAndLen.add((int)this.sm.statDetails[i].afterZip);
                    this.sm.statDetails[i].beforeZip = deflater.getBytesRead();
                    idxAndLen.add((int)this.sm.statDetails[i].beforeZip);
                    this.sm.statDetails[i].zipTime = System.currentTimeMillis() - startTime;
                    continue;
                }
                idxAndLen.add((int)deflater.getBytesWritten());
                idxAndLen.add((int)deflater.getBytesRead());
            }
            this.serializedOut.writeInt(nbrEntries);
            i = 0;
            while (i < idxAndLen.size()) {
                this.serializedOut.write((Integer)idxAndLen.get(i++));
                this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
                this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
            }
            baosZipped.writeTo(this.serializedOut);
        }

        public DataOutputStream setupOutputStream(int i) {
            int size = this.estimatedZipSize[i];
            this.baosZipSources[i] = new ByteArrayOutputStream(size);
            this.dosZipSources[i] = new DataOutputStream(this.baosZipSources[i]);
            return this.dosZipSources[i];
        }

        private void writeLong(long v, long prev) throws IOException {
            this.writeDiff(long_High_i, (int)(v >>> 32), (int)(prev >>> 32));
            this.writeDiff(long_Low_i, (int)v, (int)prev);
        }

        private void writeString(String s) throws IOException {
            if (null == s) {
                this.writeVnumber(this.strLength_dos, 0);
                if (this.doMeasurement) {
                    this.sm.statDetails[strLength_i].incr(1);
                }
                return;
            }
            int indexOrSeq = this.os.getIndexOrSeqIndex(s);
            if (indexOrSeq < 0) {
                int v = this.encodeIntSign(indexOrSeq);
                this.writeVnumber(this.strLength_dos, v);
                if (this.doMeasurement) {
                    this.sm.statDetails[strLength_i].incr(DataIO.lengthVnumber(v));
                }
                return;
            }
            if (s.length() == 0) {
                this.writeVnumber(this.strLength_dos, this.encodeIntSign(1));
                if (this.doMeasurement) {
                    this.sm.statDetails[strLength_i].incr(1);
                }
                return;
            }
            if (s.length() == Integer.MAX_VALUE) {
                throw new RuntimeException("Cannot serialize string of Integer.MAX_VALUE length - too large.");
            }
            int offset = this.os.getOffset(indexOrSeq);
            int length = this.encodeIntSign(s.length() + 1);
            this.writeVnumber(this.strOffset_dos, offset);
            this.writeVnumber(this.strLength_dos, length);
            if (this.doMeasurement) {
                this.sm.statDetails[strOffset_i].incr(DataIO.lengthVnumber(offset));
                this.sm.statDetails[strLength_i].incr(DataIO.lengthVnumber(length));
            }
            if (!this.only1CommonString) {
                int csi = this.os.getCommonStringIndex(indexOrSeq);
                this.writeVnumber(this.strSeg_dos, csi);
                if (this.doMeasurement) {
                    this.sm.statDetails[strSeg_i].incr(DataIO.lengthVnumber(csi));
                }
            }
        }

        private void writeFloat(int raw) throws IOException {
            if (raw == 0) {
                this.writeUnsignedByte(this.float_Exponent_dos, 0);
                if (this.doMeasurement) {
                    this.sm.statDetails[float_Exponent_i].incr(1);
                }
                return;
            }
            int exponent = (raw >>> 23 & 0xFF) + 1;
            int revMants = Integer.reverse((raw & 0x7FFFFF) << 9);
            int mants = (revMants << 1) + (raw < 0 ? 1 : 0);
            this.writeVnumber(this.float_Exponent_dos, exponent);
            this.writeVnumber(this.float_Mantissa_Sign_dos, mants);
            if (this.doMeasurement) {
                this.sm.statDetails[float_Exponent_i].incr(DataIO.lengthVnumber(exponent));
                this.sm.statDetails[float_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
            }
        }

        private void writeVnumber(int kind, int v) throws IOException {
            DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
            if (this.doMeasurement) {
                this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
            }
        }

        private void writeVnumber(int kind, long v) throws IOException {
            DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
            if (this.doMeasurement) {
                this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
            }
        }

        private void writeVnumber(DataOutputStream s, int v) throws IOException {
            DataIO.writeVnumber((DataOutput)s, v);
        }

        private void writeVnumber(DataOutputStream s, long v) throws IOException {
            DataIO.writeVnumber((DataOutput)s, v);
        }

        private void writeUnsignedByte(DataOutputStream s, int v) throws IOException {
            s.write(v);
        }

        private void writeDouble(long raw) throws IOException {
            if (raw == 0L) {
                this.writeVnumber(this.double_Exponent_dos, 0);
                if (this.doMeasurement) {
                    this.sm.statDetails[double_Exponent_i].incr(1);
                }
                return;
            }
            int exponent = (int)(raw >>> 52 & 0x7FFL);
            if ((exponent -= 1023) >= 0) {
                ++exponent;
            }
            exponent = this.encodeIntSign(exponent);
            long revMants = Long.reverse((raw & 0xFFFFFFFFFFFFFL) << 12);
            long mants = (revMants << 1) + (long)(raw < 0L ? 1 : 0);
            this.writeVnumber(this.double_Exponent_dos, exponent);
            this.writeVnumber(this.double_Mantissa_Sign_dos, mants);
            if (this.doMeasurement) {
                this.sm.statDetails[double_Exponent_i].incr(DataIO.lengthVnumber(exponent));
                this.sm.statDetails[double_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
            }
        }

        private int encodeIntSign(int v) {
            if (v < 0) {
                return -v << 1 | 1;
            }
            return v << 1;
        }

        private void writeDiff(int kind, int v, int prev) throws IOException {
            if (v == 0) {
                this.writeVnumber(kind, 0);
                if (this.doMeasurement) {
                    ++this.sm.statDetails[kind].diffEncoded;
                    ++this.sm.statDetails[kind].valueLeDiff;
                }
                return;
            }
            if (v == Integer.MIN_VALUE) {
                this.writeVnumber(kind, 2);
                if (this.doMeasurement) {
                    ++this.sm.statDetails[kind].diffEncoded;
                    ++this.sm.statDetails[kind].valueLeDiff;
                }
                return;
            }
            if (kind == heapRef_i) {
                v = this.fsStartIndexes.getItemIndex(v);
                if (prev != 0) {
                    prev = this.fsStartIndexes.getItemIndex(prev);
                }
            }
            int absV = Math.abs(v);
            if (v > 0 && prev > 0 || v < 0 && prev < 0) {
                int absDiff;
                int diff = v - prev;
                int n = absDiff = diff < 0 ? -diff : diff;
                this.writeVnumber(kind, absV <= absDiff ? ((long)absV << 2) + (v < 0 ? 2L : 0L) : ((long)absDiff << 2) + (diff < 0 ? 3L : 1L));
                if (this.doMeasurement) {
                    ++this.sm.statDetails[kind].diffEncoded;
                    this.sm.statDetails[kind].valueLeDiff = this.sm.statDetails[kind].valueLeDiff + (absV <= absDiff ? 1L : 0L);
                }
                return;
            }
            this.writeVnumber(kind, ((long)absV << 2) + (long)(v < 0 ? 2 : 0));
            if (this.doMeasurement) {
                ++this.sm.statDetails[kind].diffEncoded;
                ++this.sm.statDetails[kind].valueLeDiff;
            }
        }

        private void writeFromByteArray(SlotKind kind, int startPos, int length) throws IOException {
            this.byte_dos.write(this.byteHeapObj.heap, startPos, length);
        }

        private void writeFromLongArray(SlotKind kind, int startPos, int length) throws IOException {
            long[] h = this.longHeapObj.heap;
            int endPos = startPos + length;
            long prev = 0L;
            for (int i = startPos; i < endPos; ++i) {
                long e = h[i];
                if (kind == SlotKind.Slot_DoubleRef) {
                    this.writeDouble(e);
                    continue;
                }
                this.writeLong(e, prev);
                prev = e;
            }
        }

        private void writeFromShortArray(int startPos, int length) throws IOException {
            short[] h = this.shortHeapObj.heap;
            int endPos = startPos + length;
            int prev = 0;
            for (int i = startPos; i < endPos; ++i) {
                int e = h[i];
                this.writeDiff(short_i, e, prev);
                prev = e;
            }
        }

        public class SerializeModifiedFSs {
            final int[] modifiedMainHeapAddrs;
            final int[] modifiedFSs;
            final int[] modifiedByteHeapAddrs;
            final int[] modifiedShortHeapAddrs;
            final int[] modifiedLongHeapAddrs;
            final int modMainHeapAddrsLength;
            final int modFSsLength;
            final int modByteHeapAddrsLength;
            final int modShortHeapAddrsLength;
            final int modLongHeapAddrsLength;
            int imaModMainHeap;
            int imaModByteRef;
            int imaModShortRef;
            int imaModLongRef;
            int vPrevModInt;
            int vPrevModHeapRef;
            short vPrevModShort;
            long vPrevModLong;
            int iHeap;
            TypeInfo typeInfo;

            public SerializeModifiedFSs() {
                this.modifiedMainHeapAddrs = Serializer.this.cas.getModifiedFSHeapAddrs().toArray();
                this.modifiedFSs = Serializer.this.cas.getModifiedFSList().toArray();
                this.modifiedByteHeapAddrs = Serializer.this.cas.getModifiedByteHeapAddrs().toArray();
                this.modifiedShortHeapAddrs = Serializer.this.cas.getModifiedShortHeapAddrs().toArray();
                this.modifiedLongHeapAddrs = Serializer.this.cas.getModifiedLongHeapAddrs().toArray();
                this.sortModifications();
                this.modMainHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedMainHeapAddrs);
                this.modFSsLength = this.eliminateDuplicatesInMods(this.modifiedFSs);
                this.modByteHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedByteHeapAddrs);
                this.modShortHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedShortHeapAddrs);
                this.modLongHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedLongHeapAddrs);
                this.imaModMainHeap = 0;
                this.imaModByteRef = 0;
                this.imaModShortRef = 0;
                this.imaModLongRef = 0;
                this.vPrevModInt = 0;
                this.vPrevModHeapRef = 0;
                this.vPrevModShort = 0;
                this.vPrevModLong = 0L;
            }

            private void serializeModifiedFSs() throws IOException {
                Serializer.this.iPrevHeap = 0;
                Serializer.this.writeVnumber(Serializer.this.control_dos, this.modFSsLength);
                for (int i = 0; i < this.modFSsLength; ++i) {
                    this.iHeap = this.modifiedFSs[i];
                    int tCode = Serializer.this.heap[this.iHeap];
                    this.typeInfo = BinaryCasSerDes4.this.getTypeInfo(tCode);
                    Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, this.iHeap - Serializer.this.iPrevHeap);
                    if (this.typeInfo.isArray && !this.typeInfo.isHeapStoredArray) {
                        this.writeAuxHeapMods();
                    } else {
                        this.writeMainHeapMods();
                    }
                    Serializer.this.iPrevHeap = this.iHeap;
                }
            }

            private void sortModifications() {
                Arrays.sort(this.modifiedMainHeapAddrs);
                Arrays.sort(this.modifiedFSs);
                Arrays.sort(this.modifiedByteHeapAddrs);
                Arrays.sort(this.modifiedShortHeapAddrs);
                Arrays.sort(this.modifiedLongHeapAddrs);
            }

            private int eliminateDuplicatesInMods(int[] sorted) {
                int length = sorted.length;
                if (length < 2) {
                    return length;
                }
                int prev = sorted[0];
                int to = 1;
                for (int from = 1; from < length; ++from) {
                    int s = sorted[from];
                    if (s == prev) continue;
                    prev = s;
                    sorted[to] = s;
                    ++to;
                }
                return to;
            }

            private int countModifiedSlotsInFs(int fsLength) {
                return this.countModifiedSlots(this.iHeap, fsLength, this.modifiedMainHeapAddrs, this.imaModMainHeap, this.modMainHeapAddrsLength);
            }

            private int countModifiedSlotsInAuxHeap(int[] modifiedAddrs, int indexInModAddrs, int length) {
                return this.countModifiedSlots(Serializer.this.heap[this.iHeap + 2], Serializer.this.heap[this.iHeap + 1], modifiedAddrs, indexInModAddrs, length);
            }

            private int countModifiedSlots(int firstAddr, int length, int[] modifiedAddrs, int indexInModAddrs, int modAddrsLength) {
                if (0 == length) {
                    throw new RuntimeException();
                }
                int nextAddr = firstAddr + length;
                int nextModAddr = modifiedAddrs[indexInModAddrs];
                if (firstAddr > nextModAddr || nextModAddr >= nextAddr) {
                    throw new RuntimeException();
                }
                int i = 1;
                while (indexInModAddrs + i != modAddrsLength && (nextModAddr = modifiedAddrs[indexInModAddrs + i]) < nextAddr) {
                    ++i;
                }
                return i;
            }

            private void writeMainHeapMods() throws IOException {
                int fsLength = BinaryCasSerDes4.this.incrToNextFs(Serializer.this.heap, this.iHeap, this.typeInfo);
                int numberOfModsInFs = this.countModifiedSlotsInFs(fsLength);
                Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, numberOfModsInFs);
                int iPrevOffsetInFs = 0;
                block10: for (int i = 0; i < numberOfModsInFs; ++i) {
                    int nextMainHeapIndex = this.modifiedMainHeapAddrs[this.imaModMainHeap++];
                    int offsetInFs = nextMainHeapIndex - this.iHeap;
                    Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, offsetInFs - iPrevOffsetInFs);
                    iPrevOffsetInFs = offsetInFs;
                    SlotKind kind = this.typeInfo.getSlotKind(this.typeInfo.isArray ? 2 : offsetInFs);
                    switch (kind) {
                        case Slot_HeapRef: {
                            this.vPrevModHeapRef = Serializer.this.writeIntOrHeapRef(heapRef_i, nextMainHeapIndex, this.vPrevModHeapRef);
                            continue block10;
                        }
                        case Slot_Int: {
                            this.vPrevModInt = Serializer.this.writeIntOrHeapRef(int_i, nextMainHeapIndex, this.vPrevModInt);
                            continue block10;
                        }
                        case Slot_Short: {
                            this.vPrevModShort = (short)Serializer.this.writeIntOrHeapRef(int_i, nextMainHeapIndex, this.vPrevModShort);
                            continue block10;
                        }
                        case Slot_LongRef: {
                            this.vPrevModLong = Serializer.this.writeLongFromHeapIndex(nextMainHeapIndex, this.vPrevModLong);
                            continue block10;
                        }
                        case Slot_Boolean: 
                        case Slot_Byte: {
                            Serializer.this.byte_dos.write(Serializer.this.heap[nextMainHeapIndex]);
                            continue block10;
                        }
                        case Slot_Float: {
                            Serializer.this.writeFloat(Serializer.this.heap[nextMainHeapIndex]);
                            continue block10;
                        }
                        case Slot_StrRef: {
                            Serializer.this.writeString(Serializer.this.stringHeapObj.getStringForCode(Serializer.this.heap[nextMainHeapIndex]));
                            continue block10;
                        }
                        case Slot_DoubleRef: {
                            Serializer.this.writeDouble(Serializer.this.longHeapObj.getHeapValue(Serializer.this.heap[nextMainHeapIndex]));
                            continue block10;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
            }

            private void writeAuxHeapMods() throws IOException {
                int modXxxHeapAddrsLength;
                int[] modXxxHeapAddrs;
                boolean isAuxLong;
                int auxHeapIndex = Serializer.this.heap[this.iHeap + 2];
                int iPrevOffsetInAuxArray = 0;
                SlotKind kind = this.typeInfo.getSlotKind(2);
                boolean isAuxByte = kind == SlotKind.Slot_BooleanRef || kind == SlotKind.Slot_ByteRef;
                boolean isAuxShort = kind == SlotKind.Slot_ShortRef;
                boolean bl = isAuxLong = kind == SlotKind.Slot_LongRef || kind == SlotKind.Slot_DoubleRef;
                if (!(isAuxByte | isAuxShort | isAuxLong)) {
                    throw new RuntimeException();
                }
                int[] nArray = isAuxByte ? this.modifiedByteHeapAddrs : (modXxxHeapAddrs = isAuxShort ? this.modifiedShortHeapAddrs : this.modifiedLongHeapAddrs);
                int n = isAuxByte ? this.modByteHeapAddrsLength : (modXxxHeapAddrsLength = isAuxShort ? this.modShortHeapAddrsLength : this.modLongHeapAddrsLength);
                int imaModXxxRef = isAuxByte ? this.imaModByteRef : (isAuxShort ? this.imaModShortRef : this.imaModLongRef);
                int numberOfModsInAuxHeap = this.countModifiedSlotsInAuxHeap(modXxxHeapAddrs, imaModXxxRef, modXxxHeapAddrsLength);
                Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, numberOfModsInAuxHeap);
                for (int i = 0; i < numberOfModsInAuxHeap; ++i) {
                    int nextModAuxIndex = modXxxHeapAddrs[imaModXxxRef++];
                    int offsetInAuxArray = nextModAuxIndex - auxHeapIndex;
                    Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, offsetInAuxArray - iPrevOffsetInAuxArray);
                    iPrevOffsetInAuxArray = offsetInAuxArray;
                    if (isAuxByte) {
                        Serializer.this.writeUnsignedByte(Serializer.this.byte_dos, Serializer.this.byteHeapObj.getHeapValue(nextModAuxIndex));
                    } else if (isAuxShort) {
                        short v = Serializer.this.shortHeapObj.getHeapValue(nextModAuxIndex);
                        Serializer.this.writeDiff(int_i, v, this.vPrevModShort);
                        this.vPrevModShort = v;
                    } else {
                        long v = Serializer.this.longHeapObj.getHeapValue(nextModAuxIndex);
                        if (kind == SlotKind.Slot_LongRef) {
                            Serializer.this.writeLong(v, this.vPrevModLong);
                            this.vPrevModLong = v;
                        } else {
                            Serializer.this.writeDouble(v);
                        }
                    }
                    if (isAuxByte) {
                        ++this.imaModByteRef;
                        continue;
                    }
                    if (isAuxShort) {
                        ++this.imaModShortRef;
                        continue;
                    }
                    ++this.imaModLongRef;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlotKind {
        Slot_ArrayLength(false, false, 4, true),
        Slot_HeapRef(true, true, 4, true),
        Slot_Int(true, true, 4, true),
        Slot_Byte(false, false, 4, true),
        Slot_Short(true, true, 4, true),
        Slot_TypeCode(false, false, 4, true),
        Slot_StrOffset(false, false, 4, false),
        Slot_StrLength(false, false, 4, false),
        Slot_Long_High(true, true, 0, false),
        Slot_Long_Low(true, true, 0, false),
        Slot_Float_Mantissa_Sign(false, true, 0, false),
        Slot_Float_Exponent(false, true, 0, false),
        Slot_Double_Mantissa_Sign(false, true, 0, false),
        Slot_Double_Exponent(false, true, 0, false),
        Slot_FsIndexes(true, true, 4, false),
        Slot_StrChars(true, true, 2, false),
        Slot_Control(true, true, 0, false),
        Slot_StrSeg(false, false, 0, false),
        Slot_StrRef(true, true, 4, true),
        Slot_BooleanRef(false, false, 4, true),
        Slot_ByteRef(true, true, 4, true),
        Slot_ShortRef(true, true, 4, true),
        Slot_LongRef(true, true, 4, true),
        Slot_DoubleRef(true, true, 4, true),
        Slot_Float(false, false, 4, true),
        Slot_Boolean(false, false, 4, true),
        Slot_MainHeap(true, true, 4, false);

        public final int i = this.ordinal();
        public final boolean isDiffEncode;
        public final boolean canBeNegative;
        public final boolean inMainHeap;
        public final int elementSize;
        public static final int NBR_SLOT_KIND_ZIP_STREAMS;

        private SlotKind(boolean isDiffEncode, boolean canBeNegative, int elementSize, boolean inMainHeap) {
            this.isDiffEncode = isDiffEncode;
            this.canBeNegative = isDiffEncode ? true : canBeNegative;
            this.elementSize = elementSize;
            this.inMainHeap = inMainHeap;
        }

        static {
            NBR_SLOT_KIND_ZIP_STREAMS = SlotKind.Slot_StrRef.i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressStrat {
        Default(0),
        Filtered(1),
        HuffmanOnly(2);

        public final int strat;

        private CompressStrat(int strat) {
            this.strat = strat;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressLevel {
        None(0),
        Fast(1),
        Default(-1),
        Best(9);

        public final int lvl;

        private CompressLevel(int lvl) {
            this.lvl = lvl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compression {
        None,
        Compress;

    }
}

