/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.resource.ResourceInitializationException;

public class CasTypeSystemMapper {
    private static final int[] INT0 = new int[0];
    private static final boolean[] BOOLEAN0 = new boolean[0];
    public final TypeSystemImpl tsSrc;
    public final TypeSystemImpl tsTgt;
    private final int[] tSrc2Tgt;
    private final boolean[][] fSrcInTgt;
    private final int[][] fTgt2Src;
    private final int[] tTgt2Src;
    private final boolean typeSystemsSame;

    public boolean isEqual() {
        return this.typeSystemsSame;
    }

    public CasTypeSystemMapper(TypeSystemImpl tsSrc, TypeSystemImpl tsTgt) throws ResourceInitializationException {
        if (!tsSrc.isCommitted() || !tsTgt.isCommitted()) {
            throw new RuntimeException("Type Systems must be committed before calling this method");
        }
        this.tsSrc = tsSrc;
        this.tsTgt = tsTgt;
        int[] temptSrc2Tgt = null;
        int[] temptTgt2Src = null;
        Object localFSrcInTgt = null;
        Object localFTgt2Src = null;
        if (tsSrc == tsTgt) {
            this.typeSystemsSame = true;
        } else {
            temptSrc2Tgt = CasTypeSystemMapper.addTypes(tsSrc, tsTgt);
            temptTgt2Src = CasTypeSystemMapper.addTypes(tsTgt, tsSrc);
            localFSrcInTgt = new boolean[tsSrc.getTypeArraySize()][];
            localFTgt2Src = new int[tsSrc.getTypeArraySize()][];
            this.typeSystemsSame = this.addFeatures(tsSrc, tsTgt, (boolean[][])localFSrcInTgt, (int[][])localFTgt2Src, temptSrc2Tgt);
        }
        this.tSrc2Tgt = temptSrc2Tgt;
        this.tTgt2Src = temptTgt2Src;
        this.fSrcInTgt = localFSrcInTgt;
        this.fTgt2Src = localFTgt2Src;
    }

    public int mapTypeCodeSrc2Tgt(int c) {
        return this.tSrc2Tgt[c];
    }

    public int mapTypeCodeTgt2Src(int c) {
        return this.tTgt2Src[c];
    }

    public int mapTypeCode2Other(int c, boolean src2tgt) {
        if (src2tgt) {
            return this.mapTypeCodeSrc2Tgt(c);
        }
        return this.mapTypeCodeTgt2Src(c);
    }

    public int[] getTgtFeatOffsets2Src(int tCode) {
        return this.fTgt2Src[tCode];
    }

    public boolean[] getFSrcInTgt(int tCode) {
        return this.fSrcInTgt[tCode];
    }

    private static int[] addTypes(TypeSystemImpl tsSrc, TypeSystemImpl tsTgt) {
        LinkedHashMap<TypeImpl, TypeImpl> mSrc2Tgt = new LinkedHashMap<TypeImpl, TypeImpl>();
        Iterator<Type> it = tsSrc.getTypeIterator();
        while (it.hasNext()) {
            TypeImpl tSrc = (TypeImpl)it.next();
            TypeImpl tTgt = (TypeImpl)tsTgt.getType(tSrc.getName());
            if (tTgt == null) continue;
            mSrc2Tgt.put(tSrc, tTgt);
        }
        int[] r = new int[tsSrc.getNumberOfTypes() + 1];
        for (Map.Entry e : mSrc2Tgt.entrySet()) {
            r[((TypeImpl)e.getKey()).getCode()] = ((TypeImpl)e.getValue()).getCode();
        }
        return r;
    }

    private boolean addFeatures(TypeSystemImpl tsSrc, TypeSystemImpl tsTgt, boolean[][] localFSrcInTgt, int[][] localFTgt2Src, int[] temptSrc2Tgt) throws ResourceInitializationException {
        boolean isEqual = tsSrc.getTypeArraySize() == tsTgt.getTypeArraySize();
        for (int tCodeSrc = 0; tCodeSrc < tsSrc.getTypeArraySize(); ++tCodeSrc) {
            int[] fcTgt;
            int tCodeTgt = temptSrc2Tgt[tCodeSrc];
            if (tCodeTgt != tCodeSrc) {
                isEqual = false;
            }
            if (tCodeTgt == 0) {
                localFSrcInTgt[tCodeSrc] = BOOLEAN0;
                localFTgt2Src[tCodeSrc] = null;
                continue;
            }
            int[] fcSrc = tsSrc.ll_getAppropriateFeatures(tCodeSrc);
            if (fcSrc.length != (fcTgt = tsTgt.ll_getAppropriateFeatures(tCodeTgt)).length) {
                isEqual = false;
            }
            if (fcSrc.length == 0) {
                localFSrcInTgt[tCodeSrc] = BOOLEAN0;
                localFTgt2Src[tCodeSrc] = new int[fcTgt.length];
                Arrays.fill(localFTgt2Src[tCodeSrc], -1);
                continue;
            }
            boolean[] srcInTgt = new boolean[fcSrc.length];
            localFSrcInTgt[tCodeSrc] = srcInTgt;
            if (fcTgt.length == 0) {
                Arrays.fill(srcInTgt, false);
                localFTgt2Src[tCodeSrc] = INT0;
                continue;
            }
            int[] tgt2srcOffsets = new int[fcTgt.length];
            localFTgt2Src[tCodeSrc] = tgt2srcOffsets;
            ArrayList<String> namesTgt = new ArrayList<String>(fcTgt.length);
            for (int i = 0; i < fcTgt.length; ++i) {
                namesTgt.add(tsTgt.ll_getFeatureForCode(fcTgt[i]).getName());
            }
            ArrayList<String> namesSrc = new ArrayList<String>(fcSrc.length);
            for (int i = 0; i < fcSrc.length; ++i) {
                namesSrc.add(tsSrc.ll_getFeatureForCode(fcSrc[i]).getName());
            }
            for (int fciSrc = 0; fciSrc < fcSrc.length; ++fciSrc) {
                String nameSrc = (String)namesSrc.get(fciSrc);
                int iTgt = namesTgt.indexOf(nameSrc);
                if (iTgt == -1) {
                    isEqual = false;
                    srcInTgt[fciSrc] = false;
                    continue;
                }
                if (!tsSrc.ll_getFeatureForCode(fcSrc[fciSrc]).getRange().getName().equals(tsTgt.ll_getFeatureForCode(fcTgt[iTgt]).getRange().getName())) {
                    throw new ResourceInitializationException("incompatible_range_types", new Object[]{tsSrc.ll_getTypeForCode(tCodeSrc).getName() + ":" + nameSrc, tsSrc.ll_getFeatureForCode(fcSrc[fciSrc]).getRange().getName(), tsTgt.ll_getFeatureForCode(fcTgt[iTgt]).getRange().getName(), ""});
                }
                srcInTgt[fciSrc] = true;
            }
            for (int fciTgt = 0; fciTgt < fcTgt.length; ++fciTgt) {
                int iSrc;
                String nameTgt = (String)namesTgt.get(fciTgt);
                tgt2srcOffsets[fciTgt] = iSrc = namesSrc.indexOf(nameTgt);
                if (fciTgt == iSrc) continue;
                isEqual = false;
            }
        }
        return isEqual;
    }
}

