/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

abstract class CommonAuxHeap {
    protected static final int DEFAULT_HEAP_BASE_SIZE = 16;
    protected static final int DEFAULT_HEAP_MULT_LIMIT = 524288;
    protected static final int MIN_HEAP_BASE_SIZE = 16;
    protected static final int GROWTH_FACTOR = 2;
    protected static final int NULL = 0;
    protected static final int FIRST_CELL_REF = 1;
    protected final int heapBaseSize;
    protected final int heapMultLimit;
    protected int heapPos = 1;

    CommonAuxHeap() {
        this(16, 524288);
    }

    CommonAuxHeap(int heapBaseSize, int heapMultLimit) {
        this.heapBaseSize = Math.max(heapBaseSize, 16);
        this.heapMultLimit = Math.max(heapMultLimit, 524288);
        this.initMemory();
    }

    abstract void initMemory();

    abstract void resetToZeros();

    abstract void growHeapIfNeeded();

    void reset() {
        this.reset(false);
    }

    void reset(boolean doFullReset) {
        if (doFullReset) {
            this.initMemory();
        } else {
            this.resetToZeros();
        }
        this.heapPos = 1;
    }

    int reserve(int numCells) {
        int cellRef = this.heapPos;
        this.heapPos += numCells;
        this.growHeapIfNeeded();
        return cellRef;
    }

    int computeNewArraySize(int size, int needed_size, int growth_factor, int multiplication_limit) {
        do {
            if (size < multiplication_limit) {
                size *= growth_factor;
                continue;
            }
            size += multiplication_limit;
        } while (size < needed_size);
        return size;
    }

    int getSize() {
        return this.heapPos;
    }
}

