/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class FSArray
extends TOP
implements ArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private FSArray() {
    }

    public FSArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public FSArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createArray(jcas.getType((int)FSArray.typeIndexID).casTypeCode, length), jcas.getType(typeIndexID));
        this.jcasType.casImpl.checkArrayPreconditions(length);
    }

    public FeatureStructure get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        LowLevelCAS ll_cas = this.jcasType.ll_cas;
        return ll_cas.ll_getFSForRef(ll_cas.ll_getRefArrayValue(this.addr, i));
    }

    public void set(int i, FeatureStructure v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setRefArrayValue(this.addr, i, this.jcasType.ll_cas.ll_getFSRef(v));
    }

    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    public void copyFromArray(FeatureStructure[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setRefArrayValue(this.addr, i + destOffset, this.jcasType.ll_cas.ll_getFSRef(src[i + srcOffset]));
        }
    }

    public void copyToArray(int srcOffset, FeatureStructure[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getFSForRef(this.jcasType.ll_cas.ll_getRefArrayValue(this.addr, i + srcOffset));
        }
    }

    public FeatureStructure[] toArray() {
        int size = this.size();
        FeatureStructure[] outArray = new FeatureStructure[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        CASImpl ll = this.jcasType.casImpl;
        ll.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = ll.ll_getFSForRef(ll.ll_getRefArrayValue(this.addr, i + srcOffset)).toString();
        }
    }

    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(FSArray.class);
    }
}

