/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.internal.util.UIMAClassLoader;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ParameterizedDataResource;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.impl.CasManager_impl;
import org.apache.uima.resource.impl.DataResource_impl;
import org.apache.uima.resource.impl.FileResourceSpecifier_impl;
import org.apache.uima.resource.impl.RelativePathResolver_impl;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager_impl
implements ResourceManager {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private final RelativePathResolver mRelativePathResolver;
    protected Map<String, Object> mResourceMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, ResourceRegistration> mInternalResourceRegistrationMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, Class<?>> mParameterizedResourceImplClassMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, Class<?>> mInternalParameterizedResourceImplClassMap = Collections.synchronizedMap(new HashMap());
    protected Map<List<Object>, Object> mParameterizedResourceInstanceMap = Collections.synchronizedMap(new HashMap());
    private UIMAClassLoader uimaCL = null;
    protected CasManager mCasManager = null;
    private Map<String, XMLizable> importCache = Collections.synchronizedMap(new HashMap());

    public ResourceManager_impl() {
        this.mRelativePathResolver = new RelativePathResolver_impl();
    }

    public synchronized void setExtensionClassPath(UIMAClassLoader uimaCL, boolean resolveResource) {
        this.uimaCL = uimaCL;
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(uimaCL);
        }
    }

    @Override
    public synchronized void setExtensionClassPath(String classpath, boolean resolveResource) throws MalformedURLException {
        this.uimaCL = new UIMAClassLoader(classpath, this.getClass().getClassLoader());
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(this.uimaCL);
        }
    }

    @Override
    public synchronized void setExtensionClassPath(ClassLoader parent, String classpath, boolean resolveResource) throws MalformedURLException {
        this.uimaCL = new UIMAClassLoader(classpath, parent);
        if (resolveResource) {
            this.getRelativePathResolver().setPathResolverClassLoader(this.uimaCL);
        }
    }

    @Override
    public synchronized ClassLoader getExtensionClassLoader() {
        return this.uimaCL;
    }

    public ResourceManager_impl(ClassLoader aClassLoader) {
        this.mRelativePathResolver = new RelativePathResolver_impl(aClassLoader);
    }

    @Override
    public String getDataPath() {
        return this.getRelativePathResolver().getDataPath();
    }

    @Override
    public void setDataPath(String aPath) throws MalformedURLException {
        this.getRelativePathResolver().setDataPath(aPath);
    }

    @Override
    public URL resolveRelativePath(String aRelativePath) throws MalformedURLException {
        URL relativeUrl;
        try {
            relativeUrl = new URL(aRelativePath);
        }
        catch (MalformedURLException e) {
            relativeUrl = new URL("file", "", aRelativePath);
        }
        return this.getRelativePathResolver().resolveRelativePath(relativeUrl);
    }

    @Override
    public Object getResource(String aName) throws ResourceAccessException {
        Object r = this.mResourceMap.get(aName);
        if (r instanceof ParameterizedDataResource) {
            throw new ResourceAccessException("parameters_required", new Object[]{aName});
        }
        return r;
    }

    @Override
    public Object getResource(String aName, String[] aParams) throws ResourceAccessException {
        DataResource dr;
        Object r = this.mResourceMap.get(aName);
        if (r == null) {
            return null;
        }
        if (!(r instanceof ParameterizedDataResource)) {
            throw new ResourceAccessException("parameters_not_allowed", new Object[]{aName});
        }
        ParameterizedDataResource pdr = (ParameterizedDataResource)r;
        try {
            dr = pdr.getDataResource(aParams);
        }
        catch (ResourceInitializationException e) {
            throw new ResourceAccessException(e);
        }
        ArrayList<Object> nameAndResource = new ArrayList<Object>();
        nameAndResource.add(aName);
        nameAndResource.add(dr);
        Object resourceInstance = this.mParameterizedResourceInstanceMap.get(nameAndResource);
        if (resourceInstance != null) {
            return resourceInstance;
        }
        Class<?> sharedResourceObjectClass = this.mParameterizedResourceImplClassMap.get(aName);
        if (sharedResourceObjectClass != null) {
            try {
                SharedResourceObject sro = (SharedResourceObject)sharedResourceObjectClass.newInstance();
                sro.load(dr);
                this.mParameterizedResourceInstanceMap.put(nameAndResource, sro);
                return sro;
            }
            catch (InstantiationException e) {
                throw new ResourceAccessException(e);
            }
            catch (IllegalAccessException e) {
                throw new ResourceAccessException(e);
            }
            catch (ResourceInitializationException e) {
                throw new ResourceAccessException(e);
            }
        }
        this.mParameterizedResourceInstanceMap.put(nameAndResource, dr);
        return dr;
    }

    @Override
    public Class<? extends Resource> getResourceClass(String aName) {
        Object r = this.mResourceMap.get(aName);
        if (r == null) {
            return null;
        }
        if (r instanceof ParameterizedDataResource) {
            Class<?> customResourceClass = this.mParameterizedResourceImplClassMap.get(aName);
            if (customResourceClass == null) {
                return DataResource_impl.class;
            }
            return customResourceClass;
        }
        return r.getClass();
    }

    @Override
    public InputStream getResourceAsStream(String aKey, String[] aParams) throws ResourceAccessException {
        try {
            Object r = this.getResource(aKey, aParams);
            if (r != null && r instanceof DataResource) {
                return ((DataResource)r).getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            throw new ResourceAccessException(e);
        }
    }

    @Override
    public InputStream getResourceAsStream(String aKey) throws ResourceAccessException {
        try {
            Object r = this.getResource(aKey);
            if (r != null && r instanceof DataResource) {
                return ((DataResource)r).getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            throw new ResourceAccessException(e);
        }
    }

    @Override
    public URL getResourceURL(String aKey, String[] aParams) throws ResourceAccessException {
        Object r = this.getResource(aKey, aParams);
        if (r != null && r instanceof DataResource) {
            return ((DataResource)r).getUrl();
        }
        return null;
    }

    @Override
    public URL getResourceURL(String aKey) throws ResourceAccessException {
        Object r = this.getResource(aKey);
        if (r != null && r instanceof DataResource) {
            return ((DataResource)r).getUrl();
        }
        return null;
    }

    @Override
    public void initializeExternalResources(ResourceManagerConfiguration aConfiguration, String aQualifiedContextName, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        ResourceRegistration registration;
        ExternalResourceDescription[] resources = aConfiguration.getExternalResources();
        for (int i = 0; i < resources.length; ++i) {
            String name = resources[i].getName();
            registration = this.mInternalResourceRegistrationMap.get(name);
            if (registration == null) {
                this.registerResource(name, resources[i], aQualifiedContextName, aAdditionalParams);
                continue;
            }
            if (registration.description.equals(resources[i])) continue;
            if (aQualifiedContextName.startsWith(registration.definingContext)) {
                UIMAFramework.getLogger().logrb(Level.CONFIG, ResourceManager_impl.class.getName(), "initializeExternalResources", LOG_RESOURCE_BUNDLE, "UIMA_overridden_resource__CONFIG", new Object[]{name, aQualifiedContextName, registration.definingContext});
                continue;
            }
            UIMAFramework.getLogger().logrb(Level.WARNING, ResourceManager_impl.class.getName(), "initializeExternalResources", LOG_RESOURCE_BUNDLE, "UIMA_duplicate_resource_name__WARNING", new Object[]{name, registration.definingContext, aQualifiedContextName});
        }
        ExternalResourceBinding[] bindings = aConfiguration.getExternalResourceBindings();
        for (int i = 0; i < bindings.length; ++i) {
            registration = this.mInternalResourceRegistrationMap.get(bindings[i].getResourceName());
            if (registration == null) {
                throw new ResourceInitializationException("unknown_resource_name", new Object[]{bindings[i].getResourceName(), bindings[i].getSourceUrlString()});
            }
            this.mResourceMap.put(aQualifiedContextName + bindings[i].getKey(), registration.resource);
            this.mParameterizedResourceImplClassMap.put(aQualifiedContextName + bindings[i].getKey(), this.mInternalParameterizedResourceImplClassMap.get(bindings[i].getResourceName()));
        }
    }

    @Override
    public void resolveAndValidateResourceDependencies(ExternalResourceDependency[] aDependencies, String aQualifiedContextName) throws ResourceInitializationException {
        for (int i = 0; i < aDependencies.length; ++i) {
            String qname = aQualifiedContextName + aDependencies[i].getKey();
            Object resource = this.mResourceMap.get(qname);
            if (resource == null) {
                URL relativeUrl;
                try {
                    relativeUrl = new URL("file", "", aDependencies[i].getKey());
                }
                catch (MalformedURLException e) {
                    throw new ResourceInitializationException(e);
                }
                URL absUrl = this.getRelativePathResolver().resolveRelativePath(relativeUrl);
                if (absUrl != null) {
                    FileResourceSpecifier_impl spec = new FileResourceSpecifier_impl();
                    spec.setFileUrl(absUrl.toString());
                    resource = UIMAFramework.produceResource(spec, null);
                    this.mResourceMap.put(qname, resource);
                }
            }
            if (resource == null) {
                if (aDependencies[i].isOptional()) continue;
                throw new ResourceInitializationException("resource_dependency_not_satisfied", new Object[]{aDependencies[i].getKey(), aDependencies[i].getSourceUrlString()});
            }
            try {
                Class<? extends Resource> resourceClass;
                if (aDependencies[i].getInterfaceName() == null || aDependencies[i].getInterfaceName().length() <= 0) continue;
                ClassLoader cl = this.getExtensionClassLoader();
                Class<Resource> theInterface = null;
                theInterface = cl != null ? cl.loadClass(aDependencies[i].getInterfaceName()) : Class.forName(aDependencies[i].getInterfaceName());
                if (theInterface.isAssignableFrom(resourceClass = this.getResourceClass(qname))) continue;
                throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{qname, aDependencies[i].getInterfaceName(), aDependencies[i].getSourceUrlString()});
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException("class_not_found", new Object[]{aDependencies[i].getInterfaceName(), aDependencies[i].getSourceUrlString()});
            }
        }
    }

    private void registerResource(String aName, ExternalResourceDescription aResourceDescription, String aDefiningContext, Map<String, Object> aResourceInitParams) throws ResourceInitializationException {
        HashMap<String, Object> initParams = aResourceInitParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aResourceInitParams);
        initParams.put("RELATIVE_PATH_RESOLVER", this.getRelativePathResolver());
        boolean verificationMode = initParams.containsKey("VERIFICATION_MODE");
        Object r = UIMAFramework.produceResource(aResourceDescription.getResourceSpecifier(), initParams);
        String implementationName = aResourceDescription.getImplementationName();
        Class<?> implClass = null;
        if (implementationName != null && implementationName.length() > 0) {
            try {
                ClassLoader cl = this.getExtensionClassLoader();
                implClass = cl != null ? cl.loadClass(implementationName) : Class.forName(implementationName);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException("class_not_found", new Object[]{implementationName, aResourceDescription.getSourceUrlString()}, e);
            }
            if (!SharedResourceObject.class.isAssignableFrom(implClass)) {
                throw new ResourceInitializationException("not_a_shared_resource_object", new Object[]{implementationName, aResourceDescription.getSourceUrlString()});
            }
        }
        if (r instanceof DataResource) {
            if (implClass != null) {
                try {
                    SharedResourceObject sro = (SharedResourceObject)implClass.newInstance();
                    if (!verificationMode) {
                        sro.load((DataResource)r);
                    }
                    r = sro;
                }
                catch (InstantiationException e) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{implClass.getName(), aResourceDescription.getSourceUrlString()}, e);
                }
                catch (IllegalAccessException e) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{implClass.getName(), aResourceDescription.getSourceUrlString()}, e);
                }
            }
        } else if (r instanceof ParameterizedDataResource) {
            this.mInternalParameterizedResourceImplClassMap.put(aName, implClass);
        } else if (implClass != null) {
            throw new ResourceInitializationException("not_a_data_resource", new Object[]{implClass.getName(), aName, r.getClass().getName(), aResourceDescription.getSourceUrlString()});
        }
        ResourceRegistration registration = new ResourceRegistration(r, aResourceDescription, aDefiningContext);
        this.mInternalResourceRegistrationMap.put(aName, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CasManager getCasManager() {
        ResourceManager_impl resourceManager_impl = this;
        synchronized (resourceManager_impl) {
            if (this.mCasManager == null) {
                this.mCasManager = new CasManager_impl(this);
            }
            return this.mCasManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCasManager(CasManager aCasManager) {
        ResourceManager_impl resourceManager_impl = this;
        synchronized (resourceManager_impl) {
            if (this.mCasManager != null) {
                throw new UIMA_IllegalStateException("cannot_set_cas_manager", new Object[0]);
            }
            this.mCasManager = aCasManager;
        }
    }

    protected RelativePathResolver getRelativePathResolver() {
        return this.mRelativePathResolver;
    }

    @Override
    public Map<String, XMLizable> getImportCache() {
        return this.importCache;
    }

    protected static class ResourceRegistration {
        Object resource;
        ExternalResourceDescription description;
        String definingContext;

        public ResourceRegistration(Object resource, ExternalResourceDescription description, String definingContext) {
            this.resource = resource;
            this.description = description;
            this.definingContext = definingContext;
        }
    }
}

