/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterDeclarations_impl;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterSettings_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMetaData_impl
extends MetaDataObject_impl
implements ResourceMetaData {
    static final long serialVersionUID = 3408359518094534817L;
    private String mUUID;
    private String mName;
    private String mDescription;
    private String mVersion;
    private String mVendor;
    private String mCopyright;
    private ConfigurationParameterDeclarations mConfigurationParameterDeclarations = new ConfigurationParameterDeclarations_impl();
    private ConfigurationParameterSettings mConfigurationParameterSettings = new ConfigurationParameterSettings_impl();
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("resourceMetaData", new PropertyXmlInfo[]{new PropertyXmlInfo("name", false), new PropertyXmlInfo("description"), new PropertyXmlInfo("version"), new PropertyXmlInfo("vendor"), new PropertyXmlInfo("copyright"), new PropertyXmlInfo("configurationParameterDeclarations", null), new PropertyXmlInfo("configurationParameterSettings", null)});

    @Override
    public void resolveImports() throws InvalidXMLException {
    }

    @Override
    public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
    }

    @Override
    public String getUUID() {
        return this.mUUID;
    }

    @Override
    public void setUUID(String aUUID) {
        this.mUUID = aUUID;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    @Override
    public String getCopyright() {
        return this.mCopyright;
    }

    @Override
    public void setCopyright(String aCopyright) {
        this.mCopyright = aCopyright;
    }

    @Override
    public ConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.mConfigurationParameterSettings;
    }

    @Override
    public void setConfigurationParameterSettings(ConfigurationParameterSettings aSettings) {
        this.mConfigurationParameterSettings = aSettings;
    }

    @Override
    public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
        return this.mConfigurationParameterDeclarations;
    }

    @Override
    public void setConfigurationParameterDeclarations(ConfigurationParameterDeclarations aDeclarations) {
        this.mConfigurationParameterDeclarations = aDeclarations;
    }

    @Override
    public void validateConfigurationParameterSettings() throws ResourceConfigurationException {
        ConfigurationParameterDeclarations cfgParamDecls = this.getConfigurationParameterDeclarations();
        ConfigurationParameterSettings cfgParamSettings = this.getConfigurationParameterSettings();
        boolean support240bug = false;
        NameValuePair[] nvps = cfgParamSettings.getParameterSettings();
        if (nvps.length > 0) {
            this.validateConfigurationParameterSettings(nvps, null, cfgParamDecls);
            support240bug = true;
        }
        try {
            Map<String, NameValuePair[]> settingsForGroups = cfgParamSettings.getSettingsForGroups();
            Set<Map.Entry<String, NameValuePair[]>> entrySet = settingsForGroups.entrySet();
            for (Map.Entry<String, NameValuePair[]> entry : entrySet) {
                String groupName = entry.getKey();
                NameValuePair[] gnvps = entry.getValue();
                if (gnvps == null) continue;
                this.validateConfigurationParameterSettings(gnvps, groupName, cfgParamDecls);
            }
        }
        catch (ResourceConfigurationException e) {
            if (!support240bug) {
                if (nvps.length > 0) {
                    UIMAFramework.getLogger().log(Level.SEVERE, "To restore back-level support for this error set environment variable UIMA_Jira3123");
                }
                throw e;
            }
            UIMAFramework.getLogger().log(Level.WARNING, "Ignoring error in parameter setting: " + e.getMessage());
        }
    }

    protected void validateConfigurationParameterSettings(NameValuePair[] aNVPs, String aGroupName, ConfigurationParameterDeclarations aParamDecls) throws ResourceConfigurationException {
        for (int i = 0; i < aNVPs.length; ++i) {
            String name = aNVPs[i].getName();
            if (name == null) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"name", "nameValuePair"});
            }
            ConfigurationParameter param = aParamDecls.getConfigurationParameter(aGroupName, name);
            if (param == null) {
                if (aGroupName == null) {
                    throw new ResourceConfigurationException("nonexistent_parameter", new Object[]{name, this.getName()});
                }
                throw new ResourceConfigurationException("nonexistent_parameter_in_group", new Object[]{name, aGroupName, this.getName()});
            }
            this.validateConfigurationParameterDataTypeMatch(param, aNVPs[i]);
        }
    }

    protected void validateConfigurationParameterDataTypeMatch(ConfigurationParameter aParam, NameValuePair aNVP) throws ResourceConfigurationException {
        String paramName = aParam.getName();
        String paramType = aParam.getType();
        if (aNVP.getValue() == null) {
            throw new ResourceConfigurationException("config_setting_absent", new Object[]{paramName});
        }
        Class<?> valClass = aNVP.getValue().getClass();
        if (aParam.isMultiValued()) {
            if (!valClass.isArray()) {
                throw new ResourceConfigurationException("array_required", new Object[]{paramName, this.getName()});
            }
            valClass = valClass.getComponentType();
            if (Array.getLength(aNVP.getValue()) == 0 && valClass.equals(Object.class)) {
                aNVP.setValue(Array.newInstance(this.getClassForParameterType(paramType), 0));
                return;
            }
        }
        if (valClass != this.getClassForParameterType(paramType)) {
            throw new ResourceConfigurationException("parameter_type_mismatch", new Object[]{this.getName(), valClass.getName(), paramName, paramType});
        }
    }

    protected Class<?> getClassForParameterType(String paramType) {
        if ("String".equals(paramType)) {
            return String.class;
        }
        if ("Boolean".equals(paramType)) {
            return Boolean.class;
        }
        if ("Integer".equals(paramType)) {
            return Integer.class;
        }
        if ("Float".equals(paramType)) {
            return Float.class;
        }
        return null;
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        super.buildFromXMLElement(aElement, aParser, aOptions);
        try {
            this.validateConfigurationParameterSettings();
        }
        catch (ResourceConfigurationException e) {
            throw new InvalidXMLException(e);
        }
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    protected static XmlizationInfo getXmlizationInfoForClass() {
        return XMLIZATION_INFO;
    }
}

