/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.AnnotationBaseFS;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.text.AnnotationFS;

public class CasCopier {
    private final CAS mOriginalSrcCasView;
    private final CAS mOriginalTgtCasView;
    private String mSrcCasViewName;
    private String mTgtCasViewName;
    private LowLevelCAS mLowLevelDestCas;
    private final Feature mDestSofaFeature;
    private final boolean lenient;
    private final Map<FeatureStructure, FeatureStructure> mFsMap = new HashMap<FeatureStructure, FeatureStructure>();
    private ArrayList<FeatureStructure> fsToDo = new ArrayList();

    public CasCopier(CAS aSrcCas, CAS aDestCas) {
        this(aSrcCas, aDestCas, false);
    }

    public CasCopier(CAS aSrcCas, CAS aDestCas, boolean lenient) {
        this.mOriginalSrcCasView = aSrcCas;
        this.mOriginalTgtCasView = aDestCas;
        this.mDestSofaFeature = aDestCas.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa");
        this.lenient = lenient;
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa) {
        CasCopier.copyCas(aSrcCas, aDestCas, aCopySofa, false);
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa, boolean lenient) {
        CasCopier copier = new CasCopier(aSrcCas, aDestCas, lenient);
        Iterator<CAS> viewIterator = aSrcCas.getViewIterator();
        while (viewIterator.hasNext()) {
            CAS view = viewIterator.next();
            copier.copyCasView(view, aCopySofa);
        }
    }

    public void copyCasView(CAS aSrcCasView, boolean aCopySofa) {
        this.copyCasView(aSrcCasView, CasCopier.getOrCreateView(this.mOriginalTgtCasView, aSrcCasView.getViewName()), aCopySofa);
    }

    public void copyCasView(String aSrcCasViewName, boolean aCopySofa) {
        this.copyCasView(CasCopier.getOrCreateView(this.mOriginalSrcCasView, aSrcCasViewName), aCopySofa);
    }

    public void copyCasView(CAS aSrcCasView, String aTgtCasViewName, boolean aCopySofa) {
        this.copyCasView(aSrcCasView, CasCopier.getOrCreateView(this.mOriginalTgtCasView, aTgtCasViewName), aCopySofa);
    }

    public void copyCasView(String aSrcCasViewName, CAS aTgtCasView, boolean aCopySofa) {
        this.copyCasView(CasCopier.getOrCreateView(this.mOriginalSrcCasView, aSrcCasViewName), aTgtCasView, aCopySofa);
    }

    public void copyCasView(CAS aSrcCasView, CAS aTgtCasView, boolean aCopySofa) {
        SofaFS sofa;
        if (!this.casViewsInSameCas(aSrcCasView, this.mOriginalSrcCasView)) {
            throw new UIMARuntimeException("view_not_part_of_cas", new Object[]{"Source"});
        }
        if (!this.casViewsInSameCas(aTgtCasView, this.mOriginalTgtCasView)) {
            throw new UIMARuntimeException("view_not_part_of_cas", new Object[]{"Destination"});
        }
        this.mSrcCasViewName = aSrcCasView.getViewName();
        this.mTgtCasViewName = aTgtCasView.getViewName();
        if (null == this.mSrcCasViewName || null == this.mTgtCasViewName) {
            throw new UIMARuntimeException("unsupported_cas_copy_view_base_cas", null);
        }
        this.mLowLevelDestCas = aTgtCasView.getLowLevelCAS();
        if (aCopySofa && null != (sofa = aSrcCasView.getSofa())) {
            String sofaMime = sofa.getSofaMime();
            if (aSrcCasView.getDocumentText() != null) {
                aTgtCasView.setSofaDataString(aSrcCasView.getDocumentText(), sofaMime);
            } else if (aSrcCasView.getSofaDataURI() != null) {
                aTgtCasView.setSofaDataURI(aSrcCasView.getSofaDataURI(), sofaMime);
            } else if (aSrcCasView.getSofaDataArray() != null) {
                aTgtCasView.setSofaDataArray(this.copyFs2(aSrcCasView.getSofaDataArray()), sofaMime);
            }
        }
        HashSet<FeatureStructure> indexedFs = new HashSet<FeatureStructure>();
        Iterator<FSIndex<FeatureStructure>> indexes = aSrcCasView.getIndexRepository().getIndexes();
        while (indexes.hasNext()) {
            FSIndex<FeatureStructure> index = indexes.next();
            for (FeatureStructure fs : index) {
                FeatureStructure sofa2;
                if (indexedFs.contains(fs)) continue;
                FeatureStructure copyOfFs = this.copyFs2(fs);
                if (this.lenient && copyOfFs == null) continue;
                if (fs instanceof AnnotationBaseFS && (sofa2 = ((AnnotationBaseFS)copyOfFs).getFeatureValue(this.mDestSofaFeature)) == null) {
                    copyOfFs.setFeatureValue(this.mDestSofaFeature, aTgtCasView.getSofa());
                }
                if (!CasCopier.isDocumentAnnotation(copyOfFs)) {
                    aTgtCasView.addFsToIndexes(copyOfFs);
                }
                indexedFs.add(fs);
            }
        }
    }

    public FeatureStructure copyFs(FeatureStructure aFS) {
        if (null == this.mSrcCasViewName) {
            this.mSrcCasViewName = this.mOriginalSrcCasView.getViewName();
        }
        if (null == this.mTgtCasViewName) {
            this.mTgtCasViewName = this.mOriginalTgtCasView.getViewName();
        }
        if (null == this.mLowLevelDestCas) {
            this.mLowLevelDestCas = this.mOriginalTgtCasView.getLowLevelCAS();
        }
        return this.copyFs2(aFS);
    }

    private FeatureStructure copyFs2(FeatureStructure aFS) {
        FeatureStructure copy = this.copyFsInner(aFS);
        while (!this.fsToDo.isEmpty()) {
            FeatureStructure copyToFillSlots = this.fsToDo.remove(this.fsToDo.size() - 1);
            FeatureStructure srcToFillSlots = this.fsToDo.remove(this.fsToDo.size() - 1);
            this.copyFeatures(srcToFillSlots, copyToFillSlots);
        }
        return copy;
    }

    private FeatureStructure copyFsInner(FeatureStructure aFS) {
        Type destType;
        assert (this.casViewsInSameCas(aFS.getCAS(), this.mOriginalSrcCasView));
        FeatureStructure copy = this.mFsMap.get(aFS);
        if (copy != null) {
            return copy;
        }
        Type srcType = aFS.getType();
        if (aFS instanceof SofaFS) {
            String destSofaId = this.getDestSofaId(((SofaFS)aFS).getSofaID());
            return CasCopier.getOrCreateView(this.mOriginalTgtCasView, destSofaId).getSofa();
        }
        if (CasCopier.isDocumentAnnotation(aFS)) {
            String destViewName = this.getDestSofaId(((AnnotationFS)aFS).getView().getViewName());
            CAS destView = CasCopier.getOrCreateView(this.mOriginalTgtCasView, destViewName);
            AnnotationFS destDocAnnot = destView.getDocumentAnnotation();
            if (destDocAnnot != null) {
                this.copyFeatures(aFS, destDocAnnot);
            }
            return destDocAnnot;
        }
        if (aFS.getType().isArray()) {
            copy = this.copyArray(aFS);
            this.mFsMap.put(aFS, copy);
            return copy;
        }
        TypeSystem destTs = this.mOriginalTgtCasView.getTypeSystem();
        Type type = destType = destTs == this.mOriginalSrcCasView.getTypeSystem() ? srcType : destTs.getType(srcType.getName());
        if (destType == null) {
            if (this.lenient) {
                return null;
            }
            throw new UIMARuntimeException("type_not_found_during_cas_copy", new Object[]{srcType.getName()});
        }
        int typeCode = this.mLowLevelDestCas.ll_getTypeSystem().ll_getCodeForType(destType);
        int destFsAddr = this.mLowLevelDestCas.ll_createFS(typeCode);
        FeatureStructure destFs = this.mLowLevelDestCas.ll_getFSForRef(destFsAddr);
        this.mFsMap.put(aFS, destFs);
        this.fsToDo.add(aFS);
        this.fsToDo.add(destFs);
        return destFs;
    }

    private String getDestSofaId(String id) {
        return null != this.mSrcCasViewName && this.mSrcCasViewName.equals(id) ? this.mTgtCasViewName : id;
    }

    private void copyFeatures(FeatureStructure aSrcFS, FeatureStructure aDestFS) {
        Type srcType = aSrcFS.getType();
        Type destType = aDestFS.getType();
        for (Feature srcFeat : srcType.getFeatures()) {
            Feature destFeat;
            if (destType == aSrcFS.getType()) {
                destFeat = srcFeat;
            } else {
                destFeat = destType.getFeatureByBaseName(srcFeat.getShortName());
                if (destFeat == null) {
                    if (this.lenient) continue;
                    throw new UIMARuntimeException("feature_not_found_during_cas_copy", new Object[]{srcFeat.getName()});
                }
            }
            String srcRangeName = srcFeat.getRange().getName();
            if (srcRangeName.equals("uima.cas.String")) {
                aDestFS.setStringValue(destFeat, aSrcFS.getStringValue(srcFeat));
                continue;
            }
            if (srcRangeName.equals("uima.cas.Integer")) {
                aDestFS.setIntValue(destFeat, aSrcFS.getIntValue(srcFeat));
                continue;
            }
            if (srcFeat.getRange().isPrimitive()) {
                aDestFS.setFeatureValueFromString(destFeat, aSrcFS.getFeatureValueAsString(srcFeat));
                continue;
            }
            FeatureStructure refFS = aSrcFS.getFeatureValue(srcFeat);
            if (refFS == null) continue;
            FeatureStructure copyRefFs = this.copyFsInner(refFS);
            aDestFS.setFeatureValue(destFeat, copyRefFs);
        }
    }

    public boolean alreadyCopied(FeatureStructure aFS) {
        return this.mFsMap.containsKey(aFS);
    }

    private FeatureStructure copyArray(FeatureStructure aSrcFs) {
        if (aSrcFs instanceof StringArrayFS) {
            StringArrayFS arrayFs = (StringArrayFS)aSrcFs;
            int len = arrayFs.size();
            StringArrayFS destFS = this.mOriginalTgtCasView.createStringArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof IntArrayFS) {
            IntArrayFS arrayFs = (IntArrayFS)aSrcFs;
            int len = arrayFs.size();
            IntArrayFS destFS = this.mOriginalTgtCasView.createIntArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof ByteArrayFS) {
            ByteArrayFS arrayFs = (ByteArrayFS)aSrcFs;
            int len = arrayFs.size();
            ByteArrayFS destFS = this.mOriginalTgtCasView.createByteArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof ShortArrayFS) {
            ShortArrayFS arrayFs = (ShortArrayFS)aSrcFs;
            int len = arrayFs.size();
            ShortArrayFS destFS = this.mOriginalTgtCasView.createShortArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof LongArrayFS) {
            LongArrayFS arrayFs = (LongArrayFS)aSrcFs;
            int len = arrayFs.size();
            LongArrayFS destFS = this.mOriginalTgtCasView.createLongArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof FloatArrayFS) {
            FloatArrayFS arrayFs = (FloatArrayFS)aSrcFs;
            int len = arrayFs.size();
            FloatArrayFS destFS = this.mOriginalTgtCasView.createFloatArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof DoubleArrayFS) {
            DoubleArrayFS arrayFs = (DoubleArrayFS)aSrcFs;
            int len = arrayFs.size();
            DoubleArrayFS destFS = this.mOriginalTgtCasView.createDoubleArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof BooleanArrayFS) {
            BooleanArrayFS arrayFs = (BooleanArrayFS)aSrcFs;
            int len = arrayFs.size();
            BooleanArrayFS destFS = this.mOriginalTgtCasView.createBooleanArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof ArrayFS) {
            ArrayFS arrayFs = (ArrayFS)aSrcFs;
            int len = arrayFs.size();
            ArrayFS destFS = this.mOriginalTgtCasView.createArrayFS(len);
            for (int i = 0; i < len; ++i) {
                FeatureStructure srcElem = arrayFs.get(i);
                if (srcElem == null) continue;
                FeatureStructure copyElem = this.copyFsInner(arrayFs.get(i));
                destFS.set(i, copyElem);
            }
            return destFS;
        }
        assert (false);
        return null;
    }

    private static CAS getOrCreateView(CAS aCas, String aViewName) {
        try {
            return aCas.getView(aViewName);
        }
        catch (CASRuntimeException e) {
            return aCas.createView(aViewName);
        }
    }

    private static boolean isDocumentAnnotation(FeatureStructure aFS) {
        return aFS instanceof AnnotationFS && aFS.equals(((AnnotationFS)aFS).getView().getDocumentAnnotation());
    }

    private boolean casViewsInSameCas(CAS c1, CAS c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        if ((c1 = (CAS)((Object)c1.getLowLevelCAS())).equals(c2 = (CAS)((Object)c2.getLowLevelCAS()))) {
            return true;
        }
        String v1 = c1.getViewName();
        String v2 = c2.getViewName();
        if (v1 == null) {
            if (v2 == null) {
                return c1.equals(c2);
            }
            try {
                return c1.getView(v2).equals(c2);
            }
            catch (CASRuntimeException e) {
                return false;
            }
        }
        try {
            return c2.getView(v1).equals(c1);
        }
        catch (CASRuntimeException e) {
            return false;
        }
    }
}

