/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CasToInlineXml {
    public void destroy() {
    }

    public String format(CAS aCAS) throws CASException {
        return this.generateXML(aCAS, null);
    }

    public String format(CAS aCAS, FSMatchConstraint aFilter) throws CASException {
        return this.generateXML(aCAS, aFilter);
    }

    public String generateXML(CAS aCAS) throws CASException {
        return this.generateXML(aCAS, null);
    }

    public String generateXML(CAS aCAS, FSMatchConstraint aFilter) throws CASException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer sax2xml = new XMLSerializer(byteArrayOutputStream);
        String docText = aCAS.getDocumentText();
        char[] docCharArray = docText.toCharArray();
        this.replaceInvalidXmlChars(docCharArray);
        FSIterator iterator = aCAS.getAnnotationIndex().iterator();
        if (aFilter != null) {
            iterator = aCAS.createFilteredIterator(iterator, aFilter);
        }
        ArrayList<AnnotationFS> stack = new ArrayList<AnnotationFS>();
        int pos = 0;
        try {
            ContentHandler handler = sax2xml.getContentHandler();
            handler.startDocument();
            handler.startElement("", "Document", "Document", new AttributesImpl());
            AnnotationFS curAnnot = null;
            while (iterator.isValid()) {
                AnnotationFS nextAnnot = (AnnotationFS)iterator.get();
                if (curAnnot == null || nextAnnot.getBegin() < curAnnot.getEnd()) {
                    if (curAnnot == null || nextAnnot.getEnd() <= curAnnot.getEnd()) {
                        try {
                            handler.characters(docCharArray, pos, nextAnnot.getBegin() - pos);
                            pos = nextAnnot.getBegin();
                            handler.startElement("", nextAnnot.getType().getName(), nextAnnot.getType().getName(), this.getFeatureAttributes(nextAnnot, aCAS));
                            stack.add(curAnnot);
                            curAnnot = nextAnnot;
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            System.err.println("Invalid annotation range: " + nextAnnot.getBegin() + "," + nextAnnot.getEnd() + " in document of length " + docText.length());
                        }
                    }
                    iterator.moveToNext();
                    continue;
                }
                try {
                    handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                    pos = curAnnot.getEnd();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + " in document of length " + docText.length());
                }
                handler.endElement("", curAnnot.getType().getName(), curAnnot.getType().getName());
                curAnnot = (AnnotationFS)stack.remove(stack.size() - 1);
            }
            if (curAnnot != null) {
                try {
                    handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                    pos = curAnnot.getEnd();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + "in document of length " + docText.length());
                }
                handler.endElement("", curAnnot.getType().getName(), curAnnot.getType().getName());
                while (!stack.isEmpty() && (curAnnot = (AnnotationFS)stack.remove(stack.size() - 1)) != null) {
                    try {
                        handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                        pos = curAnnot.getEnd();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + "in document of length " + docText.length());
                    }
                    handler.endElement("", curAnnot.getType().getName(), curAnnot.getType().getName());
                }
            }
            if (pos < docCharArray.length) {
                handler.characters(docCharArray, pos, docCharArray.length - pos);
            }
            handler.endElement("", "Document", "Document");
            handler.endDocument();
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (SAXException e) {
            throw new UIMARuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UIMARuntimeException(e);
        }
    }

    private final Attributes getFeatureAttributes(FeatureStructure aFS, CAS aCAS) {
        AttributesImpl attrs = new AttributesImpl();
        for (Feature feat : aFS.getType().getFeatures()) {
            String featName = feat.getShortName();
            String rangeTypeName = feat.getRange().getName();
            if (feat.getRange().isPrimitive()) {
                String str = aFS.getFeatureValueAsString(feat);
                if (str == null) {
                    attrs.addAttribute("", featName, featName, "CDATA", "null");
                    continue;
                }
                if (str.length() > 64) {
                    str = str.substring(0, 64) + "...";
                }
                attrs.addAttribute("", featName, featName, "CDATA", str);
                continue;
            }
            if (feat.getRange().isArray() && feat.getRange().getComponentType().isPrimitive()) {
                String attrVal;
                CommonArrayFS arrayFS;
                String[] vals = null;
                if ("uima.cas.StringArray".equals(rangeTypeName)) {
                    arrayFS = (StringArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toArray();
                    }
                } else if ("uima.cas.IntegerArray".equals(rangeTypeName)) {
                    arrayFS = (IntArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toStringArray();
                    }
                } else if ("uima.cas.FloatArray".equals(rangeTypeName)) {
                    arrayFS = (FloatArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toStringArray();
                    }
                } else if ("uima.cas.BooleanArray".equals(rangeTypeName)) {
                    arrayFS = (BooleanArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toStringArray();
                    }
                } else if ("uima.cas.ByteArray".equals(rangeTypeName)) {
                    arrayFS = (ByteArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toStringArray();
                    }
                } else if ("uima.cas.ShortArray".equals(rangeTypeName)) {
                    arrayFS = (ShortArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toStringArray();
                    }
                } else if ("uima.cas.LongArray".equals(rangeTypeName)) {
                    arrayFS = (LongArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        vals = arrayFS.toStringArray();
                    }
                } else if ("uima.cas.DoubleArray".equals(rangeTypeName) && (arrayFS = (DoubleArrayFS)aFS.getFeatureValue(feat)) != null) {
                    vals = arrayFS.toStringArray();
                }
                if (vals == null) {
                    attrVal = "null";
                } else {
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < vals.length - 1; ++i) {
                        buf.append(vals[i]);
                        buf.append(',');
                    }
                    if (vals.length > 0) {
                        buf.append(vals[vals.length - 1]);
                    }
                    buf.append(']');
                    attrVal = buf.toString();
                }
                attrs.addAttribute("", featName, featName, "CDATA", attrVal);
                continue;
            }
            FeatureStructure fsVal = aFS.getFeatureValue(feat);
            if (fsVal == null) {
                attrs.addAttribute("", featName, featName, "CDATA", "null");
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(fsVal.getType().getShortName());
            if (fsVal instanceof AnnotationFS) {
                buf.append(" [");
                String str = ((AnnotationFS)fsVal).getCoveredText();
                if (str.length() > 64) {
                    str = str.substring(0, 64) + "...";
                }
                buf.append(str);
                buf.append(']');
            }
            attrs.addAttribute("", featName, featName, "CDATA", buf.toString());
        }
        return attrs;
    }

    private void replaceInvalidXmlChars(char[] aChars) {
        for (int i = 0; i < aChars.length; ++i) {
            if (!(aChars[i] < ' ' && aChars[i] != '\t' && aChars[i] != '\n' && aChars[i] != '\r' || aChars[i] > '\ud7ff' && aChars[i] < '\ue000' || aChars[i] == '\ufffe') && aChars[i] != '\uffff') continue;
            aChars[i] = 32;
        }
    }
}

