/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.internal.util.UIMALogFormatter;
import org.apache.uima.internal.util.UIMAStreamHandler;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR47Logger_impl
implements Logger {
    private static final String EXCEPTION_MESSAGE = "Exception occurred";
    private java.util.logging.Logger logger = null;
    private ResourceManager mResourceManager = null;

    private JSR47Logger_impl(Class<?> component) {
        this.logger = component != null ? java.util.logging.Logger.getLogger(component.getName()) : java.util.logging.Logger.getLogger("org.apache.uima");
    }

    private JSR47Logger_impl() {
        this(null);
    }

    public static synchronized Logger getInstance(Class<?> component) {
        return new JSR47Logger_impl(component);
    }

    public static synchronized Logger getInstance() {
        return new JSR47Logger_impl();
    }

    @Override
    @Deprecated
    public void log(String aMessage) {
        if (this.isLoggable(Level.INFO)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            String[] sourceInfo = this.getStackTraceInfo(null, new Throwable());
            this.logger.logp(java.util.logging.Level.INFO, sourceInfo[0], sourceInfo[1], aMessage);
        }
    }

    @Override
    @Deprecated
    public void log(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        if (this.isLoggable(Level.INFO)) {
            if (aMessageKey == null || aMessageKey.equals("")) {
                return;
            }
            String[] sourceInfo = this.getStackTraceInfo(null, new Throwable());
            this.logger.logp(java.util.logging.Level.INFO, sourceInfo[0], sourceInfo[1], I18nUtil.localizeMessage(aResourceBundleName, aMessageKey, aArguments, this.getExtensionClassLoader()));
        }
    }

    @Override
    @Deprecated
    public void logException(Exception aException) {
        if (this.isLoggable(Level.INFO)) {
            if (aException == null) {
                return;
            }
            String[] sourceInfo = this.getStackTraceInfo(null, new Throwable());
            this.logger.logp(java.util.logging.Level.INFO, sourceInfo[0], sourceInfo[1], EXCEPTION_MESSAGE, aException);
        }
    }

    @Override
    @Deprecated
    public void setOutputStream(OutputStream out) {
        if (out == null) {
            LogManager.getLogManager().getLogger("").setLevel(java.util.logging.Level.OFF);
            return;
        }
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            LogManager.getLogManager().getLogger("").removeHandler(handlers[i]);
        }
        UIMAStreamHandler streamHandler = new UIMAStreamHandler(out, new UIMALogFormatter());
        streamHandler.setLevel(java.util.logging.Level.ALL);
        LogManager.getLogManager().getLogger("").addHandler(streamHandler);
    }

    @Override
    @Deprecated
    public void setOutputStream(PrintStream out) {
        if (out == null) {
            LogManager.getLogManager().getLogger("").setLevel(java.util.logging.Level.OFF);
            return;
        }
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            LogManager.getLogManager().getLogger("").removeHandler(handlers[i]);
        }
        UIMAStreamHandler streamHandler = new UIMAStreamHandler(out, new UIMALogFormatter());
        streamHandler.setLevel(java.util.logging.Level.ALL);
        LogManager.getLogManager().getLogger("").addHandler(streamHandler);
    }

    @Override
    public boolean isLoggable(Level level) {
        java.util.logging.Level jsr47Level = this.getJSR47Level(level);
        return this.logger.isLoggable(jsr47Level);
    }

    @Override
    public void setLevel(Level level) {
        java.util.logging.Level jsr47Level = this.getJSR47Level(level);
        this.logger.setLevel(jsr47Level);
    }

    @Override
    public void log(Level level, String aMessage) {
        if (this.isLoggable(level)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            java.util.logging.Level jsr47Level = this.getJSR47Level(level);
            String[] sourceInfo = this.getStackTraceInfo(null, new Throwable());
            this.logger.logp(jsr47Level, sourceInfo[0], sourceInfo[1], aMessage);
        }
    }

    @Override
    public void log(Level level, String aMessage, Object param1) {
        if (this.isLoggable(level)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            java.util.logging.Level jsr47Level = this.getJSR47Level(level);
            String[] sourceInfo = this.getStackTraceInfo(null, new Throwable());
            this.logger.logp(jsr47Level, sourceInfo[0], sourceInfo[1], MessageFormat.format(aMessage, param1));
        }
    }

    @Override
    public void log(Level level, String aMessage, Object[] params) {
        if (this.isLoggable(level)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            java.util.logging.Level jsr47Level = this.getJSR47Level(level);
            String[] sourceInfo = this.getStackTraceInfo(null, new Throwable());
            this.logger.logp(jsr47Level, sourceInfo[0], sourceInfo[1], MessageFormat.format(aMessage, params));
        }
    }

    @Override
    public void log(Level level, String aMessage, Throwable thrown) {
        if (this.isLoggable(level)) {
            String[] sourceInfo;
            java.util.logging.Level jsr47Level;
            if (aMessage != null && !aMessage.equals("")) {
                jsr47Level = this.getJSR47Level(level);
                sourceInfo = this.getStackTraceInfo(null, new Throwable());
                this.logger.logp(jsr47Level, sourceInfo[0], sourceInfo[1], aMessage, thrown);
            }
            if (thrown != null && (aMessage == null || aMessage.equals(""))) {
                jsr47Level = this.getJSR47Level(level);
                sourceInfo = this.getStackTraceInfo(null, new Throwable());
                this.logger.logp(jsr47Level, sourceInfo[0], sourceInfo[1], EXCEPTION_MESSAGE, thrown);
            }
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object param1) {
        if (this.isLoggable(level)) {
            if (msgKey == null || msgKey.equals("")) {
                return;
            }
            java.util.logging.Level jsr47Level = this.getJSR47Level(level);
            this.logger.logp(jsr47Level, sourceClass, sourceMethod, I18nUtil.localizeMessage(bundleName, msgKey, new Object[]{param1}, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object[] params) {
        if (this.isLoggable(level)) {
            if (msgKey == null || msgKey.equals("")) {
                return;
            }
            java.util.logging.Level jsr47Level = this.getJSR47Level(level);
            this.logger.logp(jsr47Level, sourceClass, sourceMethod, I18nUtil.localizeMessage(bundleName, msgKey, params, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Throwable thrown) {
        if (this.isLoggable(level)) {
            java.util.logging.Level jsr47Level;
            if (msgKey != null && !msgKey.equals("")) {
                jsr47Level = this.getJSR47Level(level);
                this.logger.logp(jsr47Level, sourceClass, sourceMethod, I18nUtil.localizeMessage(bundleName, msgKey, null, this.getExtensionClassLoader()), thrown);
            }
            if (thrown != null && (msgKey == null || msgKey.equals(""))) {
                jsr47Level = this.getJSR47Level(level);
                this.logger.logp(jsr47Level, sourceClass, sourceMethod, EXCEPTION_MESSAGE, thrown);
            }
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey) {
        if (this.isLoggable(level)) {
            if (msgKey == null || msgKey.equals("")) {
                return;
            }
            java.util.logging.Level jsr47Level = this.getJSR47Level(level);
            this.logger.logp(jsr47Level, sourceClass, sourceMethod, I18nUtil.localizeMessage(bundleName, msgKey, null, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void log(String wrapperFQCN, Level level, String message, Throwable thrown) {
        java.util.logging.Level jsr47Level = this.getJSR47Level(level);
        String[] sourceInfo = this.getStackTraceInfo(wrapperFQCN, new Throwable());
        this.logger.logp(jsr47Level, sourceInfo[0], sourceInfo[1], message, thrown);
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.mResourceManager = resourceManager;
    }

    private ClassLoader getExtensionClassLoader() {
        if (this.mResourceManager == null) {
            return null;
        }
        return this.mResourceManager.getExtensionClassLoader();
    }

    private java.util.logging.Level getJSR47Level(Level level) {
        switch (level.toInteger()) {
            case 0x7FFFFFFF: {
                return java.util.logging.Level.OFF;
            }
            case 70000: {
                return java.util.logging.Level.SEVERE;
            }
            case 60000: {
                return java.util.logging.Level.WARNING;
            }
            case 50000: {
                return java.util.logging.Level.INFO;
            }
            case 40000: {
                return java.util.logging.Level.CONFIG;
            }
            case 30000: {
                return java.util.logging.Level.FINE;
            }
            case 20000: {
                return java.util.logging.Level.FINER;
            }
            case 10000: {
                return java.util.logging.Level.FINEST;
            }
        }
        return java.util.logging.Level.ALL;
    }

    private String[] getStackTraceInfo(String wrapperFQCN, Throwable thrown) {
        StackTraceElement[] stackTraceElement = thrown.getStackTrace();
        String sourceMethod = "";
        String sourceClass = "";
        int lineNumber = 0;
        try {
            int index;
            if (wrapperFQCN != null) {
                boolean found = false;
                for (index = 0; index < stackTraceElement.length; ++index) {
                    if (!wrapperFQCN.equals(stackTraceElement[index].getClassName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    index = 0;
                }
            }
            lineNumber = stackTraceElement[++index].getLineNumber();
            sourceMethod = stackTraceElement[index].getMethodName();
            sourceClass = stackTraceElement[index].getClassName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (lineNumber > 0) {
            StringBuffer buffer = new StringBuffer(25);
            buffer.append(sourceMethod);
            buffer.append("(");
            buffer.append(lineNumber);
            buffer.append(")");
            sourceMethod = buffer.toString();
        }
        return new String[]{sourceClass, sourceMethod};
    }
}

