/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.classes;

import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Suppliers2;

@Immutable
public final class Classes {
    private static final Supplier<String> MAIN_CLASS_NAME = Suppliers2.memoize(() -> {
        Collection<StackTraceElement[]> stacks = Thread.getAllStackTraces().values();
        for (StackTraceElement[] currentStack : stacks) {
            StackTraceElement startMethod;
            if (currentStack.length == 0 || !(startMethod = currentStack[currentStack.length - 1]).getMethodName().equals("main")) continue;
            return Classes.classNameFor(startMethod);
        }
        throw new IllegalStateException("No main method found in the stack traces, could it be that the main thread has been terminated?");
    });

    private Classes() {
    }

    @CheckReturnValue
    @Nonnull
    public static String mainClassName() {
        return MAIN_CLASS_NAME.get();
    }

    private static String classNameFor(StackTraceElement element) {
        String fullyQualifiedClassName = element.getClassName();
        int classNameStart = fullyQualifiedClassName.lastIndexOf(46) + 1;
        String simpleClassName = fullyQualifiedClassName.substring(classNameStart);
        return simpleClassName;
    }
}

