/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Preconditions2;
import se.softhouse.common.strings.StringsUtil;

@Immutable
public final class Functions2 {
    private Functions2() {
    }

    @Nonnull
    public static <T> Function<T, T> compound(Function<T, T> first, Function<T, T> second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        if (first == Function.identity()) {
            return second;
        }
        return value -> second.apply(first.apply(value));
    }

    @Nonnull
    public static <E> Function<List<E>, List<E>> listTransformer(Function<E, E> elementTransformer) {
        if (elementTransformer == Function.identity()) {
            return Function.identity();
        }
        return new ListTransformer(elementTransformer);
    }

    @Nonnull
    public static <K, V> Function<Map<K, V>, Map<K, V>> mapValueTransformer(Function<V, V> valueTransformer) {
        if (valueTransformer == Function.identity()) {
            return Function.identity();
        }
        return new MapValueTransformer(valueTransformer);
    }

    @Nonnull
    public static <E> Function<List<E>, List<E>> unmodifiableList() {
        return new UnmodifiableListMaker();
    }

    @Nonnull
    public static <K, V> Function<Map<K, V>, Map<K, V>> unmodifiableMap() {
        return new UnmodifiableMapMaker();
    }

    @Nonnull
    public static <T> Function<T, T> repeat(Function<T, T> function, long times) {
        Objects.requireNonNull(function);
        Preconditions2.check(times >= 0L, "times (%s) must be positive", times);
        return new FunctionRepeater(function, times);
    }

    public static Function<File, String> fileToString() {
        return FileToString.INSTANCE;
    }

    private static final class FileToString
    implements Function<File, String> {
        private static final Function<File, String> INSTANCE = new FileToString();

        private FileToString() {
        }

        @Override
        public String apply(@Nonnull File input) {
            if (input.isDirectory()) {
                throw new IllegalArgumentException(input.getAbsolutePath() + " is a directory, not a file");
            }
            try {
                return new String(Files.readAllBytes(input.toPath()), StringsUtil.UTF8);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("I/O error occured while reading: " + input.getAbsolutePath(), e);
            }
        }
    }

    private static final class FunctionRepeater<T>
    implements Function<T, T> {
        private final long times;
        @Nonnull
        private final Function<T, T> function;

        private FunctionRepeater(Function<T, T> function, long times) {
            this.function = function;
            this.times = times;
        }

        @Override
        public T apply(T input) {
            T output = input;
            for (long i = 0L; i < this.times; ++i) {
                output = this.function.apply(output);
            }
            return output;
        }
    }

    private static final class UnmodifiableMapMaker<K, V>
    implements Function<Map<K, V>, Map<K, V>> {
        private UnmodifiableMapMaker() {
        }

        @Override
        public Map<K, V> apply(Map<K, V> value) {
            if (value == null) {
                return null;
            }
            return Collections.unmodifiableMap(value);
        }
    }

    private static final class UnmodifiableListMaker<E>
    implements Function<List<E>, List<E>> {
        private UnmodifiableListMaker() {
        }

        @Override
        public List<E> apply(List<E> value) {
            if (value == null) {
                return null;
            }
            return Collections.unmodifiableList(value);
        }
    }

    private static final class MapValueTransformer<K, V>
    implements Function<Map<K, V>, Map<K, V>> {
        private final Function<V, V> valueTransformer;

        private MapValueTransformer(Function<V, V> valueTransformer) {
            this.valueTransformer = Objects.requireNonNull(valueTransformer);
        }

        @Override
        public Map<K, V> apply(Map<K, V> map) {
            if (map == null) {
                return null;
            }
            LinkedHashMap transformed = new LinkedHashMap(map.size());
            map.entrySet().stream().forEach(entry -> transformed.put(entry.getKey(), this.valueTransformer.apply(entry.getValue())));
            return Collections.unmodifiableMap(transformed);
        }
    }

    private static final class ListTransformer<E>
    implements Function<List<E>, List<E>> {
        private final Function<E, E> elementTransformer;

        private ListTransformer(Function<E, E> elementTransformer) {
            this.elementTransformer = Objects.requireNonNull(elementTransformer);
        }

        @Override
        public List<E> apply(List<E> values) {
            if (values == null) {
                return null;
            }
            return Collections.unmodifiableList(values.stream().map(this.elementTransformer).collect(Collectors.toList()));
        }
    }
}

