/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import se.softhouse.common.guavaextensions.Lists2;
import se.softhouse.common.guavaextensions.Predicates2;

public final class Sets2 {
    private Sets2() {
    }

    public static <E> Set<E> difference(final Set<E> set1, final Set<?> set2) {
        Objects.requireNonNull(set1, "set1");
        Objects.requireNonNull(set2, "set2");
        final Predicate<?> notInSet2 = Predicates2.in(set2).negate();
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return Lists2.unmodifiableIterator(set1.stream().filter(notInSet2).iterator());
            }

            @Override
            public int size() {
                return Lists2.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set1);
            }

            @Override
            public boolean contains(Object e) {
                return set1.contains(e) && !set2.contains(e);
            }
        };
    }

    public static <E> Set<E> union(final Set<? extends E> one, final Set<? extends E> two) {
        return new AbstractSet<E>(){
            private final Set<? extends E> set2minus1;
            {
                this.set2minus1 = Sets2.difference(two, one);
            }

            @Override
            public Iterator<E> iterator() {
                return Lists2.unmodifiableIterator(Stream.concat(one.stream(), this.set2minus1.stream()).iterator());
            }

            @Override
            public int size() {
                return one.size() + this.set2minus1.size();
            }

            @Override
            public boolean contains(Object e) {
                return one.contains(e) || two.contains(e);
            }

            @Override
            public boolean isEmpty() {
                return one.isEmpty() && two.isEmpty();
            }
        };
    }
}

