/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.guavaextensions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Preconditions2;

@Immutable
public final class Suppliers2 {
    private Suppliers2() {
    }

    @CheckReturnValue
    public static <T> Supplier<List<T>> ofRepeatedElements(Supplier<? extends T> elementSupplier, int elementsToSupply) {
        Objects.requireNonNull(elementSupplier);
        Preconditions2.check(elementsToSupply >= 0, "elementsToSupply may not be negative", new Object[0]);
        return new ListSupplier(elementSupplier, elementsToSupply);
    }

    @CheckReturnValue
    public static <T> Supplier<T> ofInstance(@Nullable T instance) {
        return new InstanceSupplier(instance);
    }

    public static boolean isSuppliedAlready(Supplier<?> supplier) {
        ListSupplier listSupplier;
        if (supplier.getClass().equals(InstanceSupplier.class)) {
            return true;
        }
        return supplier instanceof ListSupplier && (listSupplier = (ListSupplier)supplier).elementSupplier.getClass().equals(InstanceSupplier.class);
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return delegate instanceof MemoizingSupplier ? delegate : new MemoizingSupplier(Objects.requireNonNull(delegate));
    }

    private static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }
    }

    private static final class InstanceSupplier<T>
    implements Supplier<T> {
        private final T instance;

        private InstanceSupplier(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }

    private static final class ListSupplier<T>
    implements Supplier<List<T>> {
        private final Supplier<? extends T> elementSupplier;
        private final int elementsToSupply;

        private ListSupplier(Supplier<? extends T> elementSupplier, int elementsToSupply) {
            this.elementSupplier = elementSupplier;
            this.elementsToSupply = elementsToSupply;
        }

        @Override
        public List<T> get() {
            ArrayList<T> result = new ArrayList<T>(this.elementsToSupply);
            for (int i = 0; i < this.elementsToSupply; ++i) {
                result.add(this.elementSupplier.get());
            }
            return result;
        }
    }
}

