/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.common.numbers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.strings.Describable;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.Describers;
import se.softhouse.common.strings.StringsUtil;

@Immutable
public abstract class NumberType<T extends Number> {
    public static final NumberType<Byte> BYTE = new ByteType();
    public static final NumberType<Short> SHORT = new ShortType();
    public static final NumberType<Integer> INTEGER = new IntegerType();
    public static final NumberType<Long> LONG = new LongType();
    public static final UnlimitedNumberType<BigInteger> BIG_INTEGER = new BigIntegerType();
    public static final UnlimitedNumberType<BigDecimal> BIG_DECIMAL = new BigDecimalType();
    public static final List<NumberType<?>> TYPES = Collections.unmodifiableList(Arrays.asList(BYTE, SHORT, INTEGER, LONG, BIG_INTEGER, BIG_DECIMAL));
    public static final List<NumberType<?>> UNLIMITED_TYPES = Collections.unmodifiableList(Arrays.asList(BIG_INTEGER, BIG_DECIMAL));
    static final String OUT_OF_RANGE = "'%s' is not in the range %s to %s";
    private static final String TEMPLATE = "'%s' is not a valid %s (Localization: %s)" + StringsUtil.NEWLINE + " %s";

    NumberType() {
    }

    @CheckReturnValue
    @Nonnull
    public abstract T minValue();

    @CheckReturnValue
    @Nonnull
    public abstract T maxValue();

    @CheckReturnValue
    @Nonnull
    public abstract String name();

    @CheckReturnValue
    @Nonnull
    public final T defaultValue() {
        return this.from(0L);
    }

    @CheckReturnValue
    @Nonnull
    public abstract T from(Number var1);

    public boolean inRange(Number number) {
        Long value = number.longValue();
        return value >= ((Number)this.minValue()).longValue() && value <= ((Number)this.maxValue()).longValue();
    }

    @CheckReturnValue
    @Nonnull
    public final T parse(String input, Locale inLocale) {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = this.parser(inLocale).parse(input, parsePosition);
        if (parsePosition.getIndex() != input.length() || result == null) {
            throw Describables.illegalArgument(this.formatError(input, inLocale, parsePosition));
        }
        this.throwForOutOfRange(input, result, inLocale);
        return this.from(result);
    }

    void throwForOutOfRange(String input, Number result, Locale inLocale) throws IllegalArgumentException {
        if (!this.inRange(result)) {
            throw Describables.illegalArgument(Describables.format(OUT_OF_RANGE, input, this.format(this.minValue(), inLocale), this.format(this.maxValue(), inLocale)));
        }
    }

    @CheckReturnValue
    @Nonnull
    public final T parse(String value) {
        return this.parse(value, Locale.US);
    }

    NumberFormat parser(Locale inLocale) {
        NumberFormat formatter = NumberFormat.getInstance(inLocale);
        formatter.setParseIntegerOnly(true);
        return formatter;
    }

    Describable formatError(Object invalidValue, Locale locale, ParsePosition positionForInvalidCharacter) {
        String localeInformation = locale.getDisplayName(locale);
        return Describables.format(TEMPLATE, invalidValue, this.name(), localeInformation, StringsUtil.pointingAtIndex(positionForInvalidCharacter.getIndex()));
    }

    @CheckReturnValue
    @Nonnull
    public String descriptionOfValidValues(Locale inLocale) {
        return this.format(this.minValue(), inLocale) + " to " + this.format(this.maxValue(), inLocale);
    }

    private String format(T value, Locale inLocale) {
        return Describers.numberDescriber().describe((Number)value, inLocale);
    }

    public String toString() {
        return this.name();
    }

    private static final class BigDecimalType
    extends UnlimitedNumberType<BigDecimal> {
        private BigDecimalType() {
        }

        @Override
        public String name() {
            return "big-decimal";
        }

        @Override
        public boolean inRange(Number number) {
            Objects.requireNonNull(number);
            return true;
        }

        @Override
        public BigDecimal from(Number value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            return BigDecimal.valueOf(value.doubleValue());
        }

        @Override
        public String descriptionOfValidValues(Locale inLocale) {
            Objects.requireNonNull(inLocale);
            return "an arbitrary decimal number (practically no limits)";
        }
    }

    private static final class BigIntegerType
    extends UnlimitedNumberType<BigInteger> {
        private BigIntegerType() {
        }

        @Override
        public String name() {
            return "big-integer";
        }

        @Override
        public BigInteger from(Number value) {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(value.longValue());
        }

        @Override
        public boolean inRange(Number number) {
            Objects.requireNonNull(number);
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).scale() <= 0;
            }
            return true;
        }

        @Override
        void throwForOutOfRange(String input, Number result, Locale inLocale) throws IllegalArgumentException {
            if (result instanceof BigDecimal) {
                boolean hasDecimals;
                boolean bl = hasDecimals = ((BigDecimal)result).scale() > 0;
                if (hasDecimals) {
                    int decimalPosition = input.indexOf(46);
                    throw Describables.illegalArgument(this.formatError(input, inLocale, new ParsePosition(decimalPosition)));
                }
            }
        }

        @Override
        public String descriptionOfValidValues(Locale inLocale) {
            Objects.requireNonNull(inLocale);
            return "an arbitrary integer number (practically no limits)";
        }
    }

    public static abstract class UnlimitedNumberType<T extends Number>
    extends NumberType<T> {
        UnlimitedNumberType() {
        }

        @Override
        @Deprecated
        public T minValue() {
            throw new UnsupportedOperationException(this.name() + " doesn't have any minValue");
        }

        @Override
        @Deprecated
        public T maxValue() {
            throw new UnsupportedOperationException(this.name() + " doesn't have any maxValue");
        }

        @Override
        NumberFormat parser(Locale inLocale) {
            DecimalFormat parser = new DecimalFormat("", new DecimalFormatSymbols(inLocale));
            parser.setParseBigDecimal(true);
            return parser;
        }

        @Override
        public abstract String descriptionOfValidValues(Locale var1);
    }

    private static final class LongType
    extends NumberType<Long> {
        private LongType() {
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public Long from(Number value) {
            return value.longValue();
        }

        @Override
        public String name() {
            return "long";
        }

        @Override
        public boolean inRange(Number number) {
            if (number instanceof Long) {
                return true;
            }
            try {
                Long.parseLong(number.toString());
                return true;
            }
            catch (NumberFormatException wrongNumber) {
                return false;
            }
        }
    }

    private static final class ShortType
    extends NumberType<Short> {
        private ShortType() {
        }

        @Override
        public Short minValue() {
            return (short)Short.MIN_VALUE;
        }

        @Override
        public Short maxValue() {
            return (short)Short.MAX_VALUE;
        }

        @Override
        public Short from(Number value) {
            return value.shortValue();
        }

        @Override
        public String name() {
            return "short";
        }
    }

    private static final class IntegerType
    extends NumberType<Integer> {
        private IntegerType() {
        }

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer from(Number value) {
            return value.intValue();
        }

        @Override
        public String name() {
            return "integer";
        }
    }

    private static final class ByteType
    extends NumberType<Byte> {
        private ByteType() {
        }

        @Override
        public Byte minValue() {
            return (byte)-128;
        }

        @Override
        public Byte maxValue() {
            return (byte)127;
        }

        @Override
        public Byte from(Number value) {
            return value.byteValue();
        }

        @Override
        public String name() {
            return "byte";
        }
    }
}

