/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Predicates2;
import se.softhouse.common.guavaextensions.Suppliers2;
import se.softhouse.common.strings.Describable;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.Describer;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.ArgumentExceptions;
import se.softhouse.jargo.CommandLineParserInstance;
import se.softhouse.jargo.StringParsers;
import se.softhouse.jargo.Usage;

@Immutable
public final class Argument<T> {
    @Nonnull
    private final List<String> names;
    @Nonnull
    private final Describable description;
    @Nonnull
    private final Optional<String> metaDescription;
    private final boolean hideFromUsage;
    @Nonnull
    private final String separator;
    private final boolean required;
    private final boolean ignoreCase;
    private final boolean isAllowedToRepeat;
    @Nonnull
    private final StringParsers.InternalStringParser<T> parser;
    @Nonnull
    private final Supplier<? extends T> defaultValue;
    @Nullable
    private final Describer<? super T> defaultValueDescriber;
    @Nonnull
    private final Predicate<? super T> limiter;
    @Nonnull
    private final Function<T, T> finalizer;
    private final boolean isPropertyMap;
    private final CollationKey sortingKey;
    private static final Collator LINGUISTIC_ORDER = Collator.getInstance(Locale.ROOT);
    static final Predicate<Argument<?>> IS_INDEXED = Argument::isIndexed;
    static final Predicate<Argument<?>> IS_REQUIRED = Argument::isRequired;
    static final Predicate<Argument<?>> IS_VISIBLE = input -> !input.hideFromUsage;
    static final Predicate<Argument<?>> IS_OF_VARIABLE_ARITY = input -> input.parser().parameterArity() == ParameterArity.VARIABLE_AMOUNT;
    static final Comparator<Argument<?>> NAME_COMPARATOR = (lhs, rhs) -> lhs.sortingKey.compareTo(rhs.sortingKey);

    Argument(ArgumentBuilder<?, T> builder) {
        this.parser = builder.internalParser();
        this.defaultValueDescriber = builder.defaultValueDescriber();
        this.description = builder.description();
        this.required = builder.isRequired();
        this.separator = builder.separator();
        this.ignoreCase = builder.isIgnoringCase();
        this.names = builder.names();
        this.isPropertyMap = builder.isPropertyMap();
        this.isAllowedToRepeat = builder.isAllowedToRepeat();
        this.hideFromUsage = builder.isHiddenFromUsage();
        this.metaDescription = builder.metaDescription();
        this.finalizer = builder.finalizer();
        this.limiter = builder.limiter();
        this.defaultValue = builder.defaultValueSupplier() != null ? builder.defaultValueSupplier() : this.parser::defaultValue;
        if (Suppliers2.isSuppliedAlready(this.defaultValue)) {
            this.defaultValue();
        }
        this.sortingKey = LINGUISTIC_ORDER.getCollationKey(this.toString());
    }

    @Nullable
    public T parse(String ... actualArguments) throws ArgumentException {
        return this.commandLineParser().parse(Arrays.asList(actualArguments)).get(this);
    }

    @Nonnull
    @CheckReturnValue
    public Usage usage() {
        return new Usage(this.commandLineParser());
    }

    public String toString() {
        if (this.isIndexed()) {
            return this.metaDescriptionInRightColumn();
        }
        return this.names().get(0);
    }

    @Nullable
    T defaultValue() {
        T value = this.finalizer.apply(this.defaultValue.get());
        this.checkLimitForDefaultValue(value);
        return value;
    }

    String descriptionOfValidValues(Locale inLocale) {
        if (this.limiter != Predicates2.alwaysTrue()) {
            return this.limiter.toString();
        }
        return this.parser().descriptionOfValidValues(this, inLocale);
    }

    @Nullable
    String defaultValueDescription(Locale inLocale) {
        T value = this.defaultValue();
        if (this.defaultValueDescriber != null) {
            return this.defaultValueDescriber.describe(value, inLocale);
        }
        return this.parser().describeValue(value);
    }

    @Nonnull
    String metaDescriptionInLeftColumn() {
        String meta = this.metaDescription.orElseGet(() -> this.parser.metaDescriptionInLeftColumn(this));
        if (!this.isPropertyMap() && !this.isIndexed()) {
            meta = this.separator + meta;
        }
        return meta;
    }

    @Nonnull
    String metaDescriptionInRightColumn() {
        return this.metaDescription.orElseGet(() -> this.parser.metaDescriptionInRightColumn(this));
    }

    void checkLimit(@Nullable T value) throws ArgumentException {
        if (!this.limiter.test(value)) {
            throw ArgumentExceptions.withMessage(Describables.format("'%s' is not %s", value, this.limiter));
        }
    }

    private void checkLimitForDefaultValue(@Nullable T value) {
        boolean error = false;
        try {
            if (!this.limiter.test(value)) {
                error = true;
            }
        }
        catch (IllegalArgumentException invalidDefaultValue) {
            throw new IllegalArgumentException(String.format("Invalid default value: %s", invalidDefaultValue.getMessage()), invalidDefaultValue);
        }
        if (error) {
            String disallowedValue = String.format("'%s' is not %s", value, this.limiter);
            throw new IllegalArgumentException(String.format("Invalid default value: %s", disallowedValue));
        }
    }

    @Nonnull
    StringParsers.InternalStringParser<T> parser() {
        return this.parser;
    }

    boolean isRequired() {
        return this.required;
    }

    @Nullable
    String separator() {
        return this.separator;
    }

    @Nonnull
    String description() {
        return this.description.description();
    }

    @Nonnull
    List<String> names() {
        return this.names;
    }

    boolean isPropertyMap() {
        return this.isPropertyMap;
    }

    boolean isAllowedToRepeat() {
        return this.isAllowedToRepeat;
    }

    boolean isIgnoringCase() {
        return this.ignoreCase;
    }

    Function<T, T> finalizer() {
        return this.finalizer;
    }

    boolean isIndexed() {
        return this.names().isEmpty();
    }

    boolean isHelpArgument() {
        return this.parser().equals(StringParsers.HelpParser.INSTANCE);
    }

    private CommandLineParserInstance commandLineParser() {
        return new CommandLineParserInstance(Arrays.asList(this));
    }

    static enum ParameterArity {
        NO_ARGUMENTS,
        VARIABLE_AMOUNT,
        AT_LEAST_ONE_ARGUMENT;

    }
}

