/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import se.softhouse.common.guavaextensions.Functions2;
import se.softhouse.common.guavaextensions.Lists2;
import se.softhouse.common.guavaextensions.Preconditions2;
import se.softhouse.common.guavaextensions.Predicates2;
import se.softhouse.common.guavaextensions.Suppliers2;
import se.softhouse.common.strings.Describable;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.Describer;
import se.softhouse.common.strings.Describers;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Command;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.StringParser;
import se.softhouse.jargo.StringParsers;
import se.softhouse.jargo.Usage;

@NotThreadSafe
public abstract class ArgumentBuilder<SELF extends ArgumentBuilder<SELF, T>, T> {
    static final String DEFAULT_SEPARATOR = " ";
    @Nonnull
    private List<String> names = Collections.emptyList();
    @Nonnull
    private Describable description = Describables.EMPTY_STRING;
    private boolean required = false;
    @Nonnull
    private String separator = " ";
    private boolean ignoreCase = false;
    private boolean isAllowedToRepeat = false;
    @Nonnull
    private Optional<String> metaDescription = Optional.empty();
    private boolean hideFromUsage = false;
    private boolean isPropertyMap = false;
    @Nullable
    private Supplier<? extends T> defaultValueSupplier = null;
    @Nullable
    private Describer<? super T> defaultValueDescriber = null;
    @Nonnull
    private Function<T, T> finalizer = Function.identity();
    @Nonnull
    private Predicate<? super T> limiter = Predicates2.alwaysTrue();
    @Nullable
    private final StringParsers.InternalStringParser<T> internalStringParser;
    @Nonnull
    private final SELF myself;

    protected ArgumentBuilder() {
        this(null);
    }

    ArgumentBuilder(StringParsers.InternalStringParser<T> stringParser) {
        this.internalStringParser = stringParser;
        this.myself = this.self();
    }

    private SELF self() {
        return (SELF)this;
    }

    @CheckReturnValue
    @Nonnull
    public final Argument<T> build() {
        return new Argument(this);
    }

    @Nullable
    public final T parse(String ... actualArguments) throws ArgumentException {
        return this.build().parse(actualArguments);
    }

    public final Usage usage() {
        return this.build().usage();
    }

    @Nonnull
    protected abstract StringParser<T> parser();

    @Nonnull
    StringParsers.InternalStringParser<T> internalParser() {
        StringParser<T> parser = this.parser();
        if (parser != InternalArgumentBuilder.MARKER) {
            return new StringParsers.StringParserBridge<T>(parser);
        }
        return this.internalStringParser;
    }

    public SELF names(String ... argumentNames) {
        this.checkNoSpaces(Arrays.asList(argumentNames));
        this.names = Arrays.asList(argumentNames);
        return this.myself;
    }

    public SELF names(Iterable<String> argumentNames) {
        this.checkNoSpaces(argumentNames);
        this.names = Collections.unmodifiableList(Lists2.newArrayList(argumentNames));
        return this.myself;
    }

    public final SELF ignoreCase() {
        this.ignoreCase = true;
        return this.myself;
    }

    public final SELF description(String theDescription) {
        this.description = Describables.withString(theDescription);
        return this.myself;
    }

    public final SELF description(Describable theDescription) {
        this.description = Objects.requireNonNull(theDescription);
        return this.myself;
    }

    public SELF required() {
        Preconditions2.check(this.defaultValueSupplier == null, "Having a requried argument and a default value makes no sense", new Object[0]);
        this.required = true;
        return this.myself;
    }

    public SELF defaultValue(@Nullable T value) {
        Preconditions2.check(!this.required, "Having a requried argument and a default value makes no sense", new Object[0]);
        this.defaultValueSupplier = Suppliers2.ofInstance(value);
        return this.myself;
    }

    public SELF defaultValueSupplier(Supplier<? extends T> aDefaultValueSupplier) {
        Preconditions2.check(!this.required, "Having a requried argument and a default value makes no sense", new Object[0]);
        this.defaultValueSupplier = Objects.requireNonNull(aDefaultValueSupplier);
        return this.myself;
    }

    public SELF defaultValueDescription(String aDescription) {
        this.defaultValueDescriber = Describers.withConstantString(aDescription);
        return this.myself;
    }

    public SELF defaultValueDescriber(Describer<? super T> describer) {
        this.defaultValueDescriber = Objects.requireNonNull(describer);
        return this.myself;
    }

    public final SELF metaDescription(String aMetaDescription) {
        Preconditions2.check(aMetaDescription.length() > 0, "a meta description can't be empty", new Object[0]);
        this.metaDescription = Optional.of(aMetaDescription);
        return this.myself;
    }

    public final SELF hideFromUsage() {
        this.hideFromUsage = true;
        return this.myself;
    }

    public SELF separator(String aSeparator) {
        this.separator = Objects.requireNonNull(aSeparator);
        return this.myself;
    }

    public SELF limitTo(Predicate<? super T> aLimiter) {
        this.limiter = Predicates2.and(this.limiter, aLimiter);
        return this.myself;
    }

    @CheckReturnValue
    public final MapArgumentBuilder<String, T> asPropertyMap() {
        return new MapArgumentBuilder(this, StringParsers.stringParser());
    }

    @CheckReturnValue
    public final <K> MapArgumentBuilder<K, T> asKeyValuesWithKeyParser(StringParser<K> keyParser) {
        return new MapArgumentBuilder(this, Objects.requireNonNull(keyParser));
    }

    @CheckReturnValue
    public SplitterArgumentBuilder<T> splitWith(String valueSeparator) {
        return new SplitterArgumentBuilder(this, valueSeparator);
    }

    @CheckReturnValue
    public ArityArgumentBuilder<T> variableArity() {
        return new ArityArgumentBuilder(this);
    }

    @CheckReturnValue
    public ArityArgumentBuilder<T> arity(int numberOfParameters) {
        Preconditions2.check(numberOfParameters > 1, "Arity requires at least 2 parameters (got %s)", numberOfParameters);
        return new ArityArgumentBuilder(this, numberOfParameters);
    }

    @CheckReturnValue
    public RepeatedArgumentBuilder<T> repeated() {
        return new RepeatedArgumentBuilder(this);
    }

    public String toString() {
        return new StringJoiner(", ", ArgumentBuilder.class.getSimpleName() + "{", "}").add("names=" + this.names).add("description=" + this.description).add("metaDescription=" + this.metaDescription).add("hideFromUsage=" + this.hideFromUsage).add("ignoreCase=" + this.ignoreCase).add("limiter=" + this.limiter).add("required=" + this.required).add("separator=" + this.separator).add("defaultValueDescriber=" + this.defaultValueDescriber).add("defaultValueSupplier=" + this.defaultValueSupplier).add("internalStringParser=" + this.internalStringParser).toString();
    }

    @OverridingMethodsMustInvokeSuper
    void copy(ArgumentBuilder<?, ?> copy) {
        this.names = copy.names;
        this.description = copy.description;
        this.required = copy.required;
        this.separator = copy.separator;
        this.ignoreCase = copy.ignoreCase;
        this.isAllowedToRepeat = copy.isAllowedToRepeat;
        this.metaDescription = copy.metaDescription;
        this.hideFromUsage = copy.hideFromUsage;
    }

    final SELF finalizeWith(Function<T, T> aFinalizer) {
        this.finalizer = Functions2.compound(this.finalizer, aFinalizer);
        return this.myself;
    }

    final void allowRepeatedArguments() {
        this.isAllowedToRepeat = true;
    }

    final void setAsPropertyMap() {
        this.isPropertyMap = true;
    }

    @Nonnull
    final List<String> names() {
        return this.names;
    }

    @Nullable
    Describer<? super T> defaultValueDescriber() {
        return this.defaultValueDescriber;
    }

    @Nonnull
    Describable description() {
        return this.description;
    }

    final boolean isRequired() {
        return this.required;
    }

    @Nullable
    final String separator() {
        return this.separator;
    }

    final boolean isIgnoringCase() {
        return this.ignoreCase;
    }

    final boolean isPropertyMap() {
        return this.isPropertyMap;
    }

    final boolean isAllowedToRepeat() {
        return this.isAllowedToRepeat;
    }

    @Nullable
    final Optional<String> metaDescription() {
        return this.metaDescription;
    }

    final boolean isHiddenFromUsage() {
        return this.hideFromUsage;
    }

    @Nullable
    final Supplier<? extends T> defaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    @Nonnull
    final Function<T, T> finalizer() {
        return this.finalizer;
    }

    @Nonnull
    final Predicate<? super T> limiter() {
        return this.limiter;
    }

    private void checkNoSpaces(Iterable<String> argumentNames) {
        for (String name : argumentNames) {
            Preconditions2.check(!name.contains(DEFAULT_SEPARATOR), "Detected a space in %s, argument names must not have spaces in them", name);
        }
    }

    @NotThreadSafe
    public static final class SplitterArgumentBuilder<T>
    extends ListArgumentBuilder<SplitterArgumentBuilder<T>, T> {
        private SplitterArgumentBuilder(ArgumentBuilder<?, T> builder, String valueSeparator) {
            super(new StringParsers.StringSplitterParser<T>(valueSeparator, builder.internalParser()));
            this.copy(builder);
            this.copyAsListBuilder(builder, 1);
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> arity(int numberOfParameters) {
            throw new IllegalStateException("You can't use both splitWith and arity");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> variableArity() {
            throw new IllegalStateException("You can't use both splitWith and variableArity");
        }
    }

    @NotThreadSafe
    public static final class MapArgumentBuilder<K, V>
    extends InternalArgumentBuilder<MapArgumentBuilder<K, V>, Map<K, V>> {
        private final ArgumentBuilder<?, V> valueBuilder;
        private final StringParser<K> keyParser;

        private MapArgumentBuilder(ArgumentBuilder<?, V> builder, StringParser<K> keyParser) {
            this.valueBuilder = builder;
            this.keyParser = keyParser;
            this.copy(builder);
            this.finalizeWith(Functions2.mapValueTransformer(((ArgumentBuilder)builder).finalizer));
            this.finalizeWith(Functions2.unmodifiableMap());
            this.setAsPropertyMap();
        }

        @Override
        StringParsers.InternalStringParser<Map<K, V>> internalParser() {
            Preconditions2.check(this.names().size() > 0, "No leading identifier (otherwise called names), for example -D, specified for property map. Call names(...) to provide it.", new Object[0]);
            if (this.separator().equals(ArgumentBuilder.DEFAULT_SEPARATOR)) {
                this.separator("=");
            } else {
                Preconditions2.check(this.separator().length() > 0, "In a key=value pair a separator of at least one character is required", new Object[0]);
            }
            return new StringParsers.KeyValueParser<K, V>(this.keyParser, this.valueBuilder.internalParser(), ((ArgumentBuilder)this.valueBuilder).limiter, this.defaultValueSupplier(), ((ArgumentBuilder)this.valueBuilder).defaultValueSupplier);
        }

        @Override
        Describer<? super Map<K, V>> defaultValueDescriber() {
            Describer overriddenDescriber = super.defaultValueDescriber();
            if (overriddenDescriber != null) {
                return overriddenDescriber;
            }
            Describer<V> valueDescriber = this.valueBuilder.defaultValueDescriber();
            if (valueDescriber != null) {
                Describer mapDescriber = Describers.mapDescriber(valueDescriber, this.separator());
                return mapDescriber;
            }
            return Describers.mapDescriber(Describers.toStringDescriber(), this.separator());
        }

        @Override
        @Deprecated
        public RepeatedArgumentBuilder<Map<K, V>> repeated() {
            throw new IllegalStateException("You'll need to call repeated before asPropertyMap");
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<Map<K, V>> splitWith(String valueSeparator) {
            throw new IllegalStateException("You'll need to call splitWith before asPropertyMap");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Map<K, V>> arity(int nrOfParameters) {
            throw new IllegalStateException("You'll need to call arity before asPropertyMap");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Map<K, V>> variableArity() {
            throw new IllegalStateException("asPropertyMap is already of variable arity");
        }

        @Override
        public MapArgumentBuilder<K, V> defaultValue(Map<K, V> defaultKeyValues) {
            return (MapArgumentBuilder)super.defaultValue(new LinkedHashMap<K, V>(defaultKeyValues));
        }
    }

    @NotThreadSafe
    public static final class OptionArgumentBuilder
    extends InternalArgumentBuilder<OptionArgumentBuilder, Boolean> {
        OptionArgumentBuilder() {
            this.defaultValue(false);
        }

        @Override
        StringParsers.InternalStringParser<Boolean> internalParser() {
            return StringParsers.optionParser((Boolean)this.defaultValueSupplier().get());
        }

        @Override
        public OptionArgumentBuilder defaultValue(@Nonnull Boolean value) {
            Objects.requireNonNull(value, "Null is not allowed as a default value for an option argument. An option is either given or it's not. ");
            return (OptionArgumentBuilder)super.defaultValue(value);
        }

        @Override
        public OptionArgumentBuilder names(Iterable<String> argumentNames) {
            Preconditions2.check(!Lists2.isEmpty(argumentNames), "An option requires at least one name, otherwise it wouldn't be useful", new Object[0]);
            return (OptionArgumentBuilder)super.names(argumentNames);
        }

        @Override
        public OptionArgumentBuilder names(String ... argumentNames) {
            Preconditions2.check(argumentNames.length >= 1, "An option requires at least one name, otherwise it wouldn't be useful", new Object[0]);
            return (OptionArgumentBuilder)super.names(argumentNames);
        }

        @Override
        @Deprecated
        public OptionArgumentBuilder required() {
            throw new IllegalStateException("An optional flag can't be requried");
        }

        @Override
        @Deprecated
        public OptionArgumentBuilder separator(String aSeparator) {
            throw new IllegalStateException("A seperator for an optional flag isn't supported as an optional flag can't be assigned a value");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Boolean> arity(int numberOfParameters) {
            throw new IllegalStateException("An optional flag can't have any other arity than zero");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<Boolean> variableArity() {
            throw new IllegalStateException("An optional flag can't have any other arity than zero");
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<Boolean> splitWith(String valueSeparator) {
            throw new IllegalStateException("An optional flag can't be split as it has no value that is parsed");
        }
    }

    @NotThreadSafe
    public static final class RepeatedArgumentBuilder<T>
    extends ListArgumentBuilder<RepeatedArgumentBuilder<T>, T> {
        private RepeatedArgumentBuilder(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder) {
            super(new StringParsers.RepeatedArgumentParser<T>(builder.internalParser()));
            this.copy(builder);
            this.copyAsListBuilder(builder, 1);
            this.allowRepeatedArguments();
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> arity(int numberOfParameters) {
            throw new IllegalStateException("Programmer Error. Call arity(...) before repeated()");
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<List<T>> variableArity() {
            throw new IllegalStateException("Programmer Error. Call variableArity(...) before repeated()");
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<List<T>> splitWith(String valueSeparator) {
            throw new IllegalStateException("call splitWith(String) before repeated()");
        }
    }

    @NotThreadSafe
    public static final class ArityArgumentBuilder<T>
    extends ListArgumentBuilder<ArityArgumentBuilder<T>, T> {
        private ArityArgumentBuilder(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder, int arity) {
            super(new StringParsers.FixedArityParser<T>(builder.internalParser(), arity));
            this.init(builder, arity);
        }

        private ArityArgumentBuilder(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder) {
            super(new StringParsers.VariableArityParser<T>(builder.internalParser()));
            this.init(builder, 1);
        }

        private void init(ArgumentBuilder<? extends ArgumentBuilder<?, T>, T> builder, int nrOfElementsInDefaultValue) {
            this.copy(builder);
            this.copyAsListBuilder(builder, nrOfElementsInDefaultValue);
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<List<T>> splitWith(String valueSeparator) {
            throw new IllegalStateException("splitWith(...) doesn't work with arity/variableArity()");
        }
    }

    private static class ListArgumentBuilder<BUILDER extends ListArgumentBuilder<BUILDER, T>, T>
    extends InternalArgumentBuilder<BUILDER, List<T>> {
        ListArgumentBuilder(StringParsers.InternalStringParser<List<T>> parser) {
            super(parser);
        }

        void copyAsListBuilder(ArgumentBuilder<?, T> builder, int nrOfElementsInDefaultValue) {
            this.finalizeWith(Functions2.listTransformer(((ArgumentBuilder)builder).finalizer));
            this.finalizeWith(Functions2.unmodifiableList());
            this.limitTo(Predicates2.listPredicate(((ArgumentBuilder)builder).limiter));
            if (((ArgumentBuilder)builder).defaultValueSupplier != null) {
                this.defaultValueSupplier(Suppliers2.ofRepeatedElements(((ArgumentBuilder)builder).defaultValueSupplier, nrOfElementsInDefaultValue));
            }
            if (((ArgumentBuilder)builder).defaultValueDescriber != null) {
                this.defaultValueDescriber(Describers.listDescriber(((ArgumentBuilder)builder).defaultValueDescriber));
            }
        }
    }

    @NotThreadSafe
    public static final class CommandBuilder
    extends InternalArgumentBuilder<CommandBuilder, ParsedArguments> {
        CommandBuilder(Command command) {
            super(command);
        }

        @Override
        @Deprecated
        public CommandBuilder required() {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValue(ParsedArguments defaultValue) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValueSupplier(Supplier<? extends ParsedArguments> defaultValueSupplier) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValueDescription(String defaultValueDescription) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder defaultValueDescriber(Describer<? super ParsedArguments> defaultValueDescriber) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public CommandBuilder limitTo(Predicate<? super ParsedArguments> limiter) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public SplitterArgumentBuilder<ParsedArguments> splitWith(String valueSeparator) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<ParsedArguments> arity(int arity) {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        public ArityArgumentBuilder<ParsedArguments> variableArity() {
            throw new IllegalStateException();
        }
    }

    static final class SimpleArgumentBuilder<T>
    extends InternalArgumentBuilder<SimpleArgumentBuilder<T>, T> {
        SimpleArgumentBuilder(StringParsers.InternalStringParser<T> parser) {
            super(parser);
        }
    }

    private static abstract class InternalArgumentBuilder<BUILDER extends InternalArgumentBuilder<BUILDER, T>, T>
    extends ArgumentBuilder<BUILDER, T> {
        static final StringParser<?> MARKER = new StringParsers.StringParserBridge<String>(StringParsers.stringParser());

        InternalArgumentBuilder() {
        }

        InternalArgumentBuilder(StringParsers.InternalStringParser<T> parser) {
            super(parser);
        }

        @Override
        protected StringParser<T> parser() {
            return MARKER;
        }
    }

    @NotThreadSafe
    public static final class DefaultArgumentBuilder<T>
    extends ArgumentBuilder<DefaultArgumentBuilder<T>, T> {
        private final StringParser<T> parser;

        DefaultArgumentBuilder(StringParser<T> aParser) {
            this.parser = Objects.requireNonNull(aParser);
        }

        @Override
        protected StringParser<T> parser() {
            return this.parser;
        }
    }
}

