/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import se.softhouse.common.strings.StringsUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.Usage;

@NotThreadSafe
public abstract class ArgumentException
extends RuntimeException {
    private Usage usage = null;
    private String usedArgumentName = null;
    private String usageReferenceName = null;
    private static final long serialVersionUID = 1L;

    protected ArgumentException() {
    }

    public final ArgumentException andCause(Throwable cause) {
        this.initCause(Objects.requireNonNull(cause));
        return this;
    }

    public final Usage getMessageAndUsage() {
        String message = this.getMessage(this.usedArgumentName) + this.usageReference() + StringsUtil.NEWLINE + StringsUtil.NEWLINE;
        return this.getUsage().withErrorMessage(message);
    }

    protected abstract String getMessage(String var1);

    @Override
    public final String getMessage() {
        return this.getMessage(this.usedArgumentName);
    }

    private Usage getUsage() {
        Objects.requireNonNull(this.usage, "No originParser set for ArgumentException. No usage available.");
        return this.usage;
    }

    final ArgumentException withUsage(Usage theUsage) {
        if (this.usage != null) {
            return this;
        }
        this.usage = theUsage;
        return this;
    }

    final ArgumentException withUsedArgumentName(String argumentNameThatTriggeredMe) {
        this.usedArgumentName = argumentNameThatTriggeredMe;
        return this;
    }

    void withUsageReference(String usageReference) {
        this.usageReferenceName = Objects.requireNonNull(usageReference);
    }

    ArgumentException withUsageReference(Argument<?> usageReference) {
        if (this.usageReferenceName != null) {
            return this;
        }
        this.usageReferenceName = String.format(". See usage for %s for proper values.", usageReference);
        return this;
    }

    private String usageReference() {
        return this.usageReferenceName;
    }
}

