/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Lists2;
import se.softhouse.common.strings.Describers;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.Command;
import se.softhouse.jargo.StringParser;
import se.softhouse.jargo.StringParsers;

@Immutable
public final class Arguments {
    private Arguments() {
    }

    public static Argument<?> helpArgument(String mandatoryName, String ... optionalNames) {
        return ((ArgumentBuilder.SimpleArgumentBuilder)new ArgumentBuilder.SimpleArgumentBuilder<String>(StringParsers.HelpParser.INSTANCE).names(Lists2.asList(mandatoryName, optionalNames))).build();
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<Boolean> booleanArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.booleanParser()).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<Byte> byteArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.byteParser()).defaultValueDescriber(Describers.numberDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<Short> shortArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.shortParser()).defaultValueDescriber(Describers.numberDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<Integer> integerArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.integerParser()).defaultValueDescriber(Describers.numberDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<Long> longArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.longParser()).defaultValueDescriber(Describers.numberDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<BigInteger> bigIntegerArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.bigIntegerParser()).defaultValueDescriber(Describers.numberDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<BigDecimal> bigDecimalArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.bigDecimalParser()).defaultValueDescriber(Describers.numberDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<Character> charArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.charParser()).defaultValueDescriber(Describers.characterDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<String> stringArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.stringParser()).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.DefaultArgumentBuilder<File> fileArgument(String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.fileParser()).defaultValueDescriber(Describers.fileDescriber())).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.OptionArgumentBuilder optionArgument(String mandatoryName, String ... optionalNames) {
        return ((ArgumentBuilder.OptionArgumentBuilder)new ArgumentBuilder.OptionArgumentBuilder().defaultValueDescriber(Describers.booleanAsEnabledDisabled())).names(Lists2.asList(mandatoryName, optionalNames));
    }

    @CheckReturnValue
    @Nonnull
    public static <T extends Enum<T>> ArgumentBuilder.DefaultArgumentBuilder<T> enumArgument(Class<T> enumToHandle, String ... names) {
        return (ArgumentBuilder.DefaultArgumentBuilder)Arguments.withParser(StringParsers.enumParser(enumToHandle)).names(names);
    }

    @CheckReturnValue
    @Nonnull
    public static ArgumentBuilder.CommandBuilder command(Command command) {
        return (ArgumentBuilder.CommandBuilder)((ArgumentBuilder.CommandBuilder)new ArgumentBuilder.CommandBuilder(command).names(command.commandName())).description(command);
    }

    @CheckReturnValue
    @Nonnull
    public static <T> ArgumentBuilder.DefaultArgumentBuilder<T> withParser(StringParser<T> parser) {
        return new ArgumentBuilder.DefaultArgumentBuilder<T>(parser);
    }
}

