/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Preconditions2;
import se.softhouse.common.guavaextensions.Predicates2;
import se.softhouse.jargo.Argument;

@Immutable
public final class ParsedArguments {
    @Nonnull
    private final Map<Argument<?>, Object> parsedArguments = new LinkedHashMap();
    @Nonnull
    private final Set<Argument<?>> allArguments;
    private int indexedArgumentsParsed = 0;

    ParsedArguments(Set<Argument<?>> arguments) {
        this.allArguments = arguments;
    }

    @Nullable
    @CheckReturnValue
    public <T> T get(Argument<T> argumentToFetch) {
        if (!this.wasGiven(argumentToFetch)) {
            Preconditions2.check(this.allArguments.contains(argumentToFetch), "%s was not found in this result at all. Did you perhaps forget to add it to withArguments(...)?", argumentToFetch);
            return argumentToFetch.defaultValue();
        }
        return this.getValue(argumentToFetch);
    }

    public boolean wasGiven(Argument<?> argument) {
        return this.parsedArguments.containsKey(Objects.requireNonNull(argument));
    }

    public String toString() {
        return this.parsedArguments.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedArguments)) {
            return false;
        }
        return this.parsedArguments.equals(((ParsedArguments)other).parsedArguments);
    }

    public int hashCode() {
        return this.parsedArguments.hashCode();
    }

    <T> void put(Argument<T> definition, @Nullable T value) {
        if (definition.isIndexed()) {
            ++this.indexedArgumentsParsed;
        }
        this.parsedArguments.put(definition, value);
    }

    <T> void finalize(Argument<T> definition) {
        T value = this.getValue(definition);
        T finalizedValue = definition.finalizer().apply(value);
        this.put(definition, finalizedValue);
    }

    <T> T getValue(Argument<T> definition) {
        Object value = this.parsedArguments.get(definition);
        return (T)value;
    }

    Collection<Argument<?>> requiredArgumentsLeft() {
        return this.allArguments.stream().filter(Argument.IS_REQUIRED.and(Predicates2.in(this.parsedArguments.keySet()).negate())).collect(Collectors.toList());
    }

    int indexedArgumentsParsed() {
        return this.indexedArgumentsParsed;
    }

    Set<Argument<?>> parsedArguments() {
        return this.parsedArguments.keySet();
    }

    Set<String> nonParsedArguments() {
        HashSet<String> validArguments = new HashSet<String>(this.allArguments.size());
        for (Argument<?> argument : this.allArguments) {
            boolean wasGiven = this.wasGiven(argument);
            if (wasGiven && !argument.isAllowedToRepeat()) continue;
            for (String name : argument.names()) {
                if (argument.separator().equals(" ") || argument.isPropertyMap()) {
                    validArguments.add(name);
                    continue;
                }
                validArguments.add(name + argument.separator());
            }
        }
        return validArguments;
    }
}

