/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.classes.Classes;
import se.softhouse.common.strings.Describable;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.StringsUtil;

@Immutable
final class ProgramInformation {
    private final Describable programName;
    private final String programDescription;
    static final ProgramInformation AUTO = new ProgramInformation(Describables.cache(new Describable(){

        @Override
        public String description() {
            return Classes.mainClassName();
        }
    }), "");

    private ProgramInformation(Describable programName, String programDescription) {
        this.programName = programName;
        this.programDescription = programDescription;
    }

    @CheckReturnValue
    static ProgramInformation withProgramName(String programName) {
        return new ProgramInformation(Describables.withString(programName), "");
    }

    @CheckReturnValue
    ProgramInformation programDescription(String aProgramDescription) {
        Objects.requireNonNull(aProgramDescription);
        return new ProgramInformation(this.programName, StringsUtil.NEWLINE + aProgramDescription + StringsUtil.NEWLINE);
    }

    @CheckReturnValue
    ProgramInformation programName(String aProgramName) {
        return new ProgramInformation(Describables.withString(aProgramName), this.programDescription);
    }

    String programName() {
        return this.programName.description();
    }

    String programDescription() {
        return this.programDescription;
    }

    public String toString() {
        return this.programName() + ":" + this.programDescription();
    }
}

