/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import se.softhouse.common.guavaextensions.Preconditions2;
import se.softhouse.common.guavaextensions.Predicates2;
import se.softhouse.common.numbers.NumberType;
import se.softhouse.common.strings.Describables;
import se.softhouse.common.strings.StringBuilders;
import se.softhouse.common.strings.StringsUtil;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.ArgumentExceptions;
import se.softhouse.jargo.CommandLineParserInstance;
import se.softhouse.jargo.StringParser;

@Immutable
public final class StringParsers {
    private StringParsers() {
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<String> stringParser() {
        return StringStringParser.STRING;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<Boolean> booleanParser() {
        return BooleanParser.INSTANCE;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<File> fileParser() {
        return FileParser.INSTANCE;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<Character> charParser() {
        return CharParser.INSTANCE;
    }

    @CheckReturnValue
    @Nonnull
    public static <T extends Enum<T>> StringParser<T> enumParser(Class<T> enumToHandle) {
        return new EnumParser(enumToHandle);
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<Byte> byteParser() {
        return NumberParser.BYTE;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<Short> shortParser() {
        return NumberParser.SHORT;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<Integer> integerParser() {
        return NumberParser.INTEGER;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<Long> longParser() {
        return NumberParser.LONG;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<BigInteger> bigIntegerParser() {
        return NumberParser.BIG_INTEGER;
    }

    @CheckReturnValue
    @Nonnull
    public static StringParser<BigDecimal> bigDecimalParser() {
        return NumberParser.BIG_DECIMAL;
    }

    @Nonnull
    @CheckReturnValue
    public static <T> Function<String, T> asFunction(StringParser<T> parser, Locale localeToUse) {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(localeToUse);
        return input -> parser.parse((String)input, localeToUse);
    }

    @CheckReturnValue
    @Nonnull
    static InternalStringParser<Boolean> optionParser(boolean defaultValue) {
        if (defaultValue) {
            return OptionParser.DEFAULT_TRUE;
        }
        return OptionParser.DEFAULT_FALSE;
    }

    static final class StringParserBridge<T>
    extends InternalStringParser<T>
    implements StringParser<T> {
        private final StringParser<T> stringParser;

        StringParserBridge(StringParser<T> parserToBridge) {
            this.stringParser = parserToBridge;
        }

        @Override
        T parse(CommandLineParserInstance.ArgumentIterator arguments, T previousOccurance, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            if (!arguments.hasNext()) {
                throw ArgumentExceptions.forMissingParameter(argumentSettings);
            }
            return this.parse(arguments.next(), locale);
        }

        @Override
        String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
            return this.descriptionOfValidValues(locale);
        }

        @Override
        String metaDescription(Argument<?> argumentSettings) {
            return this.metaDescription();
        }

        @Override
        public T parse(String argument, Locale locale) throws ArgumentException {
            return this.stringParser.parse(argument, locale);
        }

        @Override
        public String descriptionOfValidValues(Locale locale) {
            return this.stringParser.descriptionOfValidValues(locale);
        }

        @Override
        public String metaDescription() {
            return this.stringParser.metaDescription();
        }

        @Override
        public T defaultValue() {
            return this.stringParser.defaultValue();
        }

        public String toString() {
            return this.descriptionOfValidValues(Locale.US);
        }
    }

    static final class KeyValueParser<K, V>
    extends InternalStringParser<Map<K, V>> {
        @Nonnull
        private final InternalStringParser<V> valueParser;
        @Nonnull
        private final StringParser<K> keyParser;
        @Nonnull
        private final Predicate<? super V> valueLimiter;
        @Nonnull
        private final Supplier<? extends Map<K, V>> defaultMap;

        KeyValueParser(StringParser<K> keyParser, InternalStringParser<V> valueParser, Predicate<? super V> valueLimiter, @Nullable Supplier<? extends Map<K, V>> defaultMap, final @Nullable Supplier<? extends V> defaultValue) {
            this.valueParser = valueParser;
            this.keyParser = keyParser;
            this.valueLimiter = valueLimiter;
            this.defaultMap = defaultMap == null ? new Supplier<Map<K, V>>(){

                @Override
                public Map<K, V> get() {
                    if (defaultValue != null) {
                        return new LinkedHashMap<K, V>(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public V get(Object key) {
                                if (super.containsKey(key)) {
                                    return super.get(key);
                                }
                                return defaultValue.get();
                            }
                        };
                    }
                    return new LinkedHashMap();
                }
            } : defaultMap;
        }

        @Override
        Map<K, V> parse(CommandLineParserInstance.ArgumentIterator arguments, Map<K, V> previousMap, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            Map<K, V> map = previousMap;
            if (map == null) {
                map = this.defaultValue();
            }
            String keyValue = arguments.next();
            String key = this.getKey(keyValue, argumentSettings);
            K parsedKey = this.keyParser.parse(key, locale);
            Object oldValue = map.get(parsedKey);
            if (this.valueParser.parameterArity() != Argument.ParameterArity.NO_ARGUMENTS) {
                arguments.setNextArgumentTo(this.getValue(key, keyValue, argumentSettings));
            }
            V parsedValue = this.valueParser.parse(arguments, oldValue, argumentSettings, locale);
            try {
                if (!this.valueLimiter.test(parsedValue)) {
                    throw ArgumentExceptions.withMessage(Describables.format("Invalid value for key '%s': '%s' is not %s", parsedKey, parsedValue, this.valueLimiter));
                }
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptions.wrapException(e);
            }
            map.put(parsedKey, parsedValue);
            return map;
        }

        private String getKey(String keyValue, Argument<?> argumentSettings) throws ArgumentException {
            if (this.valueParser.parameterArity() == Argument.ParameterArity.NO_ARGUMENTS) {
                return keyValue;
            }
            String separator = argumentSettings.separator();
            int keyEndIndex = keyValue.indexOf(separator);
            if (keyEndIndex == -1) {
                throw ArgumentExceptions.withMessage(Describables.format("'%s%s' is missing an assignment operator(%s)", argumentSettings, keyValue, separator));
            }
            return keyValue.substring(0, keyEndIndex);
        }

        private String getValue(String key, String keyValue, Argument<?> argumentSettings) {
            return keyValue.substring(key.length() + argumentSettings.separator().length());
        }

        @Override
        public String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
            String keyMeta = '\"' + this.keyParser.metaDescription() + '\"';
            String valueMeta = '\"' + this.valueParser.metaDescription(argumentSettings) + '\"';
            String keyDescription = this.keyParser.descriptionOfValidValues(locale);
            String valueDescription = this.valueLimiter != Predicates2.alwaysTrue() ? this.valueLimiter.toString() : this.valueParser.descriptionOfValidValues(argumentSettings, locale);
            return "where " + keyMeta + " is " + keyDescription + " and " + valueMeta + " is " + valueDescription;
        }

        @Override
        public Map<K, V> defaultValue() {
            return this.defaultMap.get();
        }

        @Override
        String metaDescription(Argument<?> argumentSettings) {
            String keyMeta = this.keyParser.metaDescription();
            String separator = argumentSettings.separator();
            String valueMeta = this.valueParser.metaDescription(argumentSettings);
            return keyMeta + separator + valueMeta;
        }
    }

    static final class RepeatedArgumentParser<T>
    extends ListParser<T> {
        RepeatedArgumentParser(InternalStringParser<T> parser) {
            super(parser);
        }

        @Override
        List<T> parse(CommandLineParserInstance.ArgumentIterator arguments, List<T> previouslyCreatedList, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            Object parsedValue = this.elementParser().parse(arguments, null, argumentSettings, locale);
            List<T> listToStoreRepeatedValuesIn = previouslyCreatedList;
            if (listToStoreRepeatedValuesIn == null) {
                listToStoreRepeatedValuesIn = new LinkedList<T>();
            }
            listToStoreRepeatedValuesIn.add(parsedValue);
            return listToStoreRepeatedValuesIn;
        }
    }

    static final class StringSplitterParser<T>
    extends ListParser<T> {
        @Nonnull
        private final String valueSeparator;
        @Nonnull
        private final Pattern splitter;

        StringSplitterParser(String valueSeparator, InternalStringParser<T> parser) {
            super(parser);
            Preconditions2.check(!valueSeparator.isEmpty(), "Splitting with an empty string is not supported", new Object[0]);
            this.valueSeparator = valueSeparator;
            this.splitter = Pattern.compile(valueSeparator);
        }

        @Override
        List<T> parse(CommandLineParserInstance.ArgumentIterator arguments, List<T> oldValue, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            if (!arguments.hasNext()) {
                throw ArgumentExceptions.forMissingParameter(argumentSettings);
            }
            String values = arguments.next();
            ArrayList<Object> result = new ArrayList<Object>();
            for (String value : this.splitter.split(values)) {
                if ((value = value.trim()).isEmpty()) continue;
                CommandLineParserInstance.ArgumentIterator argument = CommandLineParserInstance.ArgumentIterator.forArguments(Arrays.asList(value));
                Object parsedValue = this.elementParser().parse(argument, null, argumentSettings, locale);
                result.add(parsedValue);
            }
            return result;
        }

        @Override
        String metaDescriptionInLeftColumn(Argument<?> argumentSettings) {
            String metaDescriptionForValue = this.metaDescription(argumentSettings);
            return metaDescriptionForValue + this.valueSeparator + metaDescriptionForValue + this.valueSeparator + "...";
        }
    }

    static final class VariableArityParser<T>
    extends ListParser<T> {
        VariableArityParser(InternalStringParser<T> parser) {
            super(parser);
        }

        @Override
        List<T> parse(CommandLineParserInstance.ArgumentIterator arguments, List<T> list, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            ArrayList<Object> parsedArguments = new ArrayList<Object>(arguments.nrOfRemainingArguments());
            while (arguments.hasNext()) {
                Object parsedValue = this.elementParser().parse(arguments, null, argumentSettings, locale);
                parsedArguments.add(parsedValue);
            }
            return parsedArguments;
        }

        @Override
        String metaDescriptionInLeftColumn(Argument<?> argumentSettings) {
            String metaDescriptionForValue = this.metaDescription(argumentSettings);
            return metaDescriptionForValue + " ...";
        }

        @Override
        Argument.ParameterArity parameterArity() {
            return Argument.ParameterArity.VARIABLE_AMOUNT;
        }
    }

    static final class FixedArityParser<T>
    extends ListParser<T> {
        private final int arity;

        FixedArityParser(InternalStringParser<T> parser, int arity) {
            super(parser);
            this.arity = arity;
        }

        @Override
        List<T> parse(CommandLineParserInstance.ArgumentIterator arguments, List<T> list, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            ArrayList<Object> parsedArguments = new ArrayList<Object>(this.arity);
            for (int i = 0; i < this.arity; ++i) {
                try {
                    Object parsedValue = this.elementParser().parse(arguments, null, argumentSettings, locale);
                    parsedArguments.add(parsedValue);
                    continue;
                }
                catch (ArgumentExceptions.MissingParameterException exception) {
                    throw ArgumentExceptions.forMissingNthParameter(exception, i);
                }
            }
            return parsedArguments;
        }

        @Override
        public List<T> defaultValue() {
            Object defaultValue = this.elementParser().defaultValue();
            ArrayList listFilledWithDefaultValues = new ArrayList(this.arity);
            for (int i = 0; i < this.arity; ++i) {
                listFilledWithDefaultValues.add(defaultValue);
            }
            return listFilledWithDefaultValues;
        }

        @Override
        String metaDescriptionInLeftColumn(Argument<?> argumentSettings) {
            String metaDescriptionForValue = this.metaDescription(argumentSettings);
            return metaDescriptionForValue + StringsUtil.repeat(" " + metaDescriptionForValue, this.arity - 1);
        }
    }

    static abstract class ListParser<T>
    extends InternalStringParser<List<T>> {
        private final InternalStringParser<T> elementParser;

        private ListParser(InternalStringParser<T> elementParser) {
            this.elementParser = elementParser;
        }

        protected final InternalStringParser<T> elementParser() {
            return this.elementParser;
        }

        @Override
        public String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
            return this.elementParser.descriptionOfValidValues(argumentSettings, locale);
        }

        @Override
        String metaDescription(Argument<?> argumentSettings) {
            return this.elementParser.metaDescription(argumentSettings);
        }

        @Override
        public List<T> defaultValue() {
            return Collections.emptyList();
        }

        @Override
        String describeValue(List<T> value) {
            if (value == null) {
                return "null";
            }
            if (value.isEmpty()) {
                return "Empty list";
            }
            Iterator<T> values = value.iterator();
            String firstValue = String.valueOf(values.next());
            StringBuilder sb = StringBuilders.withExpectedSize(value.size() * firstValue.length());
            sb.append(firstValue);
            while (values.hasNext()) {
                sb.append(", ").append(String.valueOf(values.next()));
            }
            return sb.toString();
        }
    }

    static final class RunnableParser
    extends InternalStringParser<Object> {
        final Runnable target;

        RunnableParser(Runnable target) {
            this.target = target;
        }

        @Override
        Object parse(CommandLineParserInstance.ArgumentIterator arguments, Object previousOccurance, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            this.target.run();
            return null;
        }

        @Override
        String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
            return "";
        }

        @Override
        Object defaultValue() {
            return null;
        }

        @Override
        String metaDescription(Argument<?> argumentSettings) {
            return "";
        }
    }

    static final class HelpParser
    extends InternalStringParser<String> {
        static final HelpParser INSTANCE = new HelpParser();

        HelpParser() {
        }

        @Override
        String parse(CommandLineParserInstance.ArgumentIterator arguments, String previousOccurance, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            throw arguments.currentParser().helpFor(arguments, locale);
        }

        @Override
        String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
            return "an argument to print help for";
        }

        @Override
        String defaultValue() {
            return "If no specific parameter is given the whole usage text is given";
        }

        @Override
        String metaDescription(Argument<?> argumentSettings) {
            return "<argument-to-print-help-for>";
        }
    }

    static final class OptionParser
    extends InternalStringParser<Boolean> {
        private static final OptionParser DEFAULT_FALSE = new OptionParser(false);
        private static final OptionParser DEFAULT_TRUE = new OptionParser(true);
        private final Boolean defaultValue;

        private OptionParser(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        Boolean parse(CommandLineParserInstance.ArgumentIterator arguments, Boolean previousOccurance, Argument<?> argumentSettings, Locale locale) throws ArgumentException {
            return this.defaultValue == false;
        }

        @Override
        public Boolean defaultValue() {
            return this.defaultValue;
        }

        @Override
        public String descriptionOfValidValues(Argument<?> argumentSettings, Locale locale) {
            return "";
        }

        @Override
        String metaDescription(Argument<?> argumentSettings) {
            return "";
        }

        @Override
        Argument.ParameterArity parameterArity() {
            return Argument.ParameterArity.NO_ARGUMENTS;
        }
    }

    static abstract class InternalStringParser<T> {
        InternalStringParser() {
        }

        abstract T parse(CommandLineParserInstance.ArgumentIterator var1, @Nullable T var2, Argument<?> var3, Locale var4) throws ArgumentException;

        @Nonnull
        abstract String descriptionOfValidValues(Argument<?> var1, Locale var2);

        @Nullable
        abstract T defaultValue();

        @Nullable
        String describeValue(@Nullable T value) {
            return String.valueOf(value);
        }

        @Nonnull
        abstract String metaDescription(Argument<?> var1);

        String metaDescriptionInLeftColumn(Argument<?> argumentSettings) {
            return this.metaDescription(argumentSettings);
        }

        String metaDescriptionInRightColumn(Argument<?> argumentSettings) {
            return this.metaDescription(argumentSettings);
        }

        Argument.ParameterArity parameterArity() {
            return Argument.ParameterArity.AT_LEAST_ONE_ARGUMENT;
        }
    }

    private static final class NumberParser<N extends Number>
    implements StringParser<N> {
        private static final StringParser<Byte> BYTE = new NumberParser<Byte>(NumberType.BYTE);
        private static final StringParser<Short> SHORT = new NumberParser<Short>(NumberType.SHORT);
        private static final StringParser<Integer> INTEGER = new NumberParser<Integer>(NumberType.INTEGER);
        private static final StringParser<Long> LONG = new NumberParser<Long>(NumberType.LONG);
        private static final StringParser<BigInteger> BIG_INTEGER = new NumberParser<BigInteger>(NumberType.BIG_INTEGER);
        private static final StringParser<BigDecimal> BIG_DECIMAL = new NumberParser<BigDecimal>(NumberType.BIG_DECIMAL);
        private final NumberType<N> type;

        private NumberParser(NumberType<N> type) {
            this.type = type;
        }

        @Override
        public N parse(String argument, Locale locale) throws ArgumentException {
            try {
                return this.type.parse(argument, locale);
            }
            catch (IllegalArgumentException invalidNumber) {
                throw ArgumentExceptions.wrapException(invalidNumber);
            }
        }

        @Override
        public String descriptionOfValidValues(Locale locale) {
            return this.type.descriptionOfValidValues(locale);
        }

        @Override
        public N defaultValue() {
            return this.type.defaultValue();
        }

        @Override
        public String metaDescription() {
            return '<' + this.type.name() + '>';
        }

        public String toString() {
            return this.descriptionOfValidValues(Locale.US);
        }
    }

    private static final class EnumParser<E extends Enum<E>>
    implements StringParser<E> {
        private final Class<E> enumType;
        private static final int AVERAGE_ENUM_NAME_LENGTH = 10;

        private EnumParser(Class<E> enumToHandle) {
            this.enumType = Objects.requireNonNull(enumToHandle);
        }

        @Override
        public E parse(String value, final Locale locale) throws ArgumentException {
            try {
                return Enum.valueOf(this.enumType, value.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException noEnumFoundWithUpperCase) {
                try {
                    return Enum.valueOf(this.enumType, value);
                }
                catch (IllegalArgumentException noEnumFoundWithExactMatch) {
                    throw ArgumentExceptions.withMessage(Describables.format("'%s' is not a valid Option, Expecting one of %s", value, new Object(){

                        public String toString() {
                            return this.descriptionOfValidValues(locale);
                        }
                    }), (Throwable)noEnumFoundWithExactMatch);
                }
            }
        }

        @Override
        public String descriptionOfValidValues(Locale locale) {
            Enum[] enumValues = (Enum[])this.enumType.getEnumConstants();
            StringJoiner joiner = new StringJoiner(" | ", "{", "}");
            Arrays.stream(enumValues).forEach(e -> joiner.add(e.toString()));
            return joiner.toString();
        }

        @Override
        public E defaultValue() {
            return null;
        }

        @Override
        public String metaDescription() {
            return "<" + this.enumType.getSimpleName() + ">";
        }
    }

    private static final class CharParser
    implements StringParser<Character> {
        private static final CharParser INSTANCE = new CharParser();

        private CharParser() {
        }

        @Override
        public Character parse(String value, Locale locale) throws ArgumentException {
            if (value.length() != 1) {
                throw ArgumentExceptions.withMessage(Describables.format("'%s' is not a valid character", value));
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public String descriptionOfValidValues(Locale locale) {
            return "any unicode character";
        }

        @Override
        public Character defaultValue() {
            return Character.valueOf('\u0000');
        }

        @Override
        public String metaDescription() {
            return "<character>";
        }
    }

    private static final class FileParser
    implements StringParser<File> {
        private static final FileParser INSTANCE = new FileParser();

        private FileParser() {
        }

        @Override
        public File parse(String value, Locale locale) {
            return new File(value);
        }

        @Override
        public String descriptionOfValidValues(Locale locale) {
            return "a file path";
        }

        @Override
        public File defaultValue() {
            return new File(".");
        }

        @Override
        public String metaDescription() {
            return "<path>";
        }
    }

    private static final class BooleanParser
    implements StringParser<Boolean> {
        private static final BooleanParser INSTANCE = new BooleanParser();

        private BooleanParser() {
        }

        @Override
        public Boolean parse(String value, Locale locale) {
            return Boolean.valueOf(value);
        }

        @Override
        public String descriptionOfValidValues(Locale locale) {
            return "true or false";
        }

        @Override
        public Boolean defaultValue() {
            return false;
        }

        @Override
        public String metaDescription() {
            return "<boolean>";
        }
    }

    static enum StringStringParser implements StringParser<String>
    {
        STRING{

            @Override
            public String parse(String value, Locale locale) throws ArgumentException {
                return value;
            }
        };


        @Override
        public String descriptionOfValidValues(Locale locale) {
            return "any string";
        }

        @Override
        public String defaultValue() {
            return "";
        }

        @Override
        public String metaDescription() {
            return "<string>";
        }
    }
}

