/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionDSL;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.modules.cache.Cache;
import org.exist.xquery.modules.cache.CacheConfig;
import org.exist.xquery.modules.cache.CacheModule;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.SAXException;

public class CacheFunctions
extends BasicFunction {
    private static final Properties OUTPUT_PROPERTIES = new Properties();
    private static final FunctionParameterSequenceType FS_PARAM_CACHE_NAME;
    private static final FunctionParameterSequenceType FS_PARAM_KEY;
    @Deprecated
    private static final String FS_CACHE_NAME = "cache";
    @Deprecated
    static final FunctionSignature FS_CACHE;
    private static final String FS_CREATE_NAME = "create";
    static final FunctionSignature FS_CREATE_CACHE;
    private static final String FS_NAMES_NAME = "names";
    static final FunctionSignature FS_NAMES;
    private static final String FS_PUT_NAME = "put";
    static final FunctionSignature FS_PUT;
    private static final String FS_LIST_NAME = "list";
    static final FunctionSignature FS_LIST;
    private static final String FS_KEYS_NAME = "keys";
    static final FunctionSignature FS_KEYS;
    private static final String FS_GET_NAME = "get";
    static final FunctionSignature FS_GET;
    private static final String FS_REMOVE_NAME = "remove";
    static final FunctionSignature FS_REMOVE;
    private static final String FS_CLEAR_NAME = "clear";
    static final FunctionSignature[] FS_CLEAR;
    private static final String FS_CLEANUP_NAME = "cleanup";
    static final FunctionSignature FS_CLEANUP;
    private static final String FS_DESTROY_NAME = "destroy";
    static final FunctionSignature FS_DESTROY;

    public CacheFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String cacheName = args.length > 0 ? args[0].itemAt(0).getStringValue() : null;
        switch (this.getName().getLocalPart()) {
            case "cache": {
                if (CacheModule.caches.containsKey(cacheName)) {
                    return args[0];
                }
                this.createCache(cacheName, new CacheConfig());
                return args[0];
            }
            case "create": {
                if (CacheModule.caches.containsKey(cacheName)) {
                    return BooleanValue.FALSE;
                }
                return BooleanValue.valueOf((boolean)this.createCache(cacheName, this.extractCacheConfig((MapType)args[1])));
            }
            case "names": {
                return this.cacheNames();
            }
            case "put": {
                if (!CacheModule.caches.containsKey(cacheName)) {
                    this.createCache(cacheName, new CacheConfig());
                }
                String putKey = this.toMapKey(args[1]);
                Sequence value = args[2];
                return this.put(cacheName, putKey, value);
            }
            case "list": {
                if (!CacheModule.caches.containsKey(cacheName)) {
                    this.createCache(cacheName, new CacheConfig());
                }
                String[] keys = this.toMapKeys(args[1]);
                return this.list(cacheName, keys);
            }
            case "keys": {
                if (!CacheModule.caches.containsKey(cacheName)) {
                    this.createCache(cacheName, new CacheConfig());
                }
                return this.listKeys(cacheName);
            }
            case "get": {
                if (!CacheModule.caches.containsKey(cacheName)) {
                    this.createCache(cacheName, new CacheConfig());
                }
                String getKey = this.toMapKey(args[1]);
                return this.get(cacheName, getKey);
            }
            case "remove": {
                if (!CacheModule.caches.containsKey(cacheName)) {
                    this.createCache(cacheName, new CacheConfig());
                }
                String removeKey = this.toMapKey(args[1]);
                return this.remove(cacheName, removeKey);
            }
            case "clear": {
                if (args.length == 0) {
                    this.clearAll();
                } else if (CacheModule.caches.containsKey(cacheName)) {
                    this.clear(cacheName);
                }
                return Sequence.EMPTY_SEQUENCE;
            }
            case "cleanup": {
                if (CacheModule.caches.containsKey(cacheName)) {
                    this.cleanup(cacheName);
                }
                return Sequence.EMPTY_SEQUENCE;
            }
            case "destroy": {
                Cache oldCache = CacheModule.caches.remove(cacheName);
                if (oldCache != null) {
                    oldCache.clear();
                }
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        throw new XPathException((Expression)this, "No function: " + this.getName() + "#" + this.getSignature().getArgumentCount());
    }

    private CacheConfig extractCacheConfig(MapType configMap) throws XPathException {
        Optional<Long> expireAfterAccess;
        Optional<Long> maximumSize;
        Optional<CacheConfig.Permissions> permissions;
        Sequence permsSeq = configMap.get((AtomicValue)new StringValue("permissions"));
        if (permsSeq != null && permsSeq.getItemCount() > 0) {
            MapType permsMap = (MapType)permsSeq.itemAt(0);
            Optional<String> putGroup = this.getStringValue("put-group", (AbstractMapType)permsMap);
            Optional<String> getGroup = this.getStringValue("get-group", (AbstractMapType)permsMap);
            Optional<String> removeGroup = this.getStringValue("remove-group", (AbstractMapType)permsMap);
            Optional<String> clearGroup = this.getStringValue("clear-group", (AbstractMapType)permsMap);
            permissions = Optional.of(new CacheConfig.Permissions(putGroup, getGroup, removeGroup, clearGroup));
        } else {
            permissions = Optional.empty();
        }
        Sequence maximumSizeSeq = configMap.get((AtomicValue)new StringValue("maximumSize"));
        if (maximumSizeSeq != null && maximumSizeSeq.getItemCount() == 1) {
            long l = (Long)maximumSizeSeq.itemAt(0).toJavaObject(Long.class);
            maximumSize = Optional.of(l);
        } else {
            maximumSize = Optional.empty();
        }
        Sequence expireAfterAccessSeq = configMap.get((AtomicValue)new StringValue("expireAfterAccess"));
        if (expireAfterAccessSeq != null && expireAfterAccessSeq.getItemCount() == 1) {
            long l = (Long)expireAfterAccessSeq.itemAt(0).toJavaObject(Long.class);
            expireAfterAccess = Optional.of(l);
        } else {
            expireAfterAccess = Optional.empty();
        }
        return new CacheConfig(permissions, maximumSize, expireAfterAccess);
    }

    private Optional<String> getStringValue(String key, AbstractMapType map) {
        return Optional.ofNullable(map.get((AtomicValue)new StringValue(key))).filter(v -> !v.isEmpty()).flatMap(v -> Optional.ofNullable(((StringValue)v).getStringValue()));
    }

    private boolean createCache(String cacheName, CacheConfig config) {
        Cache newOrExisting = CacheModule.caches.computeIfAbsent(cacheName, key -> new Cache(config));
        return newOrExisting.getConfig() == config;
    }

    private Sequence cacheNames() throws XPathException {
        ValueSequence result = new ValueSequence();
        for (String cacheName : CacheModule.caches.keySet()) {
            result.add((Item)new StringValue(cacheName));
        }
        return result;
    }

    private Sequence put(String cacheName, String key, Sequence value) throws XPathException {
        Optional putGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (putGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getPutGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)putGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to put data into this cache");
        }
        return cache.put(key, value);
    }

    private Sequence list(String cacheName, String[] keys) throws XPathException {
        Optional getGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (getGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getGetGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)getGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to list data in this cache");
        }
        return cache.list(keys);
    }

    private Sequence listKeys(String cacheName) throws XPathException {
        Optional getGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (getGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getGetGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)getGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to list data in this cache");
        }
        return cache.listKeys();
    }

    private Sequence get(String cacheName, String key) throws XPathException {
        Optional getGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (getGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getGetGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)getGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to get data from this cache");
        }
        return cache.get(key);
    }

    private Sequence remove(String cacheName, String key) throws XPathException {
        Optional removeGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (removeGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getRemoveGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)removeGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to remove data from this cache");
        }
        return cache.remove(key);
    }

    private void clearAll() throws XPathException {
        Collection<Cache> caches = CacheModule.caches.values();
        if (!this.context.getEffectiveUser().hasDbaRole()) {
            for (Cache cache : caches) {
                Optional clearGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getClearGroup);
                if (!clearGroup.isPresent() || this.context.getEffectiveUser().hasGroup((String)clearGroup.get())) continue;
                throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to clear data from all caches");
            }
        }
        for (Cache cache : caches) {
            cache.clear();
        }
    }

    private void clear(String cacheName) throws XPathException {
        Optional clearGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (clearGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getClearGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)clearGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to clear data from this cache");
        }
        cache.clear();
    }

    private void cleanup(String cacheName) throws XPathException {
        Optional clearGroup;
        Cache cache = CacheModule.caches.get(cacheName);
        if (!this.context.getEffectiveUser().hasDbaRole() && (clearGroup = cache.getConfig().getPermissions().flatMap(CacheConfig.Permissions::getClearGroup)).isPresent() && !this.context.getEffectiveUser().hasGroup((String)clearGroup.get())) {
            throw new XPathException((Expression)this, CacheModule.INSUFFICIENT_PERMISSIONS, "User does not have the appropriate permissions to clear data from this cache");
        }
        cache.cleanup();
    }

    private String toMapKey(Sequence key) throws XPathException {
        Item item1;
        if (key.getItemCount() == 1 && (item1 = key.itemAt(0)).getType() == 22) {
            return item1.getStringValue();
        }
        return this.serializeKey(key);
    }

    private String[] toMapKeys(Sequence keys) throws XPathException {
        String[] mapKeys = new String[keys.getItemCount()];
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        try {
            serializer.setProperties(OUTPUT_PROPERTIES);
            int i = 0;
            SequenceIterator it = keys.iterate();
            while (it.hasNext()) {
                Item item = it.nextItem();
                try {
                    NodeValue node = (NodeValue)item;
                    mapKeys[i] = serializer.serialize(node);
                }
                catch (ClassCastException e) {
                    mapKeys[i] = item.getStringValue();
                }
                ++i;
            }
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, CacheModule.KEY_SERIALIZATION, (Throwable)e);
        }
        return mapKeys;
    }

    private String serializeKey(Sequence key) throws XPathException {
        StringBuilder builder = new StringBuilder();
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        try {
            serializer.setProperties(OUTPUT_PROPERTIES);
            SequenceIterator i = key.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                try {
                    NodeValue node = (NodeValue)item;
                    builder.append(serializer.serialize(node));
                }
                catch (ClassCastException e) {
                    builder.append(item.getStringValue());
                }
            }
            return builder.toString();
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, CacheModule.KEY_SERIALIZATION, (Throwable)e);
        }
    }

    static {
        OUTPUT_PROPERTIES.setProperty("indent", "no");
        OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        FS_PARAM_CACHE_NAME = FunctionDSL.param((String)"cache-name", (int)22, (String)"The name of the cache");
        FS_PARAM_KEY = FunctionDSL.manyParam((String)"key", (int)12, (String)"The key");
        FS_CACHE = FunctionDSL.deprecated((String)"Deprecated as Caches are now created on demand, or by cache:create($name, $config)", (FunctionSignature)CacheModule.functionSignature(FS_CACHE_NAME, "Get/create a cache using the specified name.", FunctionDSL.returns((int)22, (String)"The name of the cache."), FS_PARAM_CACHE_NAME));
        FS_CREATE_CACHE = CacheModule.functionSignature(FS_CREATE_NAME, "Explicitly create a cache with a specific configuration", FunctionDSL.returns((int)23, (String)"true if the cache was created, false if the cache already exists"), FS_PARAM_CACHE_NAME, FunctionDSL.param((String)"config", (int)102, (String)"A map with configuration for the cache. At present cache LRU and permission groups may be specified, for operations on the cache. `maximumSize` is optional and specifies the maximum number of entries. `expireAfterAccess` is optional and specified the expiry period for infrequently accessed entries (in milliseconds). If a permission group is not specified for an operation, then permissions are not checked for that operation. Should have the format: map { \"maximumSize\": 1000, \"expireAfterAccess\": 120000, \"permissions\": map { \"put-group\": \"group1\", \"get-group\": \"group2\", \"remove-group\": \"group3\", \"clear-group\": \"group4\"} }"));
        FS_NAMES = CacheModule.functionSignature(FS_NAMES_NAME, "Get the names of all current caches", FunctionDSL.returnsOptMany((int)22, (String)"The names of all caches currently in use."), new FunctionParameterSequenceType[0]);
        FS_PUT = CacheModule.functionSignature(FS_PUT_NAME, "Put data with a key into the identified cache. Returns the previous value associated with the key", FunctionDSL.returnsOptMany((int)11, (String)"The previous value associated with the key"), FS_PARAM_CACHE_NAME, FS_PARAM_KEY, FunctionDSL.optManyParam((String)"value", (int)11, (String)"The value"));
        FS_LIST = CacheModule.functionSignature(FS_LIST_NAME, "List all values (for the associated keys) stored in a cache.", FunctionDSL.returnsOptMany((int)11, (String)"The values associated with the keys"), FS_PARAM_CACHE_NAME, FunctionDSL.optManyParam((String)FS_KEYS_NAME, (int)12, (String)"The keys, if none are specified, all values are returned"));
        FS_KEYS = CacheModule.functionSignature(FS_KEYS_NAME, "List all keys stored in a cache. Note this operation is expensive.", FunctionDSL.returnsOptMany((int)22, (String)"The keys in the cache. Note these will be returned in serialized string form, as that is used internally."), FS_PARAM_CACHE_NAME);
        FS_GET = CacheModule.functionSignature(FS_GET_NAME, "Get data from identified global cache by key", FunctionDSL.returnsOptMany((int)11, (String)"The value associated with the key"), FS_PARAM_CACHE_NAME, FS_PARAM_KEY);
        FS_REMOVE = CacheModule.functionSignature(FS_REMOVE_NAME, "Remove data from the identified cache by the key. Returns the value that was previously associated with key", FunctionDSL.returnsOptMany((int)11, (String)"The value that was previously associated with the key"), FS_PARAM_CACHE_NAME, FS_PARAM_KEY);
        FS_CLEAR = CacheModule.functionSignatures(FS_CLEAR_NAME, "Clears all key/values from either all caches or the named cache", FunctionDSL.returnsNothing(), FunctionDSL.arities((FunctionParameterSequenceType[][])new FunctionParameterSequenceType[][]{FunctionDSL.arity((FunctionParameterSequenceType[])new FunctionParameterSequenceType[0]), FunctionDSL.arity((FunctionParameterSequenceType[])new FunctionParameterSequenceType[]{FS_PARAM_CACHE_NAME})}));
        FS_CLEANUP = CacheModule.functionSignature(FS_CLEANUP_NAME, "Eviction policy work of the cache is performed asynchronously. Performs any pending maintenance operations needed by the cache, on the current thread. Typically not needed by users, and only used for testing scenarios. Requires 'clear' permissions.", FunctionDSL.returnsNothing(), FS_PARAM_CACHE_NAME);
        FS_DESTROY = CacheModule.functionSignature(FS_DESTROY_NAME, "Destroys a cache entirely", FunctionDSL.returnsNothing(), FS_PARAM_CACHE_NAME);
    }
}

