/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Base64Decoder;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractCompressFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(AbstractCompressFunction.class);
    protected static final SequenceType SOURCES_PARAM = new FunctionParameterSequenceType("sources", 12, 6, "The sequence of URI's and/or Entrys. If an URI points to a collection then the collection, its resources and sub-collections are zipped recursively. If URI points to file (available only to the DBA role.) then file or directory are zipped. An Entry takes the format <entry name=\"filename.ext\" type=\"collection|uri|binary|xml|text\" method=\"deflate|store\">data</entry>. The method attribute is only effective for the compression:zip function.");
    protected static final SequenceType COLLECTION_HIERARCHY_PARAM = new FunctionParameterSequenceType("use-collection-hierarchy", 23, 2, "Indicates whether the Collection hierarchy (if any) should be preserved in the zip file.");
    protected static final SequenceType STRIP_PREFIX_PARAM = new FunctionParameterSequenceType("strip-prefix", 22, 2, "This prefix is stripped from the Entrys name");
    protected static final SequenceType ENCODING_PARAM = new FunctionParameterSequenceType("encoding", 22, 2, "This encoding to be used for filenames inside the compressed file");

    public AbstractCompressFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    private String removeLeadingOffset(String uri, String stripOffset) {
        if (uri.startsWith(stripOffset)) {
            uri = uri.substring(stripOffset.length());
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    /*
     * Exception decompiling
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compressFromUri(OutputStream os, URI uri, boolean useHierarchy, String stripOffset, String method, String resourceName) throws XPathException {
        try {
            if ("file".equals(uri.getScheme())) {
                if (!this.context.getSubject().hasDbaRole()) {
                    XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
                    logger.error("Invalid user", (Throwable)xPathException);
                    throw xPathException;
                }
                File file = new File(uri.getPath());
                this.compressFile(os, file, useHierarchy, stripOffset, method, resourceName);
                return;
            }
            DocumentImpl doc = null;
            try {
                XmldbURI xmldburi = XmldbURI.create((URI)uri);
                doc = this.context.getBroker().getXMLResource(xmldburi, Lock.LockMode.READ_LOCK);
                if (doc == null) {
                    Collection col = this.context.getBroker().getCollection(xmldburi);
                    if (col == null) throw new XPathException((Expression)this, "Invalid URI: " + uri.toString());
                    this.compressCollection(os, col, useHierarchy, stripOffset);
                    return;
                } else {
                    this.compressResource(os, doc, useHierarchy, stripOffset, method, resourceName);
                }
                return;
            }
            catch (IOException | PermissionDeniedException | LockException | SAXException pde) {
                throw new XPathException((Expression)this, pde.getMessage());
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, e.getMessage());
        }
    }

    private void compressFile(OutputStream os, File file, boolean useHierarchy, String stripOffset, String method, String name) throws IOException {
        if (file.isFile()) {
            Object entry = null;
            CRC32 chksum = new CRC32();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                entry = name != null ? this.newEntry(name) : (useHierarchy ? this.newEntry(this.removeLeadingOffset(file.getPath(), stripOffset)) : this.newEntry(file.getName()));
                try (FileInputStream is = new FileInputStream(file);){
                    byte[] data = new byte[16384];
                    int len = -1;
                    while ((len = ((InputStream)is).read(data, 0, data.length)) > 0) {
                        baos.write(data, 0, len);
                    }
                }
                byte[] value = baos.toByteArray();
                if (entry instanceof ZipEntry && "store".equals(method)) {
                    ((ZipEntry)entry).setMethod(0);
                    chksum.update(value);
                    ((ZipEntry)entry).setCrc(chksum.getValue());
                    ((ZipEntry)entry).setSize(value.length);
                }
                this.putEntry(os, entry);
                os.write(value);
                this.closeEntry(os);
            }
        }
        for (String i : file.list()) {
            this.compressFile(os, new File(file, i), useHierarchy, stripOffset, method, null);
        }
    }

    private void compressElement(OutputStream os, Element element, boolean useHierarchy, String stripOffset) throws XPathException {
        String ns = element.getNamespaceURI();
        if (!(element.getNodeName().equals("entry") || ns != null && ns.length() > 0)) {
            throw new XPathException((Expression)this, "Item must be type of xs:anyURI or element entry.");
        }
        if (element.getChildNodes().getLength() > 1) {
            throw new XPathException((Expression)this, "Entry content is not valid XML fragment.");
        }
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        if ("uri".equals(type)) {
            this.compressFromUri(os, URI.create(element.getFirstChild().getNodeValue()), useHierarchy, stripOffset, element.getAttribute("method"), name);
            return;
        }
        name = useHierarchy ? this.removeLeadingOffset(name, stripOffset) : name.substring(name.lastIndexOf("/") + 1);
        if ("collection".equals(type)) {
            name = name + "/";
        }
        Object entry = null;
        try {
            entry = this.newEntry(name);
            if (!"collection".equals(type)) {
                byte[] value;
                CRC32 chksum = new CRC32();
                Node content = element.getFirstChild();
                if (content == null) {
                    value = new byte[]{};
                } else if (content.getNodeType() == 3) {
                    String text = content.getNodeValue();
                    Base64Decoder dec = new Base64Decoder();
                    if ("binary".equals(type)) {
                        dec.translate((CharSequence)text);
                        value = dec.getByteArray();
                    } else {
                        value = text.getBytes();
                    }
                } else {
                    Serializer serializer = this.context.getBroker().getSerializer();
                    serializer.setUser(this.context.getUser());
                    serializer.setProperty("omit-xml-declaration", (Object)"no");
                    this.getDynamicSerializerOptions(serializer);
                    value = serializer.serialize((NodeValue)content).getBytes();
                }
                if (entry instanceof ZipEntry && "store".equals(element.getAttribute("method"))) {
                    ((ZipEntry)entry).setMethod(0);
                    chksum.update(value);
                    ((ZipEntry)entry).setCrc(chksum.getValue());
                    ((ZipEntry)entry).setSize(value.length);
                }
                this.putEntry(os, entry);
                os.write(value);
            }
        }
        catch (IOException | SAXException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            if (entry != null) {
                try {
                    this.closeEntry(os);
                }
                catch (IOException ioe) {
                    throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    private void getDynamicSerializerOptions(Serializer serializer) throws SAXException {
        Option option = this.context.getOption(Option.SERIALIZE_QNAME);
        if (option != null) {
            String[] params;
            for (String param : params = option.tokenizeContents()) {
                String[] kvp = Option.parseKeyValuePair((String)param);
                serializer.setProperty(kvp[0], (Object)kvp[1]);
            }
        }
    }

    private void compressResource(OutputStream os, DocumentImpl doc, boolean useHierarchy, String stripOffset, String method, String name) throws IOException, SAXException {
        Object entry = null;
        byte[] value = new byte[]{};
        CRC32 chksum = new CRC32();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (name != null) {
            entry = this.newEntry(name);
        } else if (useHierarchy) {
            String docCollection = doc.getCollection().getURI().toString();
            XmldbURI collection = XmldbURI.create((String)this.removeLeadingOffset(docCollection, stripOffset));
            entry = this.newEntry(collection.append(doc.getFileURI()).toString());
        } else {
            entry = this.newEntry(doc.getFileURI().toString());
        }
        if (doc.getResourceType() == 0) {
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.setUser(this.context.getUser());
            serializer.setProperty("omit-xml-declaration", (Object)"no");
            this.getDynamicSerializerOptions(serializer);
            String strDoc = serializer.serialize(doc);
            value = strDoc.getBytes();
        } else if (doc.getResourceType() == 1) {
            InputStream is = this.context.getBroker().getBinaryResource((BinaryDocument)doc);
            byte[] data = new byte[16384];
            int len = 0;
            while ((len = is.read(data, 0, data.length)) > 0) {
                baos.write(data, 0, len);
            }
            is.close();
            value = baos.toByteArray();
        }
        if (entry instanceof ZipEntry && "store".equals(method)) {
            ((ZipEntry)entry).setMethod(0);
            chksum.update(value);
            ((ZipEntry)entry).setCrc(chksum.getValue());
            ((ZipEntry)entry).setSize(value.length);
        }
        this.putEntry(os, entry);
        os.write(value);
        this.closeEntry(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressCollection(OutputStream os, Collection col, boolean useHierarchy, String stripOffset) throws IOException, SAXException, LockException, PermissionDeniedException {
        DefaultDocumentSet childDocs = new DefaultDocumentSet();
        col.getDocuments(this.context.getBroker(), (MutableDocumentSet)childDocs);
        Iterator itChildDocs = childDocs.getDocumentIterator();
        while (itChildDocs.hasNext()) {
            DocumentImpl childDoc = (DocumentImpl)itChildDocs.next();
            childDoc.getUpdateLock().acquire(Lock.LockMode.READ_LOCK);
            try {
                this.compressResource(os, childDoc, useHierarchy, stripOffset, "", null);
            }
            finally {
                childDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        Iterator itChildCols = col.collectionIterator(this.context.getBroker());
        while (itChildCols.hasNext()) {
            XmldbURI childColURI = (XmldbURI)itChildCols.next();
            Collection childCol = this.context.getBroker().getCollection(col.getURI().append(childColURI));
            this.compressCollection(os, childCol, useHierarchy, stripOffset);
        }
    }

    protected abstract OutputStream stream(ByteArrayOutputStream var1, Charset var2);

    protected abstract Object newEntry(String var1);

    protected abstract void putEntry(Object var1, Object var2) throws IOException;

    protected abstract void closeEntry(Object var1) throws IOException;
}

