/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.counter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.RawBackupSupport;
import org.exist.util.FileUtils;

public class Counters
implements RawBackupSupport {
    private static final Logger LOG = LogManager.getLogger(Counters.class);
    private static volatile Counters instance;
    public static final String COUNTERSTORE = "counters";
    public static final String DELIMITER = ";";
    private Path store = null;
    private Map<String, Long> counters = new Hashtable<String, Long>();

    private Counters(Optional<Path> dataDir) throws EXistException {
        this.store = FileUtils.resolve(dataDir, (String)COUNTERSTORE);
        this.loadStore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadStore() throws EXistException {
        try {
            if (!Files.exists(this.store, new LinkOption[0])) return;
            try (BufferedReader br = Files.newBufferedReader(this.store, StandardCharsets.UTF_8);){
                String line = "";
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split(DELIMITER);
                    try {
                        this.counters.put(tokens[0], Long.parseLong(tokens[1]));
                    }
                    catch (NumberFormatException e) {
                        throw new EXistException("Corrupt counter store file: " + this.store.toAbsolutePath().toString());
                        return;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new EXistException("IOException occurred when reading counter store file.");
        }
    }

    public static Counters getInstance(Path dataDir) throws EXistException {
        if (instance == null) {
            LOG.debug("Initializing counters.");
            instance = new Counters(Optional.ofNullable(dataDir));
        }
        return instance;
    }

    public static Counters getInstance() throws EXistException {
        return Counters.getInstance(null);
    }

    public long createCounter(String counterName) throws EXistException {
        return this.createCounter(counterName, 0L);
    }

    public synchronized long createCounter(String counterName, long initValue) throws EXistException {
        if (this.counters.containsKey(counterName)) {
            return this.counters.get(counterName);
        }
        this.counters.put(counterName, initValue);
        try {
            this.serializeTable();
        }
        catch (IOException e) {
            throw new EXistException("Unable to save to counter store file.", (Throwable)e);
        }
        return this.counters.get(counterName);
    }

    public synchronized boolean destroyCounter(String counterName) throws EXistException {
        if (this.counters.containsKey(counterName)) {
            this.counters.remove(counterName);
            try {
                this.serializeTable();
            }
            catch (IOException e) {
                throw new EXistException("Unable to remove counter from counter store file.", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public synchronized long nextValue(String counterName) throws EXistException {
        if (!this.counters.containsKey(counterName)) {
            return -1L;
        }
        long c = this.counters.get(counterName);
        this.counters.put(counterName, ++c);
        try {
            this.serializeTable();
        }
        catch (IOException e) {
            throw new EXistException("Unable to save to counter store file.", (Throwable)e);
        }
        return c;
    }

    public Set<String> availableCounters() {
        return this.counters.keySet();
    }

    private synchronized void serializeTable() throws IOException {
        try (PrintWriter pw = new PrintWriter(Files.newBufferedWriter(this.store, StandardCharsets.UTF_8, new OpenOption[0]));){
            for (Map.Entry<String, Long> counter : this.counters.entrySet()) {
                pw.println(counter.getKey() + DELIMITER + counter.getValue().toString());
            }
        }
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        if (!Files.exists(this.store, new LinkOption[0])) {
            return;
        }
        try {
            OutputStream os = backup.newEntry(FileUtils.fileName((Path)this.store));
            Files.copy(this.store, os);
        }
        finally {
            backup.closeEntry();
        }
    }
}

