/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FnFormatDates;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FormatDateFunction
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FormatDateFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("format-date", "http://exist-db.org/xquery/datetime", "datetime"), "Returns a xs:string of the xs:date formatted according to the SimpleDateFormat format.", new SequenceType[]{new FunctionParameterSequenceType("date", 51, 2, "The date to to be formatted."), new FunctionParameterSequenceType("simple-date-format", 22, 2, "The format string according to the Java java.text.SimpleDateFormat class")}, (SequenceType)new FunctionReturnSequenceType(22, 2, "the formatted date string"), FnFormatDates.FNS_FORMAT_DATE_2);

    public FormatDateFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DateValue d = (DateValue)args[0].itemAt(0);
        String dateFormat = args[1].itemAt(0).toString();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        GregorianCalendar cal = d.calendar.toGregorianCalendar();
        String formattedDate = sdf.format(cal.getTime());
        return new StringValue(formattedDate);
    }
}

