/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FnFormatDates;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FormatDateTimeFunction
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FormatDateTimeFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("format-dateTime", "http://exist-db.org/xquery/datetime", "datetime"), "Returns a xs:string of the xs:dateTime according to the SimpleDateFormat format.", new SequenceType[]{new FunctionParameterSequenceType("date-time", 50, 2, "The dateTime to to be formatted."), new FunctionParameterSequenceType("simple-date-format", 22, 2, "The format string according to the Java java.text.SimpleDateFormat class")}, (SequenceType)new FunctionReturnSequenceType(22, 2, "the formatted dateTime string"), FnFormatDates.FNS_FORMAT_DATETIME_2);

    public FormatDateTimeFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DateTimeValue dt = (DateTimeValue)args[0].itemAt(0);
        String dateTimeFormat = args[1].itemAt(0).toString();
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        GregorianCalendar cal = dt.calendar.toGregorianCalendar();
        String formattedDate = sdf.format(cal.getTime());
        return new StringValue(formattedDate);
    }
}

