/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Timestamp
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Timestamp.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("timestamp", "http://exist-db.org/xquery/datetime", "datetime"), "The current time as UTC milliseconds since the Epoch. ", null, (SequenceType)new FunctionReturnSequenceType(42, 2, "milliseconds")), new FunctionSignature(new QName("timestamp", "http://exist-db.org/xquery/datetime", "datetime"), "Return the number of UTC milliseconds since the Epoch for given date-time value. ", new SequenceType[]{new FunctionParameterSequenceType("date-time", 50, 2, "The dateTime to be converted.")}, (SequenceType)new FunctionReturnSequenceType(42, 2, "milliseconds"))};

    public Timestamp(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        long ms;
        if (args.length == 1) {
            AbstractDateTimeValue value = (AbstractDateTimeValue)args[0].itemAt(0);
            ms = value.getTimeInMillis();
        } else {
            ms = System.currentTimeMillis();
        }
        return new IntegerValue(ms);
    }
}

