/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.exi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.serializers.Serializer;
import org.exist.validation.internal.node.NodeInputStream;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Type;

public class EXIUtils {
    private static final Logger LOG = LogManager.getLogger(EXIUtils.class);

    protected static InputStream getInputStream(Item item, XQueryContext context) throws XPathException, MalformedURLException, IOException {
        if (item.getType() == 25) {
            LOG.debug("Streaming xs:anyURI");
            String url = item.getStringValue();
            if (url.startsWith("/")) {
                url = "xmldb:exist://" + url;
            }
            return new URL(url).openStream();
        }
        if (item.getType() == 1 || item.getType() == 6) {
            LOG.debug("Streaming element or document node");
            Serializer serializer = context.getBroker().newSerializer();
            NodeValue node = (NodeValue)item;
            return new NodeInputStream(serializer, node);
        }
        LOG.error("Wrong item type " + Type.getTypeName((int)item.getType()));
        throw new XPathException("wrong item type " + Type.getTypeName((int)item.getType()));
    }
}

