/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class DirectoryCreate
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(DirectoryCreate.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("mkdir", "http://exist-db.org/xquery/file", "file"), "Create a directory.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the directory")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise")), new FunctionSignature(new QName("mkdirs", "http://exist-db.org/xquery/file", "file"), "Create a directory including any necessary but nonexistent parent directories. This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the directory")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise"))};

    public DirectoryCreate(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        BooleanValue created = BooleanValue.FALSE;
        String inputPath = args[0].itemAt(0).getStringValue();
        Path file = FileModuleHelper.getFile(inputPath);
        try {
            if (this.isCalledAs("mkdir") && Files.notExists(file, new LinkOption[0])) {
                Files.createDirectory(file, new FileAttribute[0]);
                created = BooleanValue.TRUE;
            } else if (this.isCalledAs("mkdirs")) {
                Files.createDirectories(file, new FileAttribute[0]);
                created = BooleanValue.TRUE;
            }
            return created;
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, (Throwable)ioe);
        }
    }
}

