/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xslt.TransformerFactoryAllocator;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class Sync
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("sync", "http://exist-db.org/xquery/file", "file"), "Synchronize a collection with a directory hierarchy. Compares last modified time stamps. If $dateTime is given, only resources modified after this time stamp are taken into account. This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("collection", 22, 2, "The collection to sync."), new FunctionParameterSequenceType("targetPath", 11, 2, "The full path or URI to the directory"), new FunctionParameterSequenceType("dateTime", 50, 3, "Optional: only resources modified after the given date/time will be synchronized.")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise"));
    private static final Properties DEFAULT_PROPERTIES = new Properties();

    public Sync(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, "Function file:sync is only available to the DBA role");
        }
        String collectionPath = args[0].getStringValue();
        Date startDate = null;
        if (args[2].hasOne()) {
            DateTimeValue dtv = (DateTimeValue)args[2].itemAt(0);
            startDate = dtv.getDate();
        }
        String target = args[1].getStringValue();
        Path targetDir = FileModuleHelper.getFile(target);
        this.context.pushDocumentContext();
        MemTreeBuilder output = this.context.getDocumentBuilder();
        try {
            if (!targetDir.isAbsolute()) {
                Optional home = this.context.getBroker().getConfiguration().getExistHome();
                targetDir = FileUtils.resolve((Optional)home, (String)target);
            }
            output.startDocument();
            output.startElement(new QName("sync", "http://exist-db.org/xquery/file"), null);
            output.addAttribute(new QName("collection", "http://exist-db.org/xquery/file"), collectionPath);
            output.addAttribute(new QName("dir", "http://exist-db.org/xquery/file"), targetDir.toAbsolutePath().toString());
            this.saveCollection(XmldbURI.create((String)collectionPath), targetDir, startDate, output);
            output.endElement();
            output.endDocument();
        }
        catch (PermissionDeniedException | LockException e) {
            throw new XPathException((Expression)this, e);
        }
        finally {
            this.context.popDocumentContext();
        }
        return output.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCollection(XmldbURI collectionPath, Path targetDir, Date startDate, MemTreeBuilder output) throws PermissionDeniedException, LockException {
        try {
            targetDir = Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            this.reportError(output, "Failed to create output directory: " + targetDir.toAbsolutePath().toString() + " for collection " + collectionPath);
            return;
        }
        if (!Files.isWritable(targetDir)) {
            this.reportError(output, "Failed to write to output directory: " + targetDir.toAbsolutePath().toString());
            return;
        }
        ArrayList subcollections = null;
        Collection collection = null;
        try {
            collection = this.context.getBroker().openCollection(collectionPath, Lock.LockMode.READ_LOCK);
            if (collection == null) {
                this.reportError(output, "Collection not found: " + collectionPath);
                return;
            }
            Iterator i = collection.iterator(this.context.getBroker());
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (startDate != null && doc.getMetadata().getLastModified() <= startDate.getTime()) continue;
                if (doc.getResourceType() == 1) {
                    this.saveBinary(targetDir, (BinaryDocument)doc, output);
                    continue;
                }
                this.saveXML(targetDir, doc, output);
            }
            subcollections = new ArrayList(collection.getChildCollectionCount(this.context.getBroker()));
            i = collection.collectionIterator(this.context.getBroker());
            while (i.hasNext()) {
                subcollections.add(i.next());
            }
        }
        finally {
            if (collection != null) {
                collection.getLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        for (XmldbURI childURI : subcollections) {
            Path childDir = targetDir.resolve(childURI.lastSegment().toString());
            this.saveCollection(collectionPath.append(childURI), childDir, startDate, output);
        }
    }

    private void reportError(MemTreeBuilder output, String msg) {
        output.startElement(new QName("error", "http://exist-db.org/xquery/file"), null);
        output.characters((CharSequence)msg);
        output.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveXML(Path targetDir, DocumentImpl doc, MemTreeBuilder output) {
        block24: {
            Path targetFile = targetDir.resolve(doc.getFileURI().toASCIIString());
            SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            try {
                if (Files.exists(targetFile, new LinkOption[0]) && Files.getLastModifiedTime(targetFile, new LinkOption[0]).compareTo(FileTime.fromMillis(doc.getMetadata().getLastModified())) >= 0) {
                    return;
                }
                boolean isRepoXML = Files.exists(targetFile, new LinkOption[0]) && FileUtils.fileName((Path)targetFile).equals("repo.xml");
                output.startElement(new QName("update", "http://exist-db.org/xquery/file"), null);
                output.addAttribute(new QName("file", ""), targetFile.toAbsolutePath().toString());
                output.addAttribute(new QName("name", ""), doc.getFileURI().toString());
                output.addAttribute(new QName("collection", ""), doc.getCollection().getURI().toString());
                output.addAttribute(new QName("type", ""), "xml");
                output.addAttribute(new QName("modified", ""), new DateTimeValue(new Date(doc.getMetadata().getLastModified())).getStringValue());
                output.endElement();
                if (isRepoXML) {
                    this.processRepoDesc(targetFile, doc, sax, output);
                    break block24;
                }
                try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(targetFile, new OpenOption[0]), "UTF-8");){
                    sax.setOutput((Writer)writer, DEFAULT_PROPERTIES);
                    Serializer serializer = this.context.getBroker().getSerializer();
                    serializer.reset();
                    serializer.setProperties(DEFAULT_PROPERTIES);
                    serializer.setSAXHandlers((ContentHandler)sax, (LexicalHandler)sax);
                    serializer.toSAX(doc);
                }
            }
            catch (IOException e) {
                this.reportError(output, "IO error while saving file: " + targetFile.toAbsolutePath().toString());
            }
            catch (SAXException e) {
                this.reportError(output, "SAX exception while saving file " + targetFile.toAbsolutePath().toString() + ": " + e.getMessage());
            }
            catch (XPathException e) {
                this.reportError(output, e.getMessage());
            }
            finally {
                SerializerPool.getInstance().returnObject((Object)sax);
            }
        }
    }

    private void processRepoDesc(Path targetFile, DocumentImpl doc, SAXSerializer sax, MemTreeBuilder output) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document original = builder.parse(targetFile.toFile());
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(targetFile, new OpenOption[0]), "UTF-8");){
                sax.setOutput((Writer)writer, DEFAULT_PROPERTIES);
                StreamSource stylesource = new StreamSource(Sync.class.getResourceAsStream("repo.xsl"));
                SAXTransformerFactory factory = TransformerFactoryAllocator.getTransformerFactory((BrokerPool)this.context.getBroker().getBrokerPool());
                TransformerHandler handler = factory.newTransformerHandler(stylesource);
                handler.getTransformer().setParameter("original", original.getDocumentElement());
                handler.setResult(new SAXResult((ContentHandler)sax));
                Serializer serializer = this.context.getBroker().getSerializer();
                serializer.reset();
                serializer.setProperties(DEFAULT_PROPERTIES);
                serializer.setSAXHandlers((ContentHandler)handler, (LexicalHandler)handler);
                serializer.toSAX(doc);
            }
        }
        catch (ParserConfigurationException e) {
            this.reportError(output, "Parser exception while saving file " + targetFile.toAbsolutePath().toString() + ": " + e.getMessage());
        }
        catch (SAXException e) {
            this.reportError(output, "SAX exception while saving file " + targetFile.toAbsolutePath().toString() + ": " + e.getMessage());
        }
        catch (IOException e) {
            this.reportError(output, "IO exception while saving file " + targetFile.toAbsolutePath().toString() + ": " + e.getMessage());
        }
        catch (TransformerException e) {
            this.reportError(output, "Transformation exception while saving file " + targetFile.toAbsolutePath().toString() + ": " + e.getMessage());
        }
    }

    private void saveBinary(Path targetDir, BinaryDocument binary, MemTreeBuilder output) {
        Path targetFile = targetDir.resolve(binary.getFileURI().toASCIIString());
        try {
            if (Files.exists(targetFile, new LinkOption[0]) && Files.getLastModifiedTime(targetFile, new LinkOption[0]).compareTo(FileTime.fromMillis(binary.getMetadata().getLastModified())) >= 0) {
                return;
            }
            output.startElement(new QName("update", "http://exist-db.org/xquery/file"), null);
            output.addAttribute(new QName("file"), targetFile.toAbsolutePath().toString());
            output.addAttribute(new QName("name"), binary.getFileURI().toString());
            output.addAttribute(new QName("collection"), binary.getCollection().getURI().toString());
            output.addAttribute(new QName("type"), "binary");
            output.addAttribute(new QName("modified"), new DateTimeValue(new Date(binary.getMetadata().getLastModified())).getStringValue());
            output.endElement();
            try (InputStream is = this.context.getBroker().getBinaryResource(binary);){
                Files.copy(is, targetFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.reportError(output, "IO error while saving file: " + targetFile.toAbsolutePath().toString());
        }
        catch (Exception e) {
            this.reportError(output, e.getMessage());
        }
    }

    static {
        DEFAULT_PROPERTIES.put("indent", "yes");
        DEFAULT_PROPERTIES.put("omit-xml-declaration", "no");
        DEFAULT_PROPERTIES.put("expand-xincludes", "no");
    }
}

