/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.exist.EXistException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public class DBFile
implements PartSource {
    private XmldbURI uri;
    private URLConnection connection = null;

    public DBFile(String uri) {
        this.uri = XmldbURI.create((String)uri);
    }

    private URLConnection getConnection() throws IOException {
        if (this.connection == null) {
            try {
                BrokerPool database = BrokerPool.getInstance();
                try (DBBroker broker = database.getBroker();){
                    Subject subject = broker.getCurrentSubject();
                    URL url = new URL("xmldb:exist://jsessionid:" + subject.getSessionId() + "@" + this.uri.toString());
                    this.connection = url.openConnection();
                }
            }
            catch (IllegalArgumentException | MalformedURLException | EXistException e) {
                throw new IOException(e);
            }
        }
        return this.connection;
    }

    public InputStream createInputStream() throws IOException {
        return this.getConnection().getInputStream();
    }

    public String getFileName() {
        return this.uri.lastSegment().toString();
    }

    public long getLength() {
        try {
            return this.getConnection().getContentLength();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

