/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.mail.MailModule;
import org.exist.xquery.modules.mail.MessageListFunctions;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class MessageFunctions
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(MessageListFunctions.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final Pattern CONTENT_TYPE_RE = Pattern.compile(";\\s*boundary(.*)$");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-messages", "http://exist-db.org/xquery/mail", "mail"), "Returns a sequence of emails as XML.  If there are no messages-numbers in the list, an empty sequence will be returned. Please see get_messages_example.xql.", new SequenceType[]{new FunctionParameterSequenceType("message-list-handle", 31, 2, "The message list handle retrieved from mail:get-message-list() or mail:search-message-list()"), new FunctionParameterSequenceType("message-numbers", 31, 7, "The messages to retrieve using the numbers from the message-list '//mail:message/@number' ")}, (SequenceType)new FunctionReturnSequenceType(1, 3, "the chosen messages as XML mail:messages/mail:message"))};

    public MessageFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("get-messages")) {
            return this.getMessages(args, contextSequence);
        }
        throw new XPathException((Expression)this, "Invalid function name");
    }

    private Sequence getMessages(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence ret = Sequence.EMPTY_SEQUENCE;
        if (args[0].isEmpty()) {
            throw new XPathException((Expression)this, "Mail folder handle not specified");
        }
        long folderHandle = ((IntegerValue)args[0].itemAt(0)).getLong();
        Folder folder = MailModule.retrieveFolder(this.context, folderHandle);
        if (folder == null) {
            throw new XPathException((Expression)this, "Invalid Folder handle specified");
        }
        if (args[1].isEmpty()) {
            return ret;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("messages", "http://exist-db.org/xquery/mail", "mail"), null);
        try {
            int counter = args[1].getItemCount();
            for (int i = 0; i < counter; ++i) {
                Address[] bccAddresses;
                Address[] ccAddresses;
                Message message = null;
                int msgNum = ((IntegerValue)args[1].itemAt(i)).getInt();
                try {
                    message = folder.getMessage(msgNum);
                }
                catch (IndexOutOfBoundsException iex) {
                    logger.info("There is no message number " + msgNum);
                    continue;
                }
                builder.startElement(new QName("message", "http://exist-db.org/xquery/mail", "mail"), null);
                builder.addAttribute(new QName("number", null, null), String.valueOf(message.getMessageNumber()));
                String contentType = message.getContentType();
                this.mimeParamsToAttributes(builder, contentType);
                builder.startElement(new QName("subject", "http://exist-db.org/xquery/mail", "mail"), null);
                builder.characters((CharSequence)message.getSubject());
                builder.endElement();
                if (message.getSentDate() != null) {
                    builder.startElement(new QName("sent", "http://exist-db.org/xquery/mail", "mail"), null);
                    builder.characters((CharSequence)this.formatDate(message.getSentDate()));
                    builder.endElement();
                }
                if (message.getReceivedDate() != null) {
                    builder.startElement(new QName("received", "http://exist-db.org/xquery/mail", "mail"), null);
                    builder.characters((CharSequence)this.formatDate(message.getReceivedDate()));
                    builder.endElement();
                }
                if (message.getFrom() != null) {
                    this.addAddress(builder, "from", null, message.getFrom()[0]);
                }
                builder.startElement(new QName("recipients", "http://exist-db.org/xquery/mail", "mail"), null);
                Address[] toAddresses = message.getRecipients(Message.RecipientType.TO);
                if (toAddresses != null) {
                    for (Address to : toAddresses) {
                        this.addAddress(builder, "recipient", "to", to);
                    }
                }
                if ((ccAddresses = message.getRecipients(Message.RecipientType.CC)) != null) {
                    for (Address ccAddress : ccAddresses) {
                        this.addAddress(builder, "recipient", "cc", ccAddress);
                    }
                }
                if ((bccAddresses = message.getRecipients(Message.RecipientType.BCC)) != null) {
                    for (Address bccAddress : bccAddresses) {
                        this.addAddress(builder, "recipient", "bcc", bccAddress);
                    }
                }
                builder.endElement();
                Object content = message.getContent();
                if (content instanceof Multipart) {
                    this.handleMultipart((Multipart)content, builder);
                } else {
                    this.handlePart((Part)message, builder);
                }
                Flags flags = message.getFlags();
                Flags.Flag[] systemFlags = flags.getSystemFlags();
                String[] userFlags = flags.getUserFlags();
                if (systemFlags.length > 0 || userFlags.length > 0) {
                    builder.startElement(new QName("flags", "http://exist-db.org/xquery/mail", "mail"), null);
                    for (Flags.Flag flag : systemFlags) {
                        if (flag == Flags.Flag.ANSWERED) {
                            this.addFlag(builder, "answered");
                            continue;
                        }
                        if (flag == Flags.Flag.DELETED) {
                            this.addFlag(builder, "deleted");
                            continue;
                        }
                        if (flag == Flags.Flag.DRAFT) {
                            this.addFlag(builder, "draft");
                            continue;
                        }
                        if (flag == Flags.Flag.FLAGGED) {
                            this.addFlag(builder, "flagged");
                            continue;
                        }
                        if (flag == Flags.Flag.RECENT) {
                            this.addFlag(builder, "recent");
                            continue;
                        }
                        if (flag != Flags.Flag.SEEN) continue;
                        this.addFlag(builder, "seen");
                    }
                    for (String string : userFlags) {
                        builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
                        builder.addAttribute(new QName("type", null, null), "user");
                        builder.addAttribute(new QName("value", null, null), string);
                        builder.endElement();
                    }
                    builder.endElement();
                }
                builder.endElement();
            }
        }
        catch (MessagingException me) {
            throw new XPathException((Expression)this, "Failed to retrieve messages from list", (Throwable)me);
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
        }
        builder.endElement();
        builder.endDocument();
        ret = (NodeValue)builder.getDocument().getDocumentElement();
        return ret;
    }

    private void addFlag(MemTreeBuilder builder, String flag) {
        builder.startElement(new QName("flag", "http://exist-db.org/xquery/mail", "mail"), null);
        builder.addAttribute(new QName("type", null, null), flag);
        builder.endElement();
    }

    private void addAddress(MemTreeBuilder builder, String element, String attrVal, Address addr) {
        InternetAddress ia;
        builder.startElement(new QName(element, "http://exist-db.org/xquery/mail", "mail"), null);
        if (attrVal != null) {
            builder.addAttribute(new QName("type", null, null), attrVal);
        }
        if ((ia = (InternetAddress)addr).getPersonal() != null) {
            builder.addAttribute(new QName("personal", null, null), ia.getPersonal());
            builder.characters((CharSequence)ia.getAddress());
        } else {
            builder.characters((CharSequence)ia.getAddress());
        }
        builder.endElement();
    }

    private String formatDate(Date date) {
        String formatted = "";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String temp = sdf.format(date);
        formatted = temp.substring(0, temp.length() - 2) + ":" + temp.substring(temp.length() - 2);
        return formatted;
    }

    private void handleMultipart(Multipart multipart, MemTreeBuilder builder) throws MessagingException, IOException, XPathException, SAXException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            this.handlePart((Part)multipart.getBodyPart(i), builder);
        }
    }

    private void mimeParamsToAttributes(MemTreeBuilder builder, String contentType) {
        try {
            MimeType m = new MimeType(contentType);
            builder.addAttribute(new QName("mime-type", null, null), m.getBaseType());
            MimeTypeParameterList mtpl = m.getParameters();
            Enumeration e = mtpl.getNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                builder.addAttribute(new QName(key, null, null), mtpl.get(key));
            }
        }
        catch (MimeTypeParseException e) {
            e.printStackTrace();
        }
    }

    private void handlePart(Part part, MemTreeBuilder builder) throws MessagingException, IOException, XPathException, SAXException {
        Object content = part.getContent();
        if (content instanceof Multipart) {
            this.handleMultipart((Multipart)content, builder);
            return;
        }
        String disposition = part.getDisposition();
        String contentType = part.getContentType();
        if (contentType.contains("text/plain")) {
            builder.startElement(new QName("text", "http://exist-db.org/xquery/mail", "mail"), null);
            this.mimeParamsToAttributes(builder, part.getContentType());
            builder.characters((CharSequence)part.getContent().toString());
            builder.endElement();
        } else if (contentType.contains("text/html")) {
            builder.startElement(new QName("xhtml", "http://exist-db.org/xquery/mail", "mail"), null);
            this.mimeParamsToAttributes(builder, part.getContentType());
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
            DocumentImpl html = ModuleUtils.htmlToXHtml((XQueryContext)this.context, (Source)new StreamSource(part.getInputStream()), null, null);
            ElementImpl rootElem = (ElementImpl)html.getDocumentElement();
            html.copyTo((NodeImpl)rootElem, receiver);
            builder.endElement();
        } else if (disposition.equalsIgnoreCase("attachment")) {
            builder.startElement(new QName("attachment", "http://exist-db.org/xquery/mail", "mail"), null);
            builder.addAttribute(new QName("filename", null, null), part.getFileName());
            this.mimeParamsToAttributes(builder, part.getContentType());
            this.handleBinaryContent(part, builder);
            builder.endElement();
        } else if (disposition.equalsIgnoreCase("inline")) {
            builder.startElement(new QName("inline", "http://exist-db.org/xquery/mail", "mail"), null);
            MimeBodyPart mbp = (MimeBodyPart)part;
            builder.addAttribute(new QName("filename", null, null), mbp.getFileName());
            if (mbp.getContentID() != null) {
                builder.addAttribute(new QName("content-id", null, null), "cid:" + mbp.getContentID().replaceAll("^<|>$", ""));
            }
            this.mimeParamsToAttributes(builder, part.getContentType());
            this.handleBinaryContent(part, builder);
            builder.endElement();
        } else {
            builder.startElement(new QName("other", "http://exist-db.org/xquery/mail", "mail"), null);
            this.mimeParamsToAttributes(builder, part.getContentType());
            builder.addAttribute(new QName("disposition", null, null), part.getDisposition());
            builder.characters((CharSequence)part.getContent().toString());
            builder.endElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBinaryContent(Part part, MemTreeBuilder builder) throws IOException, MessagingException, XPathException {
        builder.addAttribute(new QName("type", null, null), "binary");
        builder.addAttribute(new QName("encoding", null, null), "Base64Encoded");
        BinaryValueFromInputStream binary = null;
        try {
            binary = BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)part.getInputStream());
            builder.characters((CharSequence)binary.getStringValue());
        }
        finally {
            if (binary != null) {
                binary.destroy(this.context, null);
            }
        }
    }
}

