/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import java.util.Properties;
import org.exist.dom.QName;
import org.exist.scheduler.JobDescription;
import org.exist.scheduler.Scheduler;
import org.exist.scheduler.UserJavaJob;
import org.exist.scheduler.UserJob;
import org.exist.scheduler.UserXQueryJob;
import org.exist.security.Subject;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScheduleFunctions
extends BasicFunction {
    public static final String SCHEDULE_XQUERY_CRON_JOB = "schedule-xquery-cron-job";
    public static final String SCHEDULE_XQUERY_PERIODIC_JOB = "schedule-xquery-periodic-job";
    public static final String SCHEDULE_JAVA_CRON_JOB = "schedule-java-cron-job";
    public static final String SCHEDULE_JAVA_PERIODIC_JOB = "schedule-java-periodic-job";
    private static final FunctionSignature scheduleJavaCronJobNoParam = new FunctionSignature(new QName("schedule-java-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the Java Class named (the class must extend org.exist.scheduler.UserJavaJob) according to the Cron expression. The job will be registered using the job name.", new SequenceType[]{new FunctionParameterSequenceType("java-classname", 22, 2, "The full name of the class to be executed.  It must extend the org.exist.scheduler.UserJavaJob class."), new FunctionParameterSequenceType("cron-expression", 22, 2, "The cron expression.  Please see the scheduler documentation."), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job.")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "a flag indicating successful execution"));
    private static final FunctionSignature scheduleJavaCronJobParam = new FunctionSignature(new QName("schedule-java-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the Java Class named (the class must extend org.exist.scheduler.UserJavaJob) according to the Cron expression. The job will be registered using the name passed in $job-name. The final argument can be used to specify parameters for the job, which will be passed to the query as external variables. Parameters are specified in an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>.", new SequenceType[]{new FunctionParameterSequenceType("java-classname", 22, 2, "The full name of the class to be executed.  It must extend the org.exist.scheduler.UserJavaJob class."), new FunctionParameterSequenceType("cron-expression", 22, 2, "The cron expression.  Please see the scheduler documentation."), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job."), new FunctionParameterSequenceType("job-parameters", 1, 3, "The XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "a flag indicating successful execution"));
    private static final FunctionSignature scheduleJavaPeriodicParam = new FunctionSignature(new QName("schedule-java-periodic-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the Java Class named (the class must extend org.exist.scheduler.UserJavaJob) according to the periodic value. The job will be registered using the job name. The $job-parameters argument can be used to specify parameters for the job, which will be passed to the query as external variables. Parameters are specified in an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>,  Given the delay and the repeat.", new SequenceType[]{new FunctionParameterSequenceType("java-classname", 22, 2, "The full name of the class to be executed.  It must extend the org.exist.scheduler.UserJavaJob class."), new FunctionParameterSequenceType("period", 31, 2, "Time in milliseconds between execution of the job"), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job."), new FunctionParameterSequenceType("job-parameters", 1, 3, "The XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>"), new FunctionParameterSequenceType("delay", 31, 2, "The period in milliseconds to delay the start of a job."), new FunctionParameterSequenceType("repeat", 31, 2, "The number of times to repeat the job after the initial execution. A value of -1 means repeat forever.")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "a flag indicating successful execution"));
    private static final FunctionSignature scheduleXQueryCronJobNoParam = new FunctionSignature(new QName("schedule-xquery-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the named XQuery resource (e.g. /db/foo.xql) according to the Cron expression. XQuery job's will be launched under the guest account initially, although the running XQuery may switch permissions through calls to xmldb:login(). The job will be registered using the job name.", new SequenceType[]{new FunctionParameterSequenceType("xquery-resource", 22, 2, "The path to the XQuery resource"), new FunctionParameterSequenceType("cron-expression", 22, 2, "The cron expression.  Please see the scheduler documentation."), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job.")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "a flag indicating successful execution"));
    private static final FunctionSignature scheduleXQueryCronJobParam = new FunctionSignature(new QName("schedule-xquery-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the named XQuery resource (e.g. /db/foo.xql) according to the Cron expression. XQuery job's will be launched under the guest account initially, although the running XQuery may switch permissions through calls to xmldb:login(). The job will be registered using the job name. The final argument can be used to specify parameters for the job, which will be passed to the query as external variables. Parameters are specified in an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>", new SequenceType[]{new FunctionParameterSequenceType("xquery-resource", 22, 2, "The path to the XQuery resource"), new FunctionParameterSequenceType("cron-expression", 22, 2, "A cron expression.  Please see the scheduler documentation."), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job."), new FunctionParameterSequenceType("job-parameters", 1, 3, "XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "Flag indicating successful execution"));
    private static final FunctionSignature scheduleXQueryCronJobParamException = new FunctionSignature(new QName("schedule-xquery-cron-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the named XQuery resource (e.g. /db/foo.xql) according to the Cron expression. XQuery job's will be launched under the guest account initially, although the running XQuery may switch permissions through calls to xmldb:login(). The job will be registered using the job name. The job parameters argument can be used to specify parameters for the job, which will be passed to the query as external variables. Parameters are specified in an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>", new SequenceType[]{new FunctionParameterSequenceType("xquery-resource", 22, 2, "The path to the XQuery resource"), new FunctionParameterSequenceType("cron-expression", 22, 2, "A cron expression.  Please see the scheduler documentation."), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job."), new FunctionParameterSequenceType("job-parameters", 1, 3, "XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>"), new FunctionParameterSequenceType("unschedule", 23, 2, "Specifies whether to unschedule this job if an XPathException is raised, default is true.")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "Flag indicating successful execution"));
    private static final FunctionSignature scheduleXQueryPeriodicParam = new FunctionSignature(new QName("schedule-xquery-periodic-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the named XQuery resource (e.g. /db/foo.xql) according to the period. XQuery job's will be launched under the guest account initially, although the running XQuery may switch permissions through calls to xmldb:login(). The job will be registered using the job name. The job parameters argument can be used to specify parameters for the job, which will be passed to the query as external variables. Parameters are specified in an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>,  Given the delay passed and the repeat value.", new SequenceType[]{new FunctionParameterSequenceType("xquery-resource", 22, 2, "The path to the XQuery resource"), new FunctionParameterSequenceType("period", 31, 2, "Time in milliseconds between execution of the job"), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job."), new FunctionParameterSequenceType("job-parameters", 1, 3, "XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>"), new FunctionParameterSequenceType("delay", 31, 2, "Can be used with a period in milliseconds to delay the start of a job."), new FunctionParameterSequenceType("repeat", 31, 2, "Number of times to repeat the job after the initial execution. A value of -1 means repeat forever.")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "Flag indicating successful execution"));
    private static final FunctionSignature scheduleXQueryPeriodicParamException = new FunctionSignature(new QName("schedule-xquery-periodic-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Schedules the named XQuery resource (e.g. /db/foo.xql) according to the period. XQuery job's will be launched under the guest account initially, although the running XQuery may switch permissions through calls to xmldb:login(). The job will be registered using the job name. The job parameters argument can be used to specify parameters for the job, which will be passed to the query as external variables. Parameters are specified in an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>,  Given the delay passed and the repeat value.", new SequenceType[]{new FunctionParameterSequenceType("xquery-resource", 22, 2, "The path to the XQuery resource"), new FunctionParameterSequenceType("period", 31, 2, "Time in milliseconds between execution of the job"), new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job."), new FunctionParameterSequenceType("job-parameters", 1, 3, "XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>"), new FunctionParameterSequenceType("delay", 31, 2, "Can be used with a period in milliseconds to delay the start of a job."), new FunctionParameterSequenceType("repeat", 31, 2, "Number of times to repeat the job after the initial execution. A value of -1 means repeat forever."), new FunctionParameterSequenceType("unschedule", 23, 2, "Specifies whether to unschedule this job if an XPathException is raised, default is true.")}, (SequenceType)new FunctionParameterSequenceType("success", 23, 2, "Flag indicating successful execution"));
    public static final FunctionSignature[] signatures = new FunctionSignature[]{scheduleJavaCronJobNoParam, scheduleJavaCronJobParam, scheduleJavaPeriodicParam, scheduleXQueryCronJobNoParam, scheduleXQueryCronJobParam, scheduleXQueryCronJobParamException, scheduleXQueryPeriodicParam, scheduleXQueryPeriodicParamException};
    private Scheduler scheduler = null;

    public ScheduleFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Subject user;
        boolean isPeriodic;
        String resource = args[0].getStringValue();
        boolean unschedule = true;
        long periodicValue = 0L;
        long delayValue = 0L;
        int repeatValue = -1;
        String jobName = args[2].getStringValue();
        Properties properties = null;
        boolean bl = isPeriodic = this.isCalledAs(SCHEDULE_XQUERY_PERIODIC_JOB) || this.isCalledAs(SCHEDULE_JAVA_PERIODIC_JOB);
        if (this.getArgumentCount() >= 4 && args[3].hasOne()) {
            Node options = ((NodeValue)args[3].itemAt(0)).getNode();
            properties = new Properties();
            this.parseParameters(options, properties);
        }
        if (isPeriodic && this.getArgumentCount() >= 5) {
            delayValue = ((IntegerValue)args[4].itemAt(0)).getLong();
        }
        if (isPeriodic && this.getArgumentCount() >= 6) {
            repeatValue = ((IntegerValue)args[5].itemAt(0)).getInt();
        }
        if (!(user = this.context.getSubject()).hasDbaRole()) {
            return BooleanValue.FALSE;
        }
        Object job = null;
        boolean isCron = true;
        if (this.isCalledAs(SCHEDULE_XQUERY_CRON_JOB)) {
            if (this.getArgumentCount() >= 5) {
                unschedule = args[4].effectiveBooleanValue();
            }
            job = new UserXQueryJob(jobName, resource, user);
        } else if (this.isCalledAs(SCHEDULE_XQUERY_PERIODIC_JOB)) {
            if (this.getArgumentCount() >= 7) {
                unschedule = args[6].effectiveBooleanValue();
            }
            periodicValue = ((IntegerValue)args[1].itemAt(0)).getLong();
            job = new UserXQueryJob(jobName, resource, user);
            isCron = false;
        } else if (this.isCalledAs(SCHEDULE_JAVA_CRON_JOB) || this.isCalledAs(SCHEDULE_JAVA_PERIODIC_JOB)) {
            if (this.isCalledAs(SCHEDULE_JAVA_PERIODIC_JOB)) {
                periodicValue = ((IntegerValue)args[1].itemAt(0)).getLong();
                isCron = false;
            }
            try {
                Class<?> jobClass = Class.forName(resource);
                job = jobClass.newInstance();
                if (!(job instanceof UserJavaJob)) {
                    LOG.error("Cannot Schedule job. Class " + resource + " is not an instance of org.exist.scheduler.UserJavaJob");
                    return BooleanValue.FALSE;
                }
                ((UserJavaJob)job).setName(jobName);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException cnfe) {
                LOG.error((Object)cnfe);
                return BooleanValue.FALSE;
            }
        }
        if (job != null) {
            if (isCron) {
                String cronExpression = args[1].getStringValue();
                if (this.scheduler.createCronJob(cronExpression, (JobDescription)((UserJob)job), properties, unschedule)) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            if (this.scheduler.createPeriodicJob(periodicValue, (JobDescription)((UserJob)job), delayValue, properties, repeatValue, unschedule)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    private void parseParameters(Node options, Properties properties) throws XPathException {
        if (options.getNodeType() == 1 && options.getLocalName().equals("parameters")) {
            for (Node child = options.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getLocalName().equals("param")) continue;
                Element elem = (Element)child;
                String name = elem.getAttribute("name");
                String value = elem.getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing for stylesheet parameter");
                }
                properties.setProperty(name, value);
            }
        }
    }
}

