/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xslfo;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.fop.apps.EnvironmentProfile;
import org.apache.fop.apps.EnvironmentalProfileFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.model.EventSeverity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.apache.xmlgraphics.io.URIResolverAdapter;
import org.exist.dom.memtree.NodeImpl;
import org.exist.storage.DBBroker;
import org.exist.xquery.modules.xslfo.ProcessorAdapter;
import org.exist.xquery.value.NodeValue;
import org.exist.xslt.EXistURIResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ApacheFopProcessorAdapter
implements ProcessorAdapter {
    private static final Logger LOG = LogManager.getLogger(ApacheFopProcessorAdapter.class);
    private static final String DEFAULT_BASE_URI = "exist://localhost/db/";

    @Override
    public ContentHandler getContentHandler(DBBroker broker, NodeValue configFile, Properties parameters, String mimeType, OutputStream os) throws SAXException {
        try {
            FopFactoryBuilder builder;
            if (configFile != null) {
                FopConfigurationBuilder cfgBuilder = new FopConfigurationBuilder(broker);
                Configuration cfg = cfgBuilder.buildFromNode(configFile);
                URI defaultBaseURI = configFile instanceof NodeImpl ? new URI(DEFAULT_BASE_URI) : new URI("exist://localhost" + configFile.getOwnerDocument().getBaseURI());
                EnvironmentProfile environment = EnvironmentalProfileFactory.createDefault((URI)defaultBaseURI, (ResourceResolver)this.getResourceResolver(broker, defaultBaseURI.toString()));
                builder = new FopFactoryBuilder(environment).setConfiguration(cfg);
            } else {
                URI defaultBaseURI = new URI(DEFAULT_BASE_URI);
                EnvironmentProfile environment = EnvironmentalProfileFactory.createDefault((URI)defaultBaseURI, (ResourceResolver)this.getResourceResolver(broker, defaultBaseURI.toString()));
                builder = new FopFactoryBuilder(environment);
            }
            FopFactory fopFactory = builder.build();
            FOUserAgent foUserAgent = this.setupFOUserAgent(fopFactory.newFOUserAgent(), parameters);
            foUserAgent.getEventBroadcaster().addEventListener((EventListener)new ExistLoggingEventListener(LOG));
            Fop fop = fopFactory.newFop(mimeType, foUserAgent, os);
            return fop.getDefaultHandler();
        }
        catch (URISyntaxException e) {
            throw new SAXException("Unable to parse baseURI", e);
        }
    }

    @Override
    public void cleanup() {
    }

    private FOUserAgent setupFOUserAgent(FOUserAgent foUserAgent, Properties parameters) {
        foUserAgent.setProducer("eXist-db with Apache FOP");
        if (parameters != null) {
            for (Map.Entry<Object, Object> paramEntry : parameters.entrySet()) {
                String key = (String)paramEntry.getKey();
                String value = (String)paramEntry.getValue();
                if (key.equals("FOPauthor")) {
                    foUserAgent.setAuthor(value);
                    continue;
                }
                if (key.equals("FOPtitle")) {
                    foUserAgent.setTitle(value);
                    continue;
                }
                if (key.equals("FOPkeywords")) {
                    foUserAgent.setTitle(value);
                    continue;
                }
                if (!key.equals("FOPdpi")) continue;
                try {
                    foUserAgent.setTargetResolution(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Unable to set DPI to: " + value);
                }
            }
        }
        return foUserAgent;
    }

    private ResourceResolver getResourceResolver(DBBroker broker, String baseUri) {
        ResourceResolverFactory.SchemeAwareResourceResolverBuilder builder = ResourceResolverFactory.createSchemeAwareResourceResolverBuilder((ResourceResolver)ResourceResolverFactory.createDefaultResourceResolver());
        URIResolverAdapter uriResolver = new URIResolverAdapter((URIResolver)new ExistSchemeRewriter(new EXistURIResolver(broker.getBrokerPool(), baseUri)));
        builder.registerResourceResolverForScheme("exist", (ResourceResolver)uriResolver);
        builder.registerResourceResolverForScheme("http", (ResourceResolver)uriResolver);
        builder.registerResourceResolverForScheme("https", (ResourceResolver)uriResolver);
        return builder.build();
    }

    private static class ExistLoggingEventListener
    implements EventListener {
        private final Logger log;
        private final Set<String> loggedMessages = new HashSet<String>();

        public ExistLoggingEventListener(Logger log) {
            this.log = log;
        }

        public void processEvent(Event event) {
            String msg = EventFormatter.format((Event)event);
            EventSeverity severity = event.getSeverity();
            if (severity == EventSeverity.INFO) {
                this.log.info(msg);
            } else if (severity == EventSeverity.WARN) {
                String eventGroupID = event.getEventGroupID();
                if (eventGroupID.equals("org.apache.fop.fonts.FontEventProducer")) {
                    if (!this.loggedMessages.contains(msg)) {
                        this.loggedMessages.add(msg);
                        this.log.warn(msg);
                    }
                } else {
                    this.log.warn(msg);
                }
            } else if (severity == EventSeverity.ERROR) {
                if (event.getParam("e") != null) {
                    this.log.error(msg, (Throwable)event.getParam("e"));
                } else {
                    this.log.error(msg);
                }
            } else if (severity == EventSeverity.FATAL) {
                if (event.getParam("e") != null) {
                    this.log.fatal(msg, (Throwable)event.getParam("e"));
                } else {
                    this.log.fatal(msg);
                }
            } else assert (false);
        }
    }

    private static class FopConfigurationBuilder
    extends DefaultConfigurationBuilder {
        private final DBBroker broker;

        public FopConfigurationBuilder(DBBroker broker) {
            this.broker = broker;
        }

        public FopConfigurationBuilder(DBBroker broker, boolean enableNamespaces) {
            super(enableNamespaces);
            this.broker = broker;
        }

        public Configuration buildFromNode(NodeValue configFile) throws SAXException {
            SAXConfigurationHandler handler = this.getHandler();
            handler.clear();
            configFile.toSAX(this.broker, (ContentHandler)handler, new Properties());
            return handler.getConfiguration();
        }
    }

    private static class ExistSchemeRewriter
    implements URIResolver {
        private final EXistURIResolver eXistURIResolver;

        public ExistSchemeRewriter(EXistURIResolver eXistURIResolver) {
            this.eXistURIResolver = eXistURIResolver;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return this.eXistURIResolver.resolve(this.rewriteScheme(href), this.rewriteScheme(base));
        }

        private String rewriteScheme(String uri) {
            if (uri != null) {
                if (uri.startsWith("exist://localhost")) {
                    uri = uri.replace("exist://localhost/db", "/db");
                } else if (uri.startsWith("exist://")) {
                    uri = uri.replace("exist://", "xmldb:exist://");
                }
            }
            return uri;
        }
    }
}

