/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exquery.http.AcceptHeader;
import org.exquery.http.HttpMethod;
import org.exquery.http.HttpRequest;
import org.exquery.http.HttpResponse;
import org.exquery.restxq.ResourceFunction;
import org.exquery.restxq.ResourceFunctionExecuter;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceException;
import org.exquery.restxq.RestXqServiceSerializer;
import org.exquery.restxq.annotation.ConsumesAnnotation;
import org.exquery.restxq.annotation.HttpMethodAnnotation;
import org.exquery.restxq.annotation.HttpMethodWithBodyAnnotation;
import org.exquery.restxq.annotation.ParameterAnnotation;
import org.exquery.restxq.annotation.ProducesAnnotation;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xdm.type.StringTypedValue;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.TypedArgumentValue;
import org.exquery.xquery.TypedValue;
import org.exquery.xquery3.FunctionSignature;

public abstract class AbstractRestXqService
implements RestXqService {
    private final ResourceFunction resourceFunction;

    public AbstractRestXqService(ResourceFunction resourceFunction) {
        this.resourceFunction = resourceFunction;
    }

    public ResourceFunction getResourceFunction() {
        return this.resourceFunction;
    }

    public EnumSet<HttpMethod> getServicedMethods() {
        EnumSet<HttpMethod> servicedMethods = EnumSet.noneOf(HttpMethod.class);
        for (HttpMethodAnnotation httpMethodAnnotation : this.getResourceFunction().getHttpMethodAnnotations()) {
            servicedMethods.add(httpMethodAnnotation.getHttpMethod());
        }
        return servicedMethods;
    }

    public boolean canService(HttpRequest request) {
        if (this.getServicedMethods().contains(request.getMethod())) {
            if (this.getResourceFunction().getPathAnnotation() != null && !this.getResourceFunction().getPathAnnotation().matchesPath(request.getPath())) {
                return false;
            }
            if (!this.canServiceConsume(request)) {
                return false;
            }
            return this.canServiceProduce(request);
        }
        return false;
    }

    private boolean canServiceConsume(HttpRequest request) {
        if (this.getResourceFunction().getConsumesAnnotations().isEmpty()) {
            return true;
        }
        for (ConsumesAnnotation consumesAnnotation : this.getResourceFunction().getConsumesAnnotations()) {
            if (!consumesAnnotation.matchesMediaType(request)) continue;
            return true;
        }
        return false;
    }

    private boolean canServiceProduce(HttpRequest request) {
        if (this.getResourceFunction().getProducesAnnotations().isEmpty()) {
            return true;
        }
        for (ProducesAnnotation producesAnnotation : this.getResourceFunction().getProducesAnnotations()) {
            if (!producesAnnotation.matchesMediaType(request)) continue;
            return true;
        }
        return false;
    }

    public float maxProducesQualityFactor(AcceptHeader acceptHeader) {
        float max = 0.0f;
        for (AcceptHeader.Accept accept : acceptHeader.getAccepts()) {
            for (ProducesAnnotation producesAnnotation : this.getResourceFunction().getProducesAnnotations()) {
                if (!producesAnnotation.matchesMediaType(accept.getMediaRange()) || !(accept.getQualityFactor() > max)) continue;
                max = accept.getQualityFactor();
            }
        }
        return max;
    }

    public void service(HttpRequest request, HttpResponse response, ResourceFunctionExecuter resourceFunctionExecuter, RestXqServiceSerializer restXqServiceSerializer) throws RestXqServiceException {
        Set<TypedArgumentValue> typedArgumentValues = this.extractParameters(request);
        Sequence result = resourceFunctionExecuter.execute(this.getResourceFunction(), typedArgumentValues, request);
        restXqServiceSerializer.serialize(result, this.getResourceFunction().getSerializationAnnotations(), response);
    }

    protected Set<HttpMethodWithBodyAnnotation> getBodyContentAnnotations() {
        HashSet<HttpMethodWithBodyAnnotation> bodyContentAnnotations = new HashSet<HttpMethodWithBodyAnnotation>();
        for (HttpMethodAnnotation methodAnnotation : this.getResourceFunction().getHttpMethodAnnotations()) {
            if (!(methodAnnotation instanceof HttpMethodWithBodyAnnotation)) continue;
            bodyContentAnnotations.add((HttpMethodWithBodyAnnotation)methodAnnotation);
        }
        return bodyContentAnnotations;
    }

    protected Set<TypedArgumentValue> extractParameters(HttpRequest request) throws RestXqServiceException {
        HashSet<TypedArgumentValue> paramNameValues = new HashSet<TypedArgumentValue>();
        if (this.getResourceFunction().getPathAnnotation() != null) {
            for (final Map.Entry pathParameter : this.getResourceFunction().getPathAnnotation().extractPathParameters(request.getPath()).entrySet()) {
                paramNameValues.add((TypedArgumentValue)new TypedArgumentValue<String>(){

                    public String getArgumentName() {
                        return (String)pathParameter.getKey();
                    }

                    public Sequence<String> getTypedValue() {
                        return new SequenceImpl((TypedValue)new StringTypedValue((String)pathParameter.getValue()));
                    }
                });
            }
        }
        if (!this.getBodyContentAnnotations().isEmpty()) {
            final Sequence requestBody = this.extractRequestBody(request);
            for (final HttpMethodWithBodyAnnotation bodyContentAnnotation : this.getBodyContentAnnotations()) {
                paramNameValues.add(new TypedArgumentValue(){

                    public String getArgumentName() {
                        return bodyContentAnnotation.getBodyParameterName();
                    }

                    public Sequence getTypedValue() {
                        if (requestBody != null) {
                            return requestBody;
                        }
                        return Sequence.EMPTY_SEQUENCE;
                    }
                });
            }
        }
        for (ParameterAnnotation parameterAnnotation : this.getResourceFunction().getParameterAnnotations()) {
            final TypedArgumentValue typedArgumentValue = parameterAnnotation.extractParameter(request);
            paramNameValues.add(new TypedArgumentValue(){

                public String getArgumentName() {
                    return typedArgumentValue.getArgumentName();
                }

                public Sequence getTypedValue() {
                    return typedArgumentValue.getTypedValue();
                }
            });
        }
        return paramNameValues;
    }

    protected abstract Sequence extractRequestBody(HttpRequest var1) throws RestXqServiceException;

    public int hashCode() {
        FunctionSignature fnSignature = this.getResourceFunction().getFunctionSignature();
        return this.getResourceFunction().getXQueryLocation().hashCode() ^ fnSignature.getName().hashCode() ^ fnSignature.getArgumentCount() * 32;
    }

    public boolean equals(Object obj) {
        FunctionSignature fnSignature = this.getResourceFunction().getFunctionSignature();
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestXqService)) {
            return false;
        }
        RestXqService other = (RestXqService)obj;
        return other.getResourceFunction().getXQueryLocation().equals(this.getResourceFunction().getXQueryLocation()) && other.getResourceFunction().getFunctionSignature().getName().equals(fnSignature.getName()) && other.getResourceFunction().getFunctionSignature().getArgumentCount() == fnSignature.getArgumentCount();
    }

    public int compareTo(RestXqService other) {
        if (other == null || !(other instanceof RestXqService)) {
            return 1;
        }
        long pathSpecificityMetric = this.getResourceFunction().getPathAnnotation() != null ? this.getResourceFunction().getPathAnnotation().getPathSpecificityMetric() : 0L;
        long otherPathSpecificityMetric = other.getResourceFunction().getPathAnnotation() != null ? other.getResourceFunction().getPathAnnotation().getPathSpecificityMetric() : 0L;
        long result = otherPathSpecificityMetric - pathSpecificityMetric;
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        return 0;
    }
}

