/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl;

import java.net.URI;
import java.util.Set;
import javax.xml.namespace.QName;
import org.exquery.ExQueryException;
import org.exquery.restxq.ResourceFunction;
import org.exquery.restxq.annotation.ConsumesAnnotation;
import org.exquery.restxq.annotation.HttpMethodAnnotation;
import org.exquery.restxq.annotation.ParameterAnnotation;
import org.exquery.restxq.annotation.PathAnnotation;
import org.exquery.restxq.annotation.ProducesAnnotation;
import org.exquery.restxq.impl.ResourceFunctionImpl;
import org.exquery.serialization.annotation.SerializationAnnotation;
import org.exquery.xquery3.Annotation;

public class ResourceFunctionFactory {
    public static boolean isResourceFunctionAnnotation(QName annotationName) {
        return annotationName.getNamespaceURI().equals("http://exquery.org/ns/restxq") || annotationName.getNamespaceURI().equals("http://www.w3.org/2010/xslt-xquery-serialization");
    }

    public static ResourceFunction create(URI xQueryLocation, Set<Annotation> annotations) throws ExQueryException {
        ResourceFunctionImpl resourceFunction = new ResourceFunctionImpl();
        resourceFunction.setXQueryLocation(xQueryLocation);
        if (annotations == null || annotations.isEmpty()) {
            throw new ExQueryException("A Resource Function must have at least one RESTXQ Annotation");
        }
        for (Annotation annotation : annotations) {
            if (!ResourceFunctionFactory.isResourceFunctionAnnotation(annotation.getName())) {
                throw new ExQueryException("Annotation is not a valid EXQuery RESTXQ or Serialization Annotation");
            }
            if (annotation instanceof PathAnnotation) {
                resourceFunction.setPathAnnotation((PathAnnotation)annotation);
                continue;
            }
            if (annotation instanceof HttpMethodAnnotation) {
                resourceFunction.getHttpMethodAnnotations().add((HttpMethodAnnotation)annotation);
                continue;
            }
            if (annotation instanceof ConsumesAnnotation) {
                resourceFunction.getConsumesAnnotations().add((ConsumesAnnotation)annotation);
                continue;
            }
            if (annotation instanceof ProducesAnnotation) {
                resourceFunction.getProducesAnnotations().add((ProducesAnnotation)annotation);
                continue;
            }
            if (annotation instanceof ParameterAnnotation) {
                resourceFunction.getParameterAnnotations().add((ParameterAnnotation)annotation);
                continue;
            }
            if (!(annotation instanceof SerializationAnnotation)) continue;
            resourceFunction.getSerializationAnnotations().add((SerializationAnnotation)annotation);
        }
        resourceFunction.setFunctionSignature(annotations.iterator().next().getFunctionSignature());
        return resourceFunction;
    }
}

